	;
	; Barbarians ZX
	; Display routines
	;
	; These routines and associated data handle the display during the
	; course of a game.  Routines control the left and right panel
	; contents, the map, and the message window underneath the map.
	;
	; This file is INCLUDEd from game.asm and shouldn't be assembled on
	; its own.
	;
	; Copyright (C) Damian Walker 2012
	;

	;
	; Error messages
	;

	; print an error message and pause for two seconds
.errprt	call notprt	; notification acts the same
	jp cursor	; back to the map

	; print a notification message and pause for two seconds
.notprt	push bc		; store registers on the stack
	push de		;
	push hl		;
	call msgprt	; display the message first
	ld b,$64	; wait for 2 seconds
.notwt	halt		; wait for interrupt
	djnz notwt	; continue until 100 ticks are passed
	pop hl		; retrieve registers from the stack
	pop de		;
	pop bc		;
	ret		; done

	;
	; The left-hand WORLD or EMPIRE panel
	;

	; print the WORLD panel
.panwld	ld a,(ttlfod)	; ascertain world total of food
	ld c,$00	; we want it in first field of world panel
	call numprt	; print it
	ld a,(ttlwod)	; ascertain world total of wood
	ld c,$01	; to be printed in second field of world panel
	call numprt	; print it
	ld a,(ttlirn)	; ascertain world total of iron
	ld c,$02	; to be printed in third field of world panel
	call numprt	; print it
	ld a,(ttlgld)	; ascertain world total of gold
	ld c,$03	; to be printed in fourth field of world panel
	call numprt	; print it
	ld a,(ttltrp)	; ascertain total number of troops
	ld c,$04	; to be printed in fifth field of world panel
	call numprt	; print it
	ld a,(ttlbar)	; ascertain total number of barbarians
	ld c,$05	; to be printed in sixth field of world panel
	call numprt	; print it
	ret		; job done

	;
	; The right-hand LOCAL panel in all its manifestations
	;

	; special entry point - find out where map cursor is first
.panlcm	ld a,(mapcur)	; what map location is the cursor on?
	ld l,a		; put it in L
	ld h,datmap/256	; make sure H points to the map page
	ld a,(hl)	; load map square contents into A

	; usual entry point: determine what kind of square we're looking at
.panlcl	push af		; remember the map square contents
	ld de,$403c	; draw to little terrain window, top half
	and $03		; isolate the terrain bits of the square
	call maphlf	; draw top half of that terrain
	pop af		; recall the original value of A
	push af		; and record it again
	ld de,$405c	; draw to bottom half of little terrain window
	and $03		; isolate the terrain bits
	or $80		; mark the top bit to signify lower half
	call maphlf	; draw bottom half of terrain
	pop af		; retrieve the original map square contents
	bit 3,a		; is/was there a city here?
	jr nz,pancty	; yes, deal with city stuff
	bit 2,a		; is there an army here?
	jr nz,panarm	; yes, deal the the army stuff
	cp $10		; are there barbarians here?
	jp nc,panbar	; yes, deal with barbarian stuff

	; set up the panel values for empty terrain & print name
.pantrr	ld d,0		; store terrain number ...
	ld e,a		; ... in de
	sla e		; multiply terrain number by 8 ...
	sla e		; ... giving an offset for terrain name
	sla e
	ld hl,namter	; point to the terrain name table
	add hl,de	; look down table for correct terrain name
	ld de,msgter+4	; point to terrain message
	ld bc,$0008	; there are 8 characters in the terrain names
	ldir		; copy them
	ld hl,msgter	; now point to the terrain message
	call msgprt	; print the terrain name in the message panel
	; zero all panel values - also used in other panel routines
.panzro	ld hl,wrkpan	; point to panel value workspace
	xor a		; we want to fill the panel with zeroes/blanks
	ld (hl),a	; store zero in the first panel value
	push hl		; point to following location
	pop de		;
	inc de		;
	ld bc,$0005	; set up a memory block transfer of five bytes
	ldir		; and copy the zero to the rest of the panel
	jp panprt	; go on to print the panel

	; set up the panel values for a city and display its name
.pancty	ld (wrkmap),a	; store map square in work space
	and $f0		; convert city number into a name offset
	sub $10		;
	rra		;
	ld e,a		;
	ld d,0		;
	ld hl,namcty	; point to the city name table
	add hl,de	; point source directly at the city's name
	ld de,msgcty+8	; point dest into "city of" message
	ld bc,8		; all city names are padded to eight bytes
	ldir		; copy the city name into the message
	ld hl,msgcty	; now point to the whole "city of" message ...
	call msgprt	; ... and print it.
	ld a,(wrkmap)	; retrieve unclobbered map square contents
	bit 2,a		; is this a ruined city?
	jr z,panzro	; yes, so fill the panel with zeroes
	call srvcty	; point IX to city table entry
	push ix		; transfer this value ...
	pop hl		; ... to HL
	ld de,wrkpan	; point dest at panel workspace
	ld bc,6		; we want to transfer 6 bytes
	ldir		; so do it
	; adjust city's displayed gold output value
	dec de		; move back to soldiers ...
	dec de		; ... to population
	ld a,(de)	; let's look at the population, because ...
	ld c,5		; ... cities earn 1 extra gold per 5 population ...
	ld b,1		; ... plus one gold for merely existing
.panpop	sub c		; count down population in fives
	jr c,pangld	; break out if we're done
	inc b		; otherwise increment the gold income
	jr panpop	; and continue
.pangld	dec de		; now look at the gold entry in the panel workspace
	ld a,(de)	; load it in
	add b		; add our extra gold to it
	ld (de),a	; and store back to the panel workspace
	jr panprt	; on to print the panel

	; set up the panel values for an army
.panarm	ld (wrkmap),a	; store map square in work space
	and $f0		; convert army number into a name offset
	sub $10		;
	rra		;
	ld e,a		;
	ld d,0		;
	ld hl,namgen	; point to the general name table
	add hl,de	; point source directly at the general's name
	ld de,msggen+8	; point dest into "general" message
	ld bc,8		; all general names are padded to eight bytes
	ldir		; copy the general name into the message
	ld hl,msggen	; now point to the whole "general" message ...
	call msgprt	; ... and print it.
	ld de,wrkpan	; point DE at work panel
	xor 0		; the first five fields want to be zero
	ld (de),a	; store the first byte
	ld h,d		; copy the destination pointer ...
	ld l,e		; ... to the source pointer ...
	inc de		; ... before moving the destination on
	ld bc,4		; we want to copy four more zeroes from this one
	ldir		; so get on with it
	ld a,(wrkmap)	; retrieve unclobbered map square contents
	call srvtrp	; point IX to the army details in the troop table
	push ix		; transfer the pointer ...
	pop hl		; ... to HL
	ld a,(hl)	; load the army size
	ld (de),a	; and store in the sixth panel field
	jr panprt	; now we can show the values

	; set up panel values for barbarian hordes
.panbar	push af		; remember A
	ld hl,msghrd	; point to "Barbarian horde" message
	call msgprt	; print it in the message box
	ld hl,wrkpan	; point to panel value workspace
	xor a		; we want to fill the panel with zeroes/blanks
	ld (hl),a	; store zero in the first panel value
	push hl		; point to following location
	pop de		;
	inc de		;
	ld bc,$0004	; set up block transfer to all but last panel value
	ldir		; and copy the zero to the rest of the panel
	pop af		; retrieve original square contents
	and $f0		; get rid of terrain/city bits
	rra		; move upper bits to lower bits ...
	rra		; ... leaving the number of barbarians here
	rra		;
	rra		;
	ld (de),a	; store this in the final panel value byte

	; print the values for the panel
.panprt	ld ix,wrkpan	; point to the 6-byte table
	ld a,(ix+$00)	; load the food output ...
	ld c,$06	; ... to be shown in the first field
	call numprt	; print it
	ld a,(ix+$01)	; load the wood output ...
	ld c,$07	; ... to be shown in the second field
	call numprt	; print it
	ld a,(ix+$02)	; load the iron output ...
	ld c,$08	; ... to be shown in the third field
	call numprt	; print it
	ld a,(ix+$03)	; load the gold output ...
	ld c,$09	; ... to be shown in the fourth field
	call numprt	; print it
	ld a,(ix+$04)	; load the city population ... 
	ld c,$0a	; ... to be shown in the fifth field
	call numprt	; print it
	ld a,(ix+$05)	; load the troop or barbarian numbers
	ld c,$0b	; ... to be shown in the sixth field
	call numprt	; print it
	ret		; done with the panel

	;
	; Preparation of 1-byte number for 3-digit display in a field
	;

	; print number A in field C
.numprt	call numasc	; convert byte to 3 ASCII characters
	; work out where the number should appear in screen memory
.numloc	ld hl,numtbl	; table of positions for number printing
	ld b,0		; leave field number in BC
	add hl,bc	; point at data for correct field number
.numltb	ld l,(hl)	; get value from table
	ld h,$12	; prepare H to point to screen address
	add hl,hl	; shift left five times so we're pointing ...
	add hl,hl	; ... to something resembling screen address
	add hl,hl	;
	add hl,hl	; 1 now in top bit of H rotated to carry ...
	adc hl,hl	; ... to be put in bottom bit of L
	bit 0,h		; we abuse 9th bit of HL (4th bit in table) ...
	jr z,numadr	; ... if 0 the address is fine as is
	res 0,h		; otherwise we have to reset it
	ld a,$1a	; a XOR mask to shift to LOCAL stats panel
	xor l		; apply it to current screen pointer on WORLD panel
	ld l,a		; now HL really points to the address we want
.numadr	ex de,hl	; we really want screen address in DE now	
	ld hl,wrknum	; point HL to constructed 3 character string
	ld b,$03	; B counts characters to print
	jr msgprc	; jump string into the "print character" loop

	; table of locations for numbers - the 12 panel fields
.numtbl	defb $07,$42,$45,$80,$83,$86
	defb $0f,$4a,$4d,$88,$8b,$8e

	; convert number A to an ASCII string
.numasc	ld hl,wrknum	; point to number "string" in work space
	ld b,100	; first look at the hundreds ...
	call numdgt	; ... and calculate that digit
	ld b,10		; then look at the tens ...
	call numdgt	; ... and calculate that digit
	ld b,1		; finally look at the units ...
	call numdgt	; ... and calculate that
	; eliminate leading zeroes from the number
	ld hl,wrknum	; look at beginning of the string
	ld b,3		; number of digits
.numzro	ld a,$30	; now we want to eliminate leading zeroes
	cp a,(hl)	; is it a zero?
	ret nz		; no, so we're done here
	ld a,$20	; replace it with a space
	ld (hl),a	; store the space in place of the zero
	inc hl		; point at the next character
	djnz numzro	; repeat if there are digits left
	ret		; return
	; calculate correct ASCII digit A for column B (1,10,100)
.numdgt	ld d,$2F	; digit to use starts at one before ASCII '0'
.numdgi	inc d		; increase the digit
	sub a,b		; subtract number column heading 100/10/1
	jr nc,numdgi	; if we haven't reduced A below 0, continue increasing
	add a,b		; otherwise, restore A to positive value
	ld (hl),d	; store this digit
	inc hl		; point to the next digit
	ret		; done this character

	;
	; Output message text of fixed length, leaving colour alone
	;

	; prepare 16-character message for the message field
.msgprt	ld de,$5068	; screen memory where messages will appear
	ld b,$10	; there are always 16 characters

	; print a single character at a time
.msgprc	ld a,(hl)	; load character into A
	push hl		; store our string address while we borrow HL
	push de		; store screen address temporarily
;	ld hl,$0780	; $3c00 (address of characters in ROM) / 8
;	add a,l		; a should be $A0..$ff ($80 OR $20..$7f)
;	ld l,a		; store back in L
;	add hl,hl	; multiply HL by 8 ...
;	add hl,hl	; ... giving character address in ROM
;	add hl,hl	;
	sub $20		; subtract value of space from A
	ld l,a		; transfer to HL
	ld h,0		;
	add hl,hl	; turn HL into an offset to MSGCHR
	add hl,hl	;
	add hl,hl	;
	ex de,hl	; transfer offset to DE
	ld hl,msgchr	; point to character set
	add hl,de	; add the offset
	pop de		; regain our screen address
	ld c,b		; store character count
	ld b,$08	; 8 pixel lines in a character
	push de		; push our screen address again
	; fill a single pixel row at a time
.msgprl	ld a,(hl)	; load character data
	ld (de),a	; save onto screen
	inc d		; point DE to next pixel row on screen
	inc hl		; point HL to next pixel row in character set
	djnz msgprl	; transfer remaining pixel rows
	ld b,c		; restore character count
	pop de		; restore DE to the correct row in screen memory
	inc e		; point DE to next character in screen memory
	pop hl		; retrieve character pointer
	inc hl		; increment it to point to the next character
	djnz msgprc	; print remaining characters
	ret		; all done, return

	; pre-defined messages
.msgctl	defm "KEYS OR JOYSTICK"
.msgwt	defm " PLEASE WAIT... "
.msglvl	defm "   LEVEL:----   "
.msgblk	defm "                "
.msgter	defm "    --------    "
.msghrd	defm "BARBARIAN HORDES"
.msgcty	defm "CITY OF --------"
.msgnci	defm "   NOT A CITY   "
.msgnpo	defm " TOO FEW PEOPLE "
.msgnoi	defm "YOU HAVE NO IRON"
.msgrec	defm "TROOPS TO ARM---"
.msgdir	defm "CHOOSE DIRECTION"
.msgntr	defm " NO TROOPS HERE "
.msgnew	defm "NOT ENOUGH WOOD "
.msgexh	defm "TROOPS EXHAUSTED"
.msgswm	defm "ARMY CANNOT SWIM"
.msgrun	defm "CITY IS IN RUINS"
.msgago	defm "ALL GENERALS OUT"
.msggen	defm "GENERAL --------"
.msgmkt	defm "---- ----    ---"
.msgstv	defm "-------- STARVES"
.msgvic	defm "COMPLETEVICTORY!"
.msgdef	defm "ABSOLUTE DEFEAT!"
.msgend	defm "THE GAME IS OVER"
.msgovw	defm "  OVER- WHELMED!"
.msgbat	defm "                " ; used for the battle message
.msgfsv	defm "HIT FIRE TO SAVE"
.msgfld	defm "HIT FIRE TO LOAD"
.msgfnw	defm "FIRE FOR NEW MAP"
.msghtf	defm "   PRESS FIRE   "
.msgsve	defm "TAPE SAVE FAILED"
.msglde	defm "TAPE LOAD FAILED"

	;
	; Map graphics routines and data
	;

	; draw the visible map window
.mapdrw	di		; this needs to be fast, used for cheap scrolling
	ld b,$09	; there are nine rows, initialise counter
	ld a,$00	; start at the top row
.mapdrr	ld c,a		; A will be corrupted, so store it ...
	push bc		; ... and BC on the stack
	call maprow	; display the map row
	pop bc		; get the stored data back from the stack
	ld a,c		; put row number back into A
	inc a		; signify the next row
	djnz mapdrr	; and display it
	ei		; enable interrupts as we use them for timing
	ret		; done

	; draw visible map row A (A=0..8)
.maprow	ld l,a		; store A
	sla a		; multiply by 2 ...
	sla a		; ... 4 ...
	sla a		; ... 8 ...
	sla a		; ... 16
	ld b,a		; remember A
	ld a,(mapwin)	; load them in
	add a,b		; and add the row coordinate requested
	ld l,a		; store in L
	ld b,$09	; there are 9 locations in a visible row
.maprws	ld h,b		; store counter B into H, then ...
	push hl		; ... store H(B)L
	call mapsqr	; display the square
	pop hl		; get H(B)L back again
	ld b,h		; put the counter where it belongs
	inc l		; point to next location
	djnz maprws	; display next location
	ret		; or return

	; draw correct map graphic at location L
.mapsqr	ld h,datmap/256	; point H to map page
	ld a,(hl)	; what's on the map?
	cp $04		; is there something other than terrain here?
	jr c,mapspr	; no, so just show the terrain
	srl a		; otherwise see what else we should draw here
	srl a		;
	and $03		;
	or $04		; now A=4 barbarians A=5 troops A=6 ruin A=7 city
.mapspr	ld (wrkspr),a	; temporarily store sprite number ...
	ld a,l		; and put location byte ...
	ld (wrkloc),a	; ... into work space too
	call mapupr	; get upper half into DE
	ld a,(wrkspr)	; and put sprite in A ready to ...
	call maphlf	; ... display the top half
	ld a,(wrkloc)	; set A to map location
	call maplwr	; get screen address of lower half of square
	ld a,(wrkspr)	; retrieve sprite number again
	or $80		; set top bit to signify want to ...
	call maphlf	; ... display the bottom half
	ret		; all done

	; put into DE the screen location for a map location A, upper/lower
.mapupr	ld hl,maputb	; point HL to table of upper row locations
	push hl		; store on the stack for a moment
	jr maploc	; the rest of the location is common to maplwr
	; entry point for lower half of map sqaure
.maplwr	ld hl,mapltb	; point HL to table of lower row locations
	push hl		; store on the stack for a moment
.maploc	ld hl,mapwin	; point to byte containing top left window
	sub a,(hl)	; subtract this from A giving screen location
	ld b,a		; move A into B as a counter
	srl b		; move top four bits into bottom
	srl b		;
	srl b		;
	srl b		;
	pop hl		; retrieve table of upper/lower locations
	jr z,mapurw	; skip if a (therefore b also) is zero
.mapunx	inc hl		; point to next table entry
	djnz mapunx	; and the next and next as appropriate
.mapurw	ld l,(hl)	; load L from table
	ld h,0		; zero H
	add hl,hl	; rotate left five times ...
	add hl,hl	; ... so HL now contains offset ...
	add hl,hl	; ... to which base of $4007 can be added ...
	add hl,hl	; ... to get proper screen address
	add hl,hl	;
	ld de,$4007	; 7th character of top row of screen
	add hl,de	; now HL contains leftmost byte on row
	ex de,hl	; store in DE
	and $0f		; isolate column number (destroying A)
	ld b,a		; store in counter
	ret z		; if 0, the address we have is fine
.mapucl	inc de		; point to next character ...
	inc de		; ... and the next as sprites are 2 chars wide
	djnz mapucl	; continue advancing by columns
	ret		; now HL contains first byte of upper row

	; display half sprite A on the screen (bit 7 signifies half)
.maphlf	sla a		; shift top bit of A into carry
	rl c		; and store in bottom bit of c
	srl a		; restore A without its top bit
	ld b,a		; store a into counter
	ld hl,mapgfx	; point to start of map sprite graphics
	push de		; remember screen address DE for a moment
	bit 0,c		; which half of the sprite are we printing?
	jr z,mapfsp	; find the right sprite
	ld de,$0010	; bottom, so skip top half of sprite data ...
	add hl,de	; ... by adding it to HL	
.mapfsp	ld de,$0024	; set D to length of sprite information (de)
	and b		; is counter 0?
	jr z,mapfnd	; if so, we're already pointing at the right sprite
.mapnxs	add hl,de	; otherwise point to next sprite ...
	djnz mapnxs	; ... and check again
	; draw the pixels
.mapfnd	pop de		; retrieve screen address
	push de		; and store it again as we'll be corrupting it
	ld b,8		; 8 lines for this half of sprite
.mapout	ldi		; transfer first byte from sprite to screen
	ldi		; transfer second byte from sprite to screen
	inc bc		; we didn't want to decrement BC...
	inc bc		; ... so restore it again
	dec e		; point back to left-hand character ...
	dec e		;
	inc d		; ... then point to next screen row
	djnz mapout	; and output the next row
	; paint the attributes
	bit 0,c		; if zero, we're drawing the top half of the sprite
	jr nz,maplat	; if non-zero, we're drawing the bottom
	ld de,$000e	; we want to skip 14 bytes first
	add hl,de	;
.maplat	inc hl		; skip two more bytes to reach the correct attr source
	inc hl		;
	pop de		; regain screen location
	srl d		; the following code should convert the pixel ...
	srl d		; ... address in DE to an attribute address
	srl d		;
	ld a,$50	;
	or d		;
	ld d,a		; DE now contains the attribute address
	ldi		; transfer first attribute
	ldi		; transfer second attribute
	ret		; done with this map square

	; shifted screen addresses of char rows on map display
.maputb defb $01,$03,$05,$07,$41,$43,$45,$47,$81 ; upper halves
.mapltb	defb $02,$04,$06,$40,$42,$44,$46,$80,$82 ; lower halves

	;
	; Pixel and attribute data for map graphics
	;

	; plain graphic
.mapgfx	defb $00,$00,$00,$40,$20,$02,$00,$00,$04,$08,$00,$00,$20,$20,$01,$04
	defb $00,$00,$40,$10,$04,$00,$00,$00,$00,$00,$20,$80,$00,$14,$00,$00
	defb $06,$06,$06,$06 ; attributes
	; forest
	defb $00,$00,$1b,$98,$24,$64,$22,$02,$4c,$2a,$4a,$42,$21,$14,$1c,$28
	defb $03,$40,$03,$40,$02,$40,$02,$a0,$06,$e0,$05,$20,$09,$10,$00,$00
	defb $44,$04,$42,$02 ; attributes
	; mountain
	defb $00,$00,$01,$80,$02,$40,$02,$40,$04,$40,$04,$20,$04,$20,$09,$10
	defb $0a,$10,$12,$50,$12,$50,$24,$48,$20,$88,$20,$84,$40,$02,$00,$00
	defb $47,$07,$47,$07 ; attributes
	; sea
	defb $00,$00,$64,$00,$98,$00,$00,$64,$00,$98,$32,$00,$4c,$00,$00,$32
	defb $00,$4c,$19,$00,$26,$00,$00,$19,$00,$26,$0c,$80,$13,$00,$00,$00
	defb $45,$45,$45,$45 ; attributes
	; barbarians
	defb $00,$00,$0e,$0e,$56,$56,$52,$52,$4c,$4c,$52,$52,$5e,$5e,$5a,$5a
	defb $f1,$f1,$55,$55,$51,$51,$2a,$2a,$14,$14,$14,$14,$36,$36,$00,$00
	defb $44,$04,$44,$04 ; attributes
	; army
	defb $00,$00,$0c,$10,$56,$fe,$52,$7c,$4c,$7c,$52,$7c,$5f,$7c,$59,$54
	defb $e9,$10,$59,$10,$59,$10,$29,$10,$16,$10,$14,$10,$36,$10,$00,$00
	defb $42,$02,$42,$06 ; attributes
	; city
	defb $00,$00,$00,$00,$00,$00,$00,$00,$18,$00,$1c,$00,$3a,$00,$35,$00
	defb $6d,$80,$7f,$e0,$6d,$b2,$7f,$fe,$7e,$7e,$7c,$3e,$7c,$3e,$00,$00
	defb $47,$47,$07,$07 ; attributes
	; ruin
	defb $00,$00,$07,$00,$05,$00,$0f,$80,$1d,$c0,$1d,$d4,$3a,$fc,$35,$74
	defb $6d,$b6,$7f,$fe,$6d,$b6,$7f,$fe,$7e,$7e,$7d,$be,$7d,$be,$00,$00
	defb $47,$47,$07,$07 ; attributes

	;
	; Textual data for map elements used in display
	;

	; names of the terrain types
.namter	defm " PLAINS "
	defm " FOREST "
	defm "MOUNTAIN"
	defm "  SEA   "

	; names of the twelve cities
.namcty	defm "VELSNA  "
	defm "CAPEVA  "
	defm "CISRA   "
	defm "CLEVSIN "
	defm "MANUVA  "
	defm "VELAURI "
	defm "CUSA    "
	defm "FUFLUNA "
	defm "SUTHRI  "
	defm "TARCHNA "
	defm "VEIA    "
	defm "VETLUNA "

	; names of the twelve generals
.namgen	defm "PURSENNA"
	defm "VIPINA  "
	defm "CEICNA  "
	defm "VLAVE   "
	defm "ACVILNAS"
	defm "VELIMNAS"
	defm "PATRUNI "
	defm "CVENLE  "
	defm "PHARU   "
	defm "CRACNA  "
	defm "PHERINI "
	defm "APHUNA  "

	; fancy character set
.msgpad	defs 8 - (ASMPC ~ 7)	; ensure msgchr is on an 8-byte boundary
.msgchr	defm $00,$00,$00,$00,$00,$00,$00,$00	; space
	defm $00,$30,$30,$18,$18,$00,$0c,$00	; exclamation mark
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$1c,$70,$00,$00,$00	; hyphen
	defm $00,$00,$00,$00,$00,$10,$18,$00	; full-stop
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$38,$6c,$c6,$6c,$38,$00	; 0
	defm $00,$00,$30,$70,$18,$18,$7c,$00	; 1
	defm $00,$00,$30,$4c,$0c,$70,$1c,$00	; 2
	defm $00,$00,$38,$0c,$18,$0c,$78,$00	; 3
	defm $00,$00,$30,$30,$68,$7c,$18,$00	; 4
	defm $00,$00,$3c,$30,$0c,$0c,$78,$00	; 5
	defm $00,$1e,$38,$70,$6c,$6c,$38,$00	; 6
	defm $00,$00,$7c,$0c,$0c,$18,$18,$00	; 7
	defm $00,$38,$6c,$78,$3c,$6c,$38,$00	; 8
	defm $00,$00,$38,$6c,$6c,$18,$70,$00	; 9
	defm $00,$00,$20,$30,$00,$10,$18,$00	; colon
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$18,$3c,$6c,$66,$de,$c6,$00	; A
	defm $00,$f0,$cc,$d8,$66,$6c,$70,$00	; B
	defm $00,$38,$6c,$c0,$60,$36,$1c,$00	; C
	defm $00,$f0,$d8,$c6,$66,$6c,$78,$00	; D
	defm $00,$f8,$c6,$f0,$60,$78,$66,$00	; E
	defm $00,$f0,$ce,$c0,$70,$6c,$60,$00	; F
	defm $00,$38,$60,$c0,$66,$36,$1e,$00	; G
	defm $00,$cc,$cc,$dc,$76,$66,$66,$00	; H
	defm $00,$78,$30,$30,$18,$18,$3C,$00	; I
	defm $00,$06,$06,$06,$c6,$76,$1c,$00	; J
	defm $00,$c4,$c8,$d0,$70,$6c,$62,$00	; K
	defm $00,$c0,$c0,$c0,$62,$6c,$70,$00	; L
	defm $00,$cc,$fc,$fc,$d6,$c6,$c6,$00	; M
	defm $00,$cc,$ec,$ec,$d6,$ce,$c6,$00	; N
	defm $00,$38,$6c,$c6,$c6,$6c,$38,$00	; O
	defm $00,$e0,$d8,$c6,$6c,$60,$60,$00	; P
	defm $00,$38,$6c,$c6,$c6,$6c,$3e,$00	; Q
	defm $00,$e0,$d8,$c6,$7c,$68,$66,$00	; R
	defm $00,$38,$60,$f0,$1e,$0c,$38,$00	; S
	defm $00,$3e,$f0,$30,$18,$18,$18,$00	; T
	defm $00,$c6,$c6,$c6,$66,$6e,$76,$00	; U
	defm $00,$c6,$cc,$6c,$6c,$38,$10,$00	; V
	defm $00,$cc,$cc,$cc,$c6,$d6,$ee,$00	; W
	defm $00,$c6,$68,$30,$18,$2c,$c6,$00	; X
	defm $00,$c6,$6c,$38,$30,$30,$18,$00	; Y
	defm $00,$f0,$1e,$0c,$30,$f0,$1e,$00	; Z
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
	defm $00,$00,$00,$00,$00,$00,$00,$00
