	;
	; Barbarians ZX
	; Move troops around the map
	;
	; The routines in this file include user the user interface for
	; movement, the checks required, and the movement code itself.
	;
	; This file is INCLUDEd from game.asm and shouldn't be assembled on
	; its own.
	;
	; Copyright (C) Damian Walker 2012
	;

	; entry point - check first that the game is not already over
.movtrp	ld a,(datend)	; look at the end game flags
	or a		; are either of them set?
	jp nz,turend	; yes, so remind the player the game is over

	; check that there is something to move here
	ld a,(mapcur)	; recall current map position
	ld h,datmap/256	; point at the map page ...
	ld l,a		; ... and at the very location
	ld a,(hl)	; what is there?
	bit 3,a		; is it a city?
	jr nz,movcci	; yes, perform city check
	bit 2,a		; is there an army here?
	jp z,movntr	; no, so "no troops here" error
	; check that troops have not already moved this turn
	call srvtrp	; point IX to army's troop table entry
	bit 0,(ix+1)	; check to see if troops have moved this turn
	jp nz,movexh	; yes, so they can't move again this turn
	jr movdir	; straight on to direction
	; check that a city has troops, and that we have wood enough to equip
.movcci	bit 2,a		; is the city in ruins?
	jp z,movntr	; yes, so "no troops here"
	call srvcty	; point IX to city's table entry
	ld a,(ix+5)	; what troops are here?
	or a		; are there any?
	jp z,movntr	; no, so "no troops here" again
	ld b,a		; note troop numbers
	ld a,(ttlwod)	; how much wood in the player's empire?
	cp b		; does the garrison size exceed the wood?
	jp c,movnew	; yes, so we can't equip the garrison for the field
	bit 0,(ix+6)	; check to see if troops moved into city this turn
	jp nz,movexh	; yes, so they can't move again this turn

	; ask the player in what direction troops should be moved
.movdir	ld hl,msgdir	; point to "choose direction" prompt
	call msgprt	; print it
	call ctlrel	; wait until controls are released
	call ctlact	; now wait till a control is activated
	bit 4,a		; is FIRE activated?
	jp nz,cursor	; yes, cancel the movement and continue browsing map
	ld c,a		; move control out of the way so we can ...
	ld a,(mapcur)	; see where the map cursor is ...
	ld l,a		; ... and point to it ...
	ld h,datmap/256	; ... on the map
	bit 3,c		; is UP activated?
	jr nz,movnor	; yes, move troops north
	bit 2,c		; is DOWN activated?
	jr nz,movsou	; yes, move south
	bit 1,c		; is LEFT activated?
	jr nz,movwst	; yes, move west

	; movement to the east
	and $0f		; what's our horizontal location?
	cp $0f		; are we at the eastern map edge?
	jp z,cursor	; yes, so treat this as a cancellation
	ld a,$01	; set the offset for movement to the east
	jr movter	; on to terrain check
	; movement to the west
.movwst	and $0f		; what's our horizontal location?
	jp z,cursor	; we're at the western edge, so treat as cancel move
	ld a,$ff	; set the offset for movement to the west
	jr movter	; on to terrain check
	; movement to the south
.movsou	cp $e0		; are we at the southern edge?
	jp nc,cursor	; yes, treat this as a cancel
	ld a,$10	; set the offset for movement to the south
	jr movter	; on to terrain check
	; movement to the north
.movnor	and $f0		; what's our vertical location?
	jp z,cursor	; we're at the northern edge, so treat as cancel move
	ld a,$f0	; set the offset for movement to the north

	; check that terrain is accessible
.movter	ld e,a		; put offset into lower half of offset
	ld d,$00	; initialise upper half of offset to 0
	bit 7,e		; but should move be negative (north or west)?
	jr z,movlok	; no, on to looking at the location
	ld d,$ff	; yes, so set upper half of offset negative
.movlok	add hl,de	; revise our pointer to look at the destination square
	ld a,(hl)	; what is there?
	cp $03		; is it the sea?
	jp z,movswm	; yes it is, but troops can't swim in that armour!
	and $0c		; check for a ruin
	cp $08		; is this a ruin?
	jp z,movrun	; yes, we can't enter, it might be dangerous...
	ld a,(hl)	; look again
	cp $10		; is there anybody there?
	jr c,movtry	; no, so there'll not be a battle
	bit 2,a		; is it a city or army there?
	jr nz,movtry	; yes, so we can go and join them

	; barbarians - on to the fight!
	ex de,hl	; swap locations around again so DE is defending square
	ld a,(mapcur)	; what is the attacking square?
	ld l,a		; point to it ...
	ld h,d		; ... on the map page
	call battle	; on to the fight!
	ld a,(ttlbar)	; how many barbarians are left on the map?
	or a		; have they all gone?
	jp z,turbgn	; yes, so jump to "victory" bit of turn end
	jp turfin	; no, redisplay panel to finish

	; now try moving
.movtry	ex de,hl	; store our map destination
	ld a,(mapcur)	; look again at the map location
	ld l,a		; point to it ...
	ld h,datmap/256	; ... on the map page
	ld a,(hl)	; what is it we're actually moving?
	bit 3,a		; a field army (0) or a garrison (1)?
	jr z,movarm	; it's an army, so deal with it separately

	; move the garrison from a city
	push hl		; remember where we're moving from
	ld hl,trptbl	; point at the start of the troop table
	ld b,$0c	; there are twelve entries only
	ld c,$01	; we need to remember the new army number for later
.movglp	ld a,(hl)	; check the army component of current entry
	or a		; is this general available?
	jr z,movgar	; yes, so move the garrison out
	inc hl		; point to next entry ...
	inc hl		; ... in the troop table
	inc c		; keep track of the army number
	djnz movglp	; and check it
	jp movago	; if we get here All Generals are Out
.movgar	ex (sp),hl	; recall where we're moving from
	ld a,(hl)	; what's there?
	push de		; we need to note where we're moving to
	call srvcty	; we know it's a city, point to its table entry
	pop de		; now we need to recall where we're moving to
	ld a,(ix+5)	; how many troops are we moving out?
	ex (sp),hl	; now recall the troop table pointer
	ld (hl),a	; assign these troops to him
	ld a,(ttlwod)	; how much wood did we have?
	sub a,(hl)	; we have that much less now
	ld (ttlwod),a	; so adjust the empire's wood stockpile
	xor a		; we're leaving none behind
	ld (ix+5),a	; so remove the garrison
	pop hl		; get our source location back
	jr movput	; now put these troops somewhere

	; move an army out of a square
.movarm call rand16	; pick a number, any number
	ld a,(de)	; look again at the destination square
	and $03		; what is the terrain?
	jr z,movaok	; if it's plains, we can always move there
	add a,a		; otherwise forest=2 mountain=4
	call randmo	; reduce random number to 0-1 or 0-3
	or a		; is it zero?
	jp z,movaok	; yes, so troops may move
	; terrain test failed, army exhausted and used its movement
	ld a,(hl)	; which army tried to move?
	call srvtrp	; point IX to the troop table entry for the army
	set 0,(ix+1)	; set the "we have moved today" bit
	jp movexh	; now go and give the "exhausted" error
	; terrain test was passed, army OK to move
.movaok	ld a,(hl)	; remind ourselves what's moving and from where
	ld c,a		; note this information, we need the army number later
	and $03		; mask off everything but the terrain
	ld (hl),a	; now the square is empty
	srl c		; convert byte from full square contents ...
	srl c		; ... to army number
	srl c		;
	srl c		;

	; now we've taken the troops from one location, put them somewhere
.movput	ld a,(de)	; remind me, what are we moving them into?
	bit 3,a		; into a city?
	jr nz,movpct	; yes, put them into the city
	bit 2,a		; merging into another army?
	jr nz,movpar	; yes, merge them into that army

	; move army into empty terrain
	and $03		; remember the terrain
	ld b,a		; store it
	ld a,c		; reload our army number
	add a,a		; shift it into the correct half of the byte
	add a,a		;
	add a,a		;
	add a,a		;
	or b		; combine it with the new square's terrain ...
	or $04		; and the bit that signifies "army"
	ld (de),a	; store it back where it belongs
	call srvtrp	; point IX to the troop table entry for the army
	set 0,(ix+1)	; set the "we have moved today" bit
	jr movupd	; on to update

	; move army into city - disband and form garrison
.movpct	call movdis	; disband army C and load troop numbers into C
	ld a,(de)	; look again at destination square
	call srvcty	; point IX to the troop table entry
	ld a,(ix+5)	; load the troop numbers
	add a,c		; add the troops we're moving in
	ld (ix+5),a	; update the table's troop numbers
	set 0,(ix+6)	; set the "we have moved today" bit
	jr movupd	; all done now

	; move army into another army
.movpar	call movdis	; disband army C and load troop numbers into C
	ld a,(de)	; look again at destination square
	call srvtrp	; point IX to troop table entry
	ld a,(ix+0)	; load the troop numbers
	add a,c		; add the troops we're moving into there
	ld (ix+0),a	; update the table's troop numbers
	set 0,(ix+1)	; set the "we have moved today" bit

	; update the screen and then we're done
.movupd	push hl		; note our source location
	call panwld	; update the world panel - it MAY need it
	pop hl		; recall our source location
	ld a,(hl)	; what is there?
	call panlcl	; update the local panel - it WILL need it
	call mapdrw	; probably the smallest way of updating map squares
	jp cursor	; all done, back to map browsing

	; disband - a general lays down his command
.movdis ld a,c		; recall the army number
	dec a		; decrement it as offsets start at 0
	add a,a		; double it
	ld ix,trptbl	; point IX at the troop table
	call srvtbl	; now IX points at the existing army
	ld a,(ix+0)	; what is the troop count?
	ld c,a		; set it aside for a moment
	xor a		; we want to zero the army figures to disband it ...
	ld (ix+0),a	; ... so it now has no troops ...
	ld (ix+1),a	; ... and it has not moved
	ret		; done

	; error routines
.movntr	ld hl,msgntr	; point HL to message "no troops here"
	jr moverr	; on to printing
.movnew	ld hl,msgnew	; point HL to the message "not enough wood"
	jr moverr	; on to printing
.movexh	ld hl,msgexh	; point HL to message "troops exhausted"
	jr moverr	; on to printing
.movswm	ld hl,msgswm	; point HL to "cannot swim"
	jr moverr	; on to printing
.movrun	ld hl,msgrun	; point HL to "cannot enter ruin" message
	jr moverr	; on to printing
.movago	ld hl,msgago	; point HL to "all generals out" message
.moverr	jp errprt	; print the error message