	;
	; Barbarians ZX
	; Tape Routines
	;
	; Routines for Loading and Saving Games
	;
	; This file is INCLUDEd from game.asm and shouldn't be assembled on
	; its own.
	;
	; Copyright (C) Damian Walker 2012
	;

	;
	; Save a Game
	;

	; prompt player to fire when ready
.savgam	ld hl,msgfsv	; "hit fire to save" message
	call tapfir	; wait for fire or other control
	jr z,savdon	; done saving
	ld hl,msgwt	; "saving" message
	call msgprt	; print it

	; do the actual saving
	ld a,$ff	; tell ROM to save data, not header
	ld ix,menopt	; start of game variables
	ld de,datmax-menopt ; length of game variables
	ld hl,$0051	; false return address - EI then RET
	call $04c5	; call SA-BYTES+3
	xor a		; we want the border to be black whether ...
	out ($fe),a	; ... save was successful or not
	
	; all done
.savdon	jp cursor	; return to map browsing

	;
	; Load a game
	;

	; prompt player to fire when ready
.lodgam	ld hl,msgfld	; "hit fire to load" message
	call tapfir	; wait for fire or other control
	jr z,loddon	; done loading
	ld hl,msgwt	; "loading" message
	call msgprt	; print it

	; set up the loading
	ld a,$ff	; tell ROM to load data, not header
	ld ix,lodbuf	; start of game variables
	ld de,datmax-menopt ; length of game variables
	scf		; set carry flag for LOAD (not VERIFY)

	; call the loading routine, skipping its RST08 error stuff
	inc d		; the lines up to LD HL are copied from the ...
	ex af,af'	; ... ROM ld-bytes routine, and are designed to ...
	dec d		; ... avoid the ROM's own false return address ...
	di		; ... code which returns to BASIC when an error ...
	ld a,$0f	; ... occurs in loading.
	out ($fe),a	;
	ld hl,$0051	;
	call $0561	; call part way into ld-bytes
	xor a		; we want the border to be black again ...
	out ($fe),a	; ... whether an error occurs or not
	
	; check for incomplete load
	xor a		; clear accumulator
	or e		; check bytes remaining count (lower half)
	jr nz,loderr	; error if not zero
	or d		; check bytes remaining count (upper half)
	jr nz,loderr	; error if not zero

	; transfer contents of load buffer onto game data store
	ld hl,lodbuf
	ld de,menopt
	ld bc,datmax-menopt
	ldir

	; now update the screen with the new game
	call panwld	; update the Empire panel
	call mapdrw	; redraw the map

	; all done
.loddon	jp cursor	; return to map browsing

	; loading error detected
.loderr	ld hl,msglde	; point to loading error message
	call tapfir	; wait for fire
	jp cursor	; return to map browsing

	;
	; Confirm a new game is wanted
	;

	; prompt player to fire when needed
.newgmc	ld hl,msgfnw	; "fire for new map" message
	call tapfir	; wait for fire or another control
	jp z,cursor	; cancel if something other than fire pressed
	jp newgam	; otherwise new game

	; wait for fire to be pressed, return nz if it is
.tapfir	call msgprt	; print message
.taprel	call kbdpol	; is anything activated?
	and $1f		; just look at the control bits
	jr nz,taprel	; continue waiting until all controls released
.tapwfr	call kbdpol	; is anything activated?
	and $1f		; just the control bits
	jr z,tapwfr	; continue waiting till something is activated
	bit 4,a		; is it fire?
	ret nz		; return, with the NZ, if so
	xor a		; otherwise clear the zero flag
	ret		; all done

	;
	; Storage
	;

	; load buffer - used to temporarily store loaded data
.lodbuf	defs datmax-menopt
