	;
	; Barbarians ZX
	; Variable definitions
	;
	; These define the locations that the game uses to store its variables,
	; everything from the game map and city and troop tables, to temporary
	; workspace locations for other routines.  Variables may not be placed
	; before the location $5cd0, the start of the loader code.
	;
	; This file is INCLUDEd from game.asm and shouldn't be assembled on
	; its own.
	;
	; Copyright (C) Damian Walker 2012
	;

	; temporary work space variables
defc	wrkmap = $5cd0	; workspace - map square contents
defc	wrkpan = $5cd1	; workspace - six values for LOCAL panel
defc	wrkscr = $5cd7	; workspace - screen location calculation
defc	wrknum = $5cd8	; workspace - 3 character ASCII "number"
defc	wrkloc = $5cdb	; workspace - map location
defc	wrkspr = $5cdc	; workspace - sprite number
defc	wrkdbg = $5cdf	; workspace - used for debugging
defc	wrkncs = $5ce0	; workspace - number currently selected
defc	wrkdis = $5ce1	; workspace - temporary troop number store
defc	wrktrp = $5ce2	; workspace - pointer into troop table (2 bytes)
defc	wrktxt = $5ce4	; workspace - text pointer for market (2 bytes)
defc	wrkmax = $5ce6	; workspace - maximum number for selection
defc	wrkres = $5ce7	; workspace - pointer to empire resource table (2b)
defc	wrksnc = $5ce9	; workspace - flags for sanctions to be applied
defc	wrkbat = $5cea	; workspace - battle table (4b)
			; DANGER: check battle.asm if wrkbat is changed.

	; persistent game variables
defc	menopt = $5cf0	; current menu option
defc	mapcur = $5cf1	; where the map cursor is
defc	datlvl = $5cf2	; difficulty level
defc	mapwin = $5cf3	; location of top/left of map window
defc	ctlopt = $5cf4	; control options selected FIRE/UP/DOWN/LEFT/RIGHT
defc	datend = $5cf5	; end of game flags 0=ongoing 1=victory 2=defeat

	; the WORLD resource table
defc	ttlfod = $5cf7	; player's supply of food
defc	ttlwod = $5cf8	; player's supply of wood
defc	ttlirn = $5cf9	; player's supply of iron
defc	ttlgld = $5cfa	; player's supply of gold
defc	ttlpop = $5cfb	; player's total population
defc	ttltrp = $5cfc	; player's total troops
defc	ttlbar = $5cfd	; number of barbarians on the map

	; workspace for the random number generator
defc	randsd = $5cfe	; random number seed (2 bytes)
defc	randsl = randsd ; low byte of random seed
defc	randsh = randsd+1 ; high byte of random seed

	; the map - needs to be aligned with a page (start at $??00)
defc	datmap = $5d00	; address of game map storage (to $5def)

	; the city table, 7 bytes per city detailing:
	;   offset 0 - food generated each turn by this city
	;   offset 1 - wood generated each turn by this city
	;   offset 2 - iron generated each turn by this city
	;   offset 3 - gold generated each turn before city/population bonuses
	;   offset 4 - current city population
	;   offset 5 - size of current garrison
	;   offset 6 - 1 if troops moved here this turn
defc	ctyinf = $5df0	; 7 bytes for info for each city x 12

	; the troop table, 2 bytes per army detailing:
	;   offset 0 - troop numbers for this army
	;   offset 1 - 1 if troops have moved this turn
defc	trptbl = $5e44	; 2 bytes for each of 12 generals

	; next available byte, useful label for load/save routines
defc	datmax = trptbl + 2

	; newgam currently starts at $5e7c, only 32 bytes left here!