	;
	; Barbarians ZX
	; One-time initialisatino for the game
	;
	; One-off initialisation tasks such as initialising the control method
	; and the screen. These routines are overwritten with game data once
	; they have been executed.
	;
	; This file is INCLUDEd from game.asm and shouldn't be assembled on
	; its own.
	;
	; Copyright (C) Damian Walker 2012
	;

	;
	; Miscellaneous initialisation tasks
	;

	; set border colour
.border	xor a		; set A to 0 for black
	out ($fe),a	; set the border

	; initialise some variables to 0
	ld (datlvl),a	; set initial level to easy
	ld (menopt),a	; set last-chosen menu option

	; Randomise seed
	ld hl,($5c78)	; load the Spectrum timer
	ld (randsd),hl	; save to seed

	;
	; Ascertain the control method
	;

	; print the message
.ctl	ld hl,msgctl	; point at the controls message
	call msgprt	; print it

	; get the player's response
.ctlget	call rand16	; keep the dice shaking while we wait
	ld a,$bf	; let's look at row J-ENTER of keyboard
	in a,($fe)	; poll keyboard
	and $0c		; isolate J and K
	cp $0c		; are both keys up?
	jr z,ctlget	; continue to read keyboard till J/K pressed
	; transfer the correct input routine to kbdpol
	ld de,kbdpol	; this is where the control routine goes
	ld hl,kbdpol	; assume first that player wants keyboard
	ld bc,6		; we need to copy 6 bytes at most
	and $08		; look specifically at the J key
	jr nz,ctlset	; if up, don't use joystick routine
	ld hl,joypol	; if K not pressed then we want joystick
.ctlset	ldir		; copy the appropriate routine to kbdpol

	;
	; Fill in the screen colours
	;

	; colour the screen according to compressed table
.atr	ld de,$5800	; point DE at attribute file
	ld hl,attrtb	; point HL at compressed attribute table
.atrblk	ld a,(hl)	; first byte of block
	cp 0		; if it's zero...
	jp z,newgam	; then we're done
	bit 7,a		; is this a length byte?
	jr z,atrsng	; no, transfer a single byte
	and $7f		; remove high bit
	ld b,a		; transfer to counter
	inc hl		; next byte is attribute...
	ld a,(hl);	; ...so load it in
	jr atrcpy	; on to copying
.atrsng	ld b,1		; single byte
.atrcpy	ld (de),a	; copy to the screen
	inc de		; point to next location
	djnz atrcpy	; continue till all bytes done
	inc hl		; next byte
	jr atrblk	; next block

	; compressed attribute table
.attrtb	defb $a2,$06	; top line and then some
	defb $82,$47	; top half of empire symbol (a city)
	defb $83,$06	; parchment edges
	defb $92,$00	; top half of first line of big map
	defb $83,$06	; parchment edges
	defb $82,$00	; top half of terrain symbol
	defb $84,$06	; parchment edges
	defb $82,$07	; bottom half of empire symbol (a city)
	defb $83,$06	; parchment edges
	defb $92,$00	; bottom half of first line of big map
	defb $83,$06	; parchment edges
	defb $82,$00	; bottom half of terrain symbol
	defb $83,$06	; parchment edges
	defb $84,$17	; "WORLD" title
	defb $82,$06	; parchment edges
	defb $92,$00	; top half of second line of big map
	defb $82,$06	; parchment edges
	defb $84,$17	; "LOCAL" title
	defb $88,$06	; parchment edges and blank space
	defb $92,$00	; bottom half of second line of big map
	defb $8e,$06	; parchment edges, blank space and wheat (left)
	defb $92,$00	; top half of third line of big map
	defb $8a,$06	; parchment edges and some wheat
	defb $77	; white bread
	defb $83,$06	; parchment edges
	defb $92,$00	; bottom half of third line of big map
	defb $84,$06	; parchment edges and a bit of wheat
	defb $77	; white bread
	defb $83,$06	; parchment edges
	defb $84,$17	; world food
	defb $82,$06	; parchment edges
	defb $92,$00	; top half of fourth line of big map
	defb $82,$06	; parchment edges
	defb $84,$17	; local food
	defb $84,$06	; parchment edges and some wood
	defb $16	; wood and bark
	defb $83,$06	; parchment edges
	defb $92,$00	; bottom half of fourth line of big map
	defb $84,$06	; parchment edges and some wood
	defb $16	; wood and bark
	defb $85,$06	; parchment edges and some wood
	defb $16	; wood and bark
	defb $83,$06	; parchment edges
	defb $92,$00	; top half of fifth line of big map
	defb $84,06	; parchment edges and some wood
	defb $16	; wood and bark
	defb $83,$06	; parchment edges
	defb $84,$17	; world wood
	defb $82,$06	; parchment edges
	defb $92,$00	; bottom half of fifth line of big map
	defb $82,$06	; parchment edges
	defb $84,$17	; local wood
	defb $83,$06	; parchment edges
	defb $82,$47	; iron
	defb $83,$06	; parchment edges
	defb $92,$00	; top half of sixth line of big map
	defb $83,$06	; parchment edges
	defb $82,$47	; iron
	defb $84,$06	; parchment edges
	defb $47,$07	; iron
	defb $83,$06	; parchment edges
	defb $92,$00	; bottom half of sixth line of big map
	defb $83,$06	; parchment edges
	defb $47,$07	; iron
	defb $83,$06	; parchment edges
	defb $84,$17	; world iron
	defb $82,$06	; parchment edges
	defb $92,$00	; top half of seventh line of big map
	defb $82,$06	; parchment edges
	defb $84,$17	; local iron
	defb $83,$06	; parchment edges
	defb $82,$46	; some gold
	defb $83,$06	; parchment edges
	defb $92,$00	; bottom half of seventh line of big map
	defb $83,$06	; parchment edges
	defb $82,$46	; some gold
	defb $84,$06	; parchment edges
	defb $82,$46	; some gold
	defb $83,$06	; parchment edges
	defb $92,$00	; top half of eighth line of map
	defb $83,$06	; parchment edges
	defb $82,$46	; some gold
	defb $83,$06	; parchment edges
	defb $84,$17	; world gold level
	defb $82,$06	; parchment edges
	defb $92,$00	; bottom half of eighth line of map
	defb $82,$06	; parchment edges
	defb $84,$17	; local gold production
	defb $83,$06	; parchment edges
	defb $42,$02	; top half of soldier and banner
	defb $83,$06	; parchment edges
	defb $92,$00	; top half of ninth line of map
	defb $89,$06	; parchment edges, top half of population icon
	defb $42	; bottom half of soldier
	defb $84,$06	; bottom half of banner and parchment edges
	defb $92,$00	; bottom half of ninth line of map
	defb $83,$06	; parchment edges
	defb $02,$05	; trousers and dress of population icon
	defb $83,$06	; parchment edges
	defb $84,$17	; world army numbers
	defb $83,$06	; parchment edges
	defb $90,$17	; message window
	defb $83,$06	; parchment edges
	defb $84,$17	; local population level
	defb $83,$06	; parchment edges
	defb $44,$04	; top half of barbarians icon
	defb $82,$06	; parchment edge
	defb $94,$46	; first line of "Barbarians" title
	defb $06	; parchment edge
	defb $42,$02	; top half of soldier and banner
	defb $44,$04	; top half of barbarians icon
	defb $83,$06	; parchment edges
	defb $44,$04	; bottom half of barbarians icon
	defb $82,$06	; parchment edge
	defb $46	; left edge of "Barbarians" title
	defb $92,$56	; second line of "Barbarians" title
	defb $46	; right edge of "Barbarians" title
	defb $06	; parchment edge
	defb $42,$06	; bottom half of soldier and banner
	defb $44,$04	; bottom half of barbarians icon
	defb $82,$06	; parchment edges
	defb $84,$17	; world barbarians level
	defb $06	; parchment edge
	defb $46	; left edge of "Barbarians" title
	defb $92,$56	; third line of "Barbarians" title
	defb $46	; right edge of "Barbarians" title
	defb $06	; parchment edge
	defb $84,$17	; local barbarians/army level
	defb $87,$06	; parchment edge
	defb $94,$46	; fourth line of "Barbarians" title
	defb $86,$06	; parchment edge
	defb $0
