	;
	; Barbarians ZX
	; Routine for generating a new game
	;
	; These routines generate a random map for the game containing plains,
	; forests, mountains and the sea (or not), sprinkle it with cities, and
	; place the spearhead of an invasion force somewhere on the edge.  Each
	; city has its information placed in the city table, and the empire-
	; wide resource table is set up according to the make-up of the
	; cities.  Finally, some game variables are initialised.
	;
	; This file is INCLUDEd from game.asm and shouldn't be assembled on
	; its own.
	;
	; Copyright (C) Damian Walker 2012
	;

	; Please wait message
.newgam	ld hl,msgwt	; point to "Please Wait" message
	call msgprt	; print message

	; fill the map with plains
	ld a,0		; 0 for plains
	ld hl,datmap	; point hl at datmap
	ld (hl),a	; save the plains there
	ld de,datmap+1	; point de to the following byte
	ld bc,$ef	; 239 squares to go
	ldir		; write to them

	; generate the forest, firest deciding size
.newfst	call rand16	; get a 16-bit random number
	ld hl,randsd	; point to LSB of seed...
	bit 0,(hl)	; and check least significant bit
	jr z,newmnt	; if zero, no forest!
	ld a,$7f	; we're only interested in values 0..119
	call randmo	; so adjust the random number accordingly
	inc a		; ensure range is 1..120
	; plant the forests
.newfpl	ld b,a		; use B to count number of forest places
	ld h,datmap/256	; HL points to map data area
.newfxy	call rand16	; get a random number for placement
	ld a,$f0	; again we want positions 0..239
	call randmo	; sort it!
	ld l,a		; and store the current position in L
.newfpt	ld a,$01	; bbbbbb01 is the code for forest
	ld (hl),a	; plant the trees!
	; random jump: 1 in 16 chance we move elsewhere for next tree
	call rand16	; get a random number
	ld a,(randsl)	; check the seed's LSB
	and $0f		; just the last 4 bits
	jr z,newfjp	; on a 0, we move elsewhere
	; move horizontally before planting next tree
	call rand16	; get a random number
	ld a,3		; which we want to be 0..2
	call randmo	; so do the arithmetic
	sub 1		; and is now -1..+1
	ld e,a		; we'll use E as the offset
	ld a,l		; load map location into A
	and $0f		; we're only interested in the X co-ordinate
	add e		; add the offset to it
	jr c,newfjp	; if we're off the left, we need to move elsewhere
	cp $10		; and if we're off the right...
	jr nc,newfjp	; then similarly we need to move elsewhere
	ld e,a		; store temporarily in E
	ld a,l		; load map location again
	and $f0		; keep the Y co-ordinate
	or e		; and OR the X co-ordinate with it
	ld l,a		; store in L
	; vertically before planting next tree
	call rand16	; get a random number ...
	ld a,3		; ... which we want to be 0..2 ...
	call randmo	; ... so make it so ...
	sub 1		; ... and then make it -1..+1
	sla a		; then multiply it by 16
	sla a		;
	sla a		;
	sla a		;
	ld e,a		; use E as the offset
	ld a,l		; get map location into l
	add e		; add the (vertical) offset to it
	cp $ef		; check we're not on line -1/15
	jr nc,newfjp	; yes we are, move elsewhere
	ld l,a		; store new location in l
	djnz newfpt	; plant the next lot of trees, or...
	jr newmnt	; raise mountains if we're out of acorns
.newfjp	djnz newfxy	; plant new forest if any acorns left

	; generate the mountains
.newmnt	call rand16	; get a random number
	ld hl,randsd	; point to LSB of seed...
	bit 0,(hl)	; and check least significant bit
	jp z,newsea	; if zero, no mountain!
	ld a,$3c	; we're only interested in values 0..59
	call randmo	; so adjust the random number accordingly
	inc a		; ensure range is 1..60
	; grow the mountains
.newmgr	ld b,a		; use B to count number of forest places
	ld h,datmap/256	; HL points to map data area
.newmxy	call rand16	; get a random number for placement
	ld a,$f0	; again we want positions 0..239
	call randmo	; sort it!
	ld l,a		; and store the current position in L
	call rand16	; get a random number for direction
	ld a,(randsl)	; what is the number?
	and $03		; reduce to a cardinal direction
	ld d,a		; d will store our direction
.newmgm	ld a,$02	; 2 is the code for a mountain
	ld (hl),a	; grow a mountain here
	; random jump: 1 in 16 chance we move elsewhere
	call rand16	; get a random number
	ld a,(randsl)	; check the seed's LSB
	and $0f		; just the last 4 bits
	jr z,newmjp	; on a 0, we move elsewhere
	; move horizontally before growing next mountain
	bit 0,d		; is this an east/west range?
	jr z,newmhr	; no, so east/west value is random
	ld a,d		; otherwise east/west taken from direction
	srl a		; higher bit tells us left/right
	jr nz,newmhl	; 1 = right, should remain at +1
	cpl		; 0 = left, should be changed to -1
	jr newmhl	; on to horizontal shift proper
.newmhr	call rand16	; get a random number
	ld a,3		; which we want to be 0..2
	call randmo	; so do the arithmetic
	sub 1		; and is now -1..+1
.newmhl	ld e,a		; we'll use E as the offset
	ld a,l		; load map location into A
	and $0f		; we're only interested in the X co-ordinate
	add e		; add the offset to it
	jr c,newmjp	; if we're off the left, we need to move elsewhere
	cp $10		; and if we're off the right...
	jr nc,newmjp	; then similarly we need to move elsewhere
	ld e,a		; store temporarily in E
	ld a,l		; load map location again
	and $f0		; keep the Y co-ordinate
	or e		; and OR the X co-ordinate with it
	ld l,a		; store in L
	; move vertically before growing next mountain
	bit 0,d		; is this a north/south range?
	jr nz,newmvr	; no, so north/south value is random
	ld a,d		; otherwise north/south taken from direction
	and $01		; isolate the last bit
	jr nz,newmvl	; 1 = down, should be left at +1
	cpl		; 0 = up, should be changed to -1
	jr newmvl	; on to vertical shift proper
.newmvr	call rand16	; get a random number
	ld a,3		; which we want to be 0..2
	call randmo	; so do the arithmetic
	sub 1		; and is now -1..+1
.newmvl	sla a		; multiply y direction by by 16
	sla a		;
	sla a		;
	sla a		;
	ld e,a		; use E as the offset
	ld a,l		; get map location into l
	add e		; add the (vertical) offset to it
	cp $ef		; check we're not on line -1/15
	jr nc,newmjp	; yes we are, move elsewhere for next mountain
	ld l,a		; store new location in l
	djnz newmgm	; grow the next peak, or...
	jr newsea	; on to the sea when we're done
.newmjp	djnz newmxy	; grow new peak if there are any more

	; the sea!
.newsea	call rand16	; random number determines coastlines
	ld a,(randsl)	; which number we load into A
	and $0f		; and isolate the four bits we need
	ld c,a		; use C for coast
	; north coast
	bit 0,c		; is there a north coast in this realm?
	jr z,newssc	; no, look for a south coast
	ld hl,datmap	; point HL to top of map
	ld b,3		; up to 3 rows of sea
	ld de,$ffff	; first row of map is full of sea
	jr newsnf	; flood the first row
.newsnr	call rand16	; random 16-bit number as mask
	ld a,(randsh)	; load in the left-hand half
	and d		; and it with D to take out some sea squares
	ld d,a		; put the result back in d
	ld a,(randsl)	; load in the right-hand half
	and e		; and it with E to take out some sea squares
	ld e,a		; store it back in E
.newsnf	push bc		; store number of rows on stack
	ld b,$10	; there are 16 columns
	ld a,$03	; 3 is the code for sea
.newsn0	or a		; reset carry flag
	rl e		; rotate E left, introducing carry
	rl d		; rotate D left, introducing carry from E
	jr nc,newsn1	; no sea square here!
	ld (hl),a	; store the sea
	set 0,e		; put sea back into DE
.newsn1	inc hl		; look at next byte
	djnz newsn0	; next byte of row
	pop bc		; retrieve number of rows to stack
	djnz newsnr	; next row of north coast
	; south coast
.newssc	bit 2,c		; is there a south coast in this realm?
	jr z,newsew	; no, look for an east coast
	ld hl,datmap+$ef ; point HL to bottom of map
	ld b,3		; up to 3 rows of sea
	ld de,$ffff	; first row of map is full of sea
	jr newssf	; flood the first row
.newssr	call rand16	; random 16-bit number as mask
	ld a,(randsh)	; load in the left-hand half
	and d		; and it with D to take out some sea squares
	ld d,a		; put the result back in d
	ld a,(randsl)	; load in the right-hand half
	and e		; and it with E to take out some sea squares
	ld e,a		; store it back in E
.newssf	push bc		; store number of rows on stack
	ld b,$10	; there are 16 columns
	ld a,$03	; 3 is the code for sea
.newss0	or a		; reset carry flag
	rr d		; rotate D right, introducing carry
	rr e		; rotate E right, introducing carry from D
	jr nc,newss1	; no sea square here!
	ld (hl),a	; store the sea
	set 7,d		; put sea back into DE
.newss1	dec hl		; look at next byte
	djnz newss0	; next byte of row
	pop bc		; retrieve number of rows to stack
	djnz newssr	; next row of north coast
	; east and west coast
.newsew	ld hl,datmap	; point HL at the top of the map
	ld b,$0f	; there are 15 rows
.newser	push bc		; store row count
	call rand16	; get a random number
	ld a,$03	; we want it to be 0..2
	call randmo	; make it so
	inc a		; and then make it 1..3
	ld b,a		; put it in the counter
	ld e,0		; initialise east half of map row to all land
	bit 1,c		; is there an east coast?
	jr z,newsre	; no, skip next bit
	ld e,$e0	; populate E with bits at wrong end
.newsre	rlc e		; rotate bits round to east end of E
	djnz newsre	; until done
	ld a,e		; put into accumulator...
	and $07		; rub out any bits still at west edge
	ld e,a		; and put back into E again
	call rand16	; get a random number for the west coast
	ld a,$03	; we want it to be 0..2
	call randmo	; make it so
	inc a		; and then make it 1..3
	ld b,a		; put it in the counter
	ld d,0		; initialise west half of map row to all land
	bit 3,c		; is there a west coast?
	jr z,newsrw	; no, skip next bit
	ld d,$07	; populate D with bits at wrong end
.newsrw	rrc d		; rotate bits round to west end of D
	djnz newsrw	; continue till done
	ld a,d		; put into accumulator, so we can...
	and $e0		; rub out any bits still at east edge
	ld d,a		; store back in D again
.newsef	ld b,$10	; there are 16 columns
	ld a,$03	; 3 is the code for sea
.newse0	or a		; reset carry flag
	rl e		; rotate E left, introducing carry
	rl d		; rotate D left, introducing carry from E
	jr nc,newse1	; no sea square here!
	ld (hl),a	; store the sea
	set 0,e		; put sea back into DE
.newse1	inc hl		; look at next byte
	djnz newse0	; next byte of row
	pop bc		; retrieve number of rows to stack
	djnz newser	; next row of east/west coasts

	; cities and empire
.newcty	ld a,$30	; start with 48 each of ...
	ld (ttlfod),a	; ... food ...
	ld (ttlwod),a	; ... wood ...
	ld (ttlirn),a	; ... iron ...
	ld (ttlgld),a	; ... and gold
	xor a		; start with 0 each of ...
	ld (ttlpop),a	; ... population ...
	ld (ttltrp),a	; ... troops ...
	ld (ttlbar),a	; ... and barbarians
	ld h,datmap/256	; point HL at the map
	ld b,$0c	; there are 12 cities
.newcxy	call rand16	; get a random row number
	ld a,$0d	; we want the range 1..13
	call randmo	; so make a 0..12
	inc a		; and add 1
	rlca		; double it...
	rlca		; ...and again...
	rlca		; ...and again...
	rlca		; ...and again for row number
	ld l,a		; store in L
	call rand16	; get a random column number
	ld a,$0e	; we want the range 1..14
	call randmo	; so make a 0..13
	inc a		; and add 1
	or l		; OR the row number
	ld l,a		; and store the entire co-ordinate in l
	ld a,(hl)	; what's in the byte we point at?
	cp $03		; we want plains, forest, mountain (0..2)
	jr nc,newcxy	; we hit something else - try elsewhere
	ld a,b		; what city number is this?
	rlca		; rotate it ...
	rlca		; ... so it appears ...
	rlca		; ... in the top ...
	rlca		; ... 4 bits of A
	or $0c		; set the bits for a living city
	or (hl)		; fetch the terrain from the map
	ld (hl),a	; and store back on the map
	push bc		; store B
	call srvcty	; point IX to city table entry
	xor a		; zero A
	ld (ix+$00),a	; town starts producing no food ...
	ld (ix+$01),a	; ... no wood ...
	ld (ix+$02),a	; ... no iron ...
	ld (ix+$03),a	; ... and no gold
	ld a,l		; load city location LSB into A
	sub a,$10	; point at location to the north
	ld l,a		; point HL at location
	di		; during interrupts IY must not be corrupted ...
	push iy		; ... so disable them temporarily and store IY
	push hl		; we want to store map location...
	pop iy		; ...in IY
	ld a,(iy+$00)	; load A from square north of city
	call newcrs	; check resources at square
	ld a,(iy+$0f)	; load A from square west of city
	call newcrs	; check resources at square
	ld a,(iy+$11)	; load A from square east of city
	call newcrs	; check resources at square
	ld a,(iy+$20)	; load A from square south of city
	call newcrs	; check resources at square
	pop iy		; restore pointer to system variables ...
	ei		; ... and resume interrupts
	ld b,4		; there are four resources ...
	ld de,ttlfod	; ... starting with food
	push ix		; transfer city table location ...
	pop hl		; ... to a non-index pointer
.newcf0	ld a,(de)	; load global resource level
	sub (hl)	; subtract this city's rating for that resource
	ld (de),a	; and store global resource level
	ld a,(hl)	; get this city's rating for the appropriate resource
	sla a		; double it
	add a,(hl)	; add rating again, trebling it
	ld (hl),a	; and store it again
	inc hl		; point at next city resource
	inc de		; point at next global resource
	djnz newcf0	; calculate following resouce if not done
	call rand16	; get a random number for population
	ld a,(ix+$00)	; population should be limited by food resource
	or a		; is there food production?
	jr z,newcpp	; no, so population should always be 1
	call randmo	; so reduce seed to that range
.newcpp	inc a		; make sure population is at least 1
	ld (ix+04),a	; save the city's population
	ld hl,ttlpop	; look at the total population
	add a,(hl)	; add the total population
	ld (hl),a	; store as the new total population
	xor a		; zero a
	ld (ix+$05),a	; city starts without garrison
	ld (ix+$06),a	; but any recruited on first turn is ready to move
	ld h,datmap/256	; point HL at the map
	pop bc		; get city count back from stack
	djnz newcnx	; next city if any left to process
	jr newtrp	; on to the armies otherwise
.newcnx	jp newcxy
	; check resources of square adjacent to city
.newcrs	and $03		; we're only interested in the terrain
	ld (newcr0+2),a	; modify indexed instruction 0
.newcr0	inc (ix+00)	; increase appropriate resource by 1
	ret		; return to calling process

	; clear the troop table out
.newtrp	xor a		; table wants filling with zeroes
	ld de,trptbl	; point to troop table
	ld (de),a	; store the zero there
	ld h,d		; set up a transfer from ...
	ld l,e		; ... the location we've just written to ...
	inc de		; ... to the following location ...
	ld bc,$17	; ... for 23 bytes ...
	ldir		; ... and do it.

	; the invaders!
	ld h,datmap/256	; point to map page
.newinv	call rand16	; get a random number
	ld a,(randsh)	; look at MSB of random number
	bit 7,a		; what's the highest bit?
	jr z,newins	; it's 0, invaders come from north/south
	; select a random location on east/west edge, and set inward direction
	ld a,$09	; nine rows on which barbarians might appear
	call randmo	; so make a 0..8 out of the number we've generated ...
	inc a		; ... and increase it till it's 3..11
	inc a		;
	inc a		;
	sla a		; multiply by 16 so it becomes a row number
	sla a		;
	sla a		;
	sla a		;
	ld l,a		; store in L
	ld a,(randsh)	; use MSB of random number used for east/west
	and $01		; we need only the LSBit of this byte
	sub $01		; which we turn into $00 or $ff
	and $0f		; truncated to $0 or $f
	or l		; introduce latitude bits stored in L
	ld l,a		; and store who location back in L
	cpl a		; complement A ...
	and $01		; ... and reduce to its last bit ...
	sub $01		; ... subtract so A is $00 or $FF
	or $01		; ... set last bit so A is -1 or +1
	ld c,a		; use C as the direction
	jr newifd	; on to find free location for invader
	; select a random location on north/south edge, and set inward direction
.newins	ld a,$0a	; ten columns on which barbarians might appear
	call randmo	; so make last random number 0..9
	inc a		; and increase it till it's 3..12
	inc a		;
	inc a		;
	ld l,a		; store in L
	ld a,(randsh)	; MSB of random number used for north/south
	and $01		; we need only the LSBit of this byte
	sub $01		; which we turn into $00 or $ff
	and $0e		; truncated to $0 or $e
	sla a		; multiply by 16 so it becomes a row number
	sla a		;
	sla a		;
	sla a		;
	or l		; introduce longitude bits stored in L
	ld l,a		; and store who location back in L
	rra		; rotate so $e0 becomes $70 or $f0
	cpl a		; complement A ...
	and $10		; ... isolate LSB of row number ...
	sub $10		; ... subtract so A is $00 or $F0 ...
	or $10		; ... set bit so A is -16 OR +16
	ld c,a		; use C as te direction
	; now find a location that's not sea and not occupied
.newifd	ld a,(hl)	; See what's in the map square
	cp $03		; we want to see empty land
	jr c,newifc	; yep, we're fine, jump to next stage
	ld a,l		; no, so take the current location
	add a,c		; add C to move inward on the map
	ld l,a		; store the location for the next try
	jr newifd	; carry on looking
	; check round about to see that we're not next to a city
.newifc	push hl		; we want to store HL...
	pop ix		; ...in IX
	ld de,$fff0	; this is the offset to move one map row backwards
	add ix,de	; point at location to the north
	ld a,l		; get location for comparison
	cp $f0		; is it above the top row?
	jr nc,newinn	; yes, so don't look north as invasion spot at top
	bit 3,(ix+$00)	; look for city to north of invasion spot
	jr nz,newinv	; yes there's a city there, so try another location
.newinn	bit 3,(ix+$0f)	; look for city to west of invasion spot
	jr nz,newinv	; yes there's a city there, so try another location
	bit 3,(ix+$11)	; look for city to east of invasion spot
	jr nz,newinv	; yes there's a city there, so try another location
	cp $df		; is invasion spot at bottom of map?
	jr nc,newild	; yes, skip check to the south
	bit 3,(ix+$20)	; look for city to south of invasion spot
	jp nz,newinv	; yes there's a city there, so try another location
	; there's no adjacent city, so put the barbarians on the map!
.newild	ld a,(hl)	; get terrain from the map
	or $10		; stick a barbarian here
	ld (hl),a	; and store on the map
	xor a		; we need to zero various game variables ...
	ld (mapwin),a	; ... like the top-left location of the visible map ...
	ld (mapcur),a	; ... and the current map cursor position ...
	ld (datend),a	; ... and the fact that the game isn't over yet!
	inc a		; we need to store 1 ...
	ld (ttlbar),a	; as the total number of barbarians on the map

	; display the map and panels
	call mapdrw	; full-window map display
	call panwld	; and the world panel

	; ask for level
.newlvl	ld a,(datlvl)	; load current level
.newlin	ld d,0		; zero high byte of DE
	ld e,a		; put level into low byte DE
	sla e		; mutiply by length of all level names ...
	sla e		; ... giving position of name in level text
	ld hl,newltx	; point HL to the level names
	add hl,de	; position of level text
	ld de,msglvl+9	; now DE will point into "LEVEL:????" string
	ldi		; copy first byte ...
	ldi		; ... then the second ...
	ldi		; ... then the third ...
	ldi		; ... and fourth till level prompt is complete
	ld hl,msglvl	; point HL to the level prompt ...
	call msgprt	; ... and print it
.newlwc	call ctlrel	; ensure controls are released (or repeat timeout)
	call ctlact	; wait until a control is activated
	and $13		; isolate bits for fire, left and right
	jr z,newlwc	; continue until one of required controls pressed
	bit 4,a		; is fire pressed?
	jr nz,newlfn	; yes, set new level and continue
	ld b,a		; store in controls in B as we'll need to use A
	ld a,(datlvl)	; retrieve current level
	bit 0,b		; is right pressed?
	jr z,newlkl	; no, check for left key
	inc a		; increase level
	cp $03		; is it harder than HARD?
	jr nz,newlkl	; no, so continue to check for right
	xor a		; yes, so set to zero
.newlkl	bit 1,b		; is left pressed?
	jr z,newlst	; no, back to input again
	dec a		; decrease level
	jp p,newlst	; if not easier than EASY, back to input again
	ld a,2		; otherwise, set to HARD
.newlst	ld (datlvl),a	; store control
	jr newlin	; and continue input till FIRE pressed
	; data for the level names
.newltx	defm "EASY"	; Easy level text
	defm "FAIR"	; Fair level text
	defm "HARD"	; Hard level text
	; finish selecting level
.newlfn	ld hl,msgblk	; point at the blank message ...
	call msgprt	; ... and display it

