	;
	; Barbarians ZX
	; Recruit new troops from a city
	;
	; Contains a single routine that checks population and remaining iron
	; to see how many troops could be recruited at this city, allows the
	; player to choose the number within this limit, and converts the
	; required numbers population and iron into a garrison of troops.
	;
	; This file is INCLUDEd from game.asm and shouldn't be assembled on
	; its own.
	;
	; Copyright (C) Damian Walker 2012
	;

	; entry point - check first that the game is not already over
.recrut	ld a,(datend)	; look at the end game flags
	or a		; are either of them set?
	jp nz,turend	; yes, so remind the player the game is over

	; on to recruitment - first check population
	ld a,(mapcur)	; look at current map postion
	ld h,datmap/256	; point at the map page ...
	ld l,a		; ... and at the very location
	ld a,(hl)	; what is there?
	bit 3,a		; is it a city?
	jr z,recnci	; no, give error message
	bit 2,a		; is it in ruins?
	jr z,recnci	; yes, give error message
	call srvcty	; point IX at a city's entry in the city table
	ld a,(ix+$04)	; load in the population
	dec a		; work out the maximum number of troops available
	jr z,recnpo	; if none, give error message
	ld hl,ttlirn	; point at the iron store
	cp (hl)		; is it less than maximum?
	jr z,recsmx	; we have exactly enough iron to recruit everyone
	jr c,recsmx	; we have more than enough iron to recruit everyone
	ld a,(hl)	; we have only iron enough to recruit some or none
	or a		; is there any iron at all?
	jr z,recnoi	; no, give an error
.recsmx	ld (wrkmax),a	; record the maximum troops
	; ask player how many troops to recruit
	ld hl,msgrec	; point to the "Recruit" message ...
	call msgprt	; ... and display it
	ld a,(wrkmax)	; we default to recruiting everyone
	call ctlnum	; input the troop numbers
	; recruit the troops
	ld c,a		; store number of troops recruited
	ld a,(ix+$04)	; what is the population?
	sub c		; take away the newly recruited troops
	ld (ix+$04),a	; and record the remaining population
	ld a,(ix+$05)	; how many troops currently here?
	add c		; add the new recruits
	ld (ix+$05),a	; store troop numbers in city garrison
	ld a,(ttltrp)	; how many troops in the whole empire?
	add c		; again, add the new recruits
	ld (ttltrp),a	; and store the updated total
	ld a,(ttlirn)	; how much iron in the empire?
	sub c		; subtract what we used to arm the troops
	ld (ttlirn),a	; and store the updated total
	ld a,(ttlpop)	; what's the population?
	sub c		; subtract those who joined the army
	ld (ttlpop),a	; and store the updated total
	call panwld	; update the world panel
	call panlcm	; update the local panel
	jp cursor	; back to browsing the map

	; various excuses for avoiding the draft :-)
.recnci	ld hl,msgnci	; point to message "not a city"
	jr recerr	; on to print it
.recnpo	ld hl,msgnpo	; point to message "too few people"
	jr recerr	; on to print it
.recnoi	ld hl,msgnoi	; point to message "no iron"
.recerr	jp errprt	; print the error message