	;
	; Barbarians ZX
	; Process battles and report the results
	;
	; These routines deal with battles, whether the battles are armies
	; attacking barbarians, barbarians attacking armies, or barbarians
	; attacking cities.  They also include the side effects of disappearing
	; barbarians, disbanding (defeated) armies, and ruined cities.
	;
	; This file is INCLUDEd from game.asm and shouldn't be assembled on
	; its own.
	;
	; Copyright (C) Damian Walker 2012
	;

	; ascertain size of force for each side
	; HL = attacker pointer, DE = defender pointer
.battle	ld bc,wrkbat	; point BC at first location of battle table
.battlp	ld a,(hl)	; what is at the appropriate square?
	bit 2,a		; is it something of ours?
	jr nz,batour	; yes, see how many troops are there
	bit 3,a		; is it a ruined city?
	ret nz		; yes, one does not attack a ruin, otherwise:
	srl a		; it's full of barbarians, count them.
	srl a		;
	srl a		;
	srl a		;
	ld (bc),a	; store as force size for this side of battle
	jr batatk	; work out the attack strength
.batour	bit 3,a		; is it a city?
	jr nz,batcty	; yes, work out the garrison numbers, otherwise:
	call srvtrp	; point IX to troop table entry
	set 0,(ix+1)	; set flag to say this army has moved
	ld a,(ix+0)	; load in troop numbers
	ld (bc),a	; store as force size for this side
	jr batatk	; on to work out attack strength
.batcty	push bc		; B gets overwritten, but we need it
	call srvcty	; point IX to city table entry
	pop bc		; retrieve our battle table pointer
	set 0,(ix+6)	; set flag to say that garrison has moved
	ld a,(ix+5)	; load garrison size
	or a		; reset the zero flag if there's a garrison
	ld (bc),a	; store at force size for this side
	jr z,batnog	; if no garrison, no attack value!
	; work out an attack value for this side
.batatk	call rand16	; roll our 65536-sided dice
	call randmo	; reduce that number to value attainable by our force
	inc a		; make it 1..n rather than 0..n-1
.batnog	inc bc		; point at the attack value for this side
	ld (bc),a	; store the attack
	; now for the other side
	inc bc		; point at the other side's force size
	ex de,hl	; swap attacker and defender pointers
	; DANGER WILL ROBINSON!
	; If the value of wrkbat changes, next line will need revising
	bit 1,c		; have we processed both sides?
	jr z,battlp	; no, so go back to process the defender

	; apply casualties to both sides
	ld ix,wrkbat	; point at the battle table
	ld a,(ix+0)	; take the attacking force size
	sub (ix+3)	; reduce it according to ferocity of defence
	jp p,batasu	; if still positive, accept the value as survivors
	xor a		; set survivors to "none"
.batasu	ld (ix+0),a	; store attacking survivors' numbers
	ld a,(ix+2)	; take the defending force size
	sub (ix+1)	; reduce according to ferocity of attack
	jp p,batdsu	; if still positive, accept the value as survivors
	xor a		; otherwise, set survivors to "none"
.batdsu	ld (ix+2),a	; store attacking defenders' numbers

	; apply the effects of the battle to the persistent game data
	ld bc,wrkbat	; point BC at battle table
.bateff	ld a,(hl)	; who was on this side?
	bit 2,a		; was it someone of ours?
	jr nz,bateor	; yes, see how many troops were there

	; process barbarian casualties
	ld a,(bc)	; barbarians - how many are left?
	ld d,a		; put aside
	ld a,(hl)	; how many were there before the battle?
	srl a		;
	srl a		;
	srl a		;
	srl a		;
	sub d		; these are the casualties ...
	ld d,a		; ... put aside for a moment
	ld a,(ttlbar)	; how many barbarians were invading the empire?
	sub d		; subtract the casualties
	ld (ttlbar),a	; store the new total
	; apply casualties to local map square
	ld a,(bc)	; recall numbers of barbarians left
	add a,a		; shift into upper half of byte
	add a,a		;
	add a,a		;
	add a,a		;
	ld d,a		; store away for a moment
	ld a,(hl)	; recall what was on the map square
	and $0f		; mask away old barbarian numbers
	or d		; apply new barbarian numbers
	ld (hl),a	; store again on the map
	; write out the battle message
	di		; we're mucking about with HL' so diable interrupts
	exx		; we need to preserve all the registers
	ld de,msgbat	; point destination at battle message
	ld hl,batnme	; point source at enemy battle message
	ld bc,7		; we copy seven characters
	ldir		; copy the half-message
	and $f0		; are tree any barbarians left?
	jr z,batnde	; no, so enemy defeated
	ld hl,batnam	; yes, so enemy merely "attacked"
	jr batnms	; on to copy message
.batnde	ld hl,batndm	; point source at enemy battle message
.batnms	ld bc,9		; we copy nine characters
	ldir		; copy the half-message
	exx		; retrieve all the registers
	ei		; enable interrupts again
	jp batenx	; go on to process other side's casualties

	; process our casualties
.bateor	bit 3,a		; is this a city?
	jr nz,batect	; yes, on to city casualties

	; process our troop casualties
	call srvtrp	; point IX to the troop table entry
	ld a,(bc)	; how many troops are left?
	ld d,a		; put aside
	ld a,(ix+0)	; how many were there before?
	sub d		; these are the casualties ...
	ld d,a		; ... put aside for a moment
	ld a,(ttltrp)	; how many barbarians were invading the empire?
	sub d		; subtract the casualties
	ld (ttltrp),a	; store the new total
	; start the battle message
	ld a,(hl)	; recall square contents
	srl a		; convert to an offset in the names table
	and $f8		;
	sub $08		;
	di		; we're mucking about with HL' so diable interrupts
	exx		; store all the registers
	push hl		; store the one we shouldn't mess with
	ld hl,namgen	; point source at general names
	ld d,0		; transfer general name offset to de
	ld e,a		;
	add hl,de	; now we are pointing to the right general
	ld de,msgbat	; point destination at battle message
	ld bc,8		; general names are eight characters
	ldir		; transfer general name to battle message
	ld hl,batres	; now point source to "resists" (we're optimistic)
	ld bc,8		; also eight characters, including space
	ldir		; transfer this to the battle message
	pop hl		; restore the value destined for hl'
	exx		; recall all the registers
	ei		; enable interrupts again
	; now update the troop table
	ld a,(bc)	; remind me, how many survivors?
	ld (ix+0),a	; store in the troop table
	or a		; are there any at all?
	jr nz,batenx	; yes, so we don't need to remove the army, otherwise:
	; remove army from local map and alter the battle message
	ld a,(hl)	; look at the map square
	and $03		; remove everything except the underlying terrain
	ld (hl),a	; store that map square
	di		; we're mucking about with HL' so diable interrupts
	exx		; store all the registers
	push hl		; we mustn't mess with HL'
	ld hl,batrou	; point source at "routed"
	ld de,msgbat+8	; point destination into battle message
	ld bc,8		; this is eight characters
	ldir		; transfer report to battle message
	pop hl		; restore HL' to its proper value
	exx		; recall all the registers
	ei		; enable interrupts again
	jr batenx

	; process casualties against city
.batect	push bc		; note battle table pointer
	call srvcty	; point IX to the city table entry
	pop bc		; recall battle table pointer
	ld a,(bc)	; how many are left in the garrison?
	ld d,a		; put aside
	ld a,(ix+5)	; how many were there before?
	sub d		; these are the casualties ...
	ld d,a		; ... put aside for a moment
	ld a,(ttltrp)	; how many barbarians were invading the empire?
	sub d		; subtract the casualties
	ld (ttltrp),a	; store the new total
	; start the battle message
	ld a,(hl)	; recall square contents
	srl a		; convert to an offset in the names table
	and $f8		;
	sub $08		;
	di		; we're mucking about with HL' so diable interrupts
	exx		; store all the registers
	push hl		; we mustn't mess with HL'
	ld hl,namcty	; point source at city names
	ld d,0		; transfer city name offset to de
	ld e,a		;
	add hl,de	; now we are pointing to the right city
	ld de,msgbat	; point destination at battle message
	ld bc,8		; city names are eight characters
	ldir		; transfer city name to battle message
	ld hl,batres	; now point source to "resists" (we're optimistic)
	ld bc,8		; also eight characters, including space
	ldir		; transfer this to the battle message
	pop hl		; restore HL' to its proper value
	exx		; recall all the registers
	ei		; enable interrupts again
	; now update the city table
	ld a,(bc)	; remind me, how many survivors in the garrison?
	ld (ix+5),a	; store in the city table
	or a		; are there any at all?
	jr nz,batenx	; yes, so we don't need to remove the city, otherwise:
	; DANGER WILL ROBINSON!
	; If the value of wrkbat changes, next line will need revising
	bit 1,c		; is the city the attacker?
	jr nz,batenx	; yes, so it shouldn't fall if the sally fails
	; remove city from local map and alter the battle message
	ld a,(hl)	; look at the map square
	and $fb		; remove the "city is ours" bit
	ld (hl),a	; store that map square
	ld a,(ttlpop)	; what is the empire's population?
	sub (ix+4)	; remove this city's (former) population
	ld (ttlpop),a	; store new population
	xor a		; we want to store zero to ...
	ld (ix+4),a	; ... the city's population
	di		; we're mucking about with HL' so diable interrupts
	exx		; store all the registers
	push hl		; we mustn't mess with HL'
	ld hl,batrun	; point source at "ruined"
	ld de,msgbat+8	; point destination into battle message
	ld bc,8		; this is eight characters
	ldir		; transfer report to battle message
	pop hl		; restore HL' to its proper value
	exx		; recall all the registers
	ei		; enable interrupts again

	; now for the other side
.batenx	inc bc		; point at the other side's force size
	inc bc		;
	ld d,h		; we spoiled D, it should once again be equal to H
	ex de,hl	; swap attacker and defender pointers
	; DANGER WILL ROBINSON!
	; If the value of wrkbat changes, next line will need revising
	bit 1,c		; have we processed both sides?
	jp z,bateff	; no, so go back to process the defender

	; all done - leave screen updates to calling routine
	ld hl,msgbat	; point to the battle message for the defenders
	call notprt	; print as a notification
	ret		; all done with this battle

	;
	; Bits of messages
	;

	; enemy being attacked
.batnme	defm " ENEMY "
.batnam	defm "ATTACKED "
.batndm	defm "DEFEATED "

	; generals and cities being attacked
.batres	defm " DEFENDS"
.batrou	defm " ROUTED!"
.batrun	defm " RUINED!"
