	;
	; Barbarians ZX
	; Player control routines
	;
	; These control player input by keyboard or kempston joystick.  If the
	; player selects joystick at the beginning of the program, then the
	; joystick routine is moved to overwrite the keyboard routines - other
	; parts of the program then exclusively call the keyboard routine
	; address without worrying about what the actual control method is.
	;
	; Both routines store the status of the controls in a variable CTLOPT,
	; with the following bits set: bit 4 for FIRE, 3 for UP, 2 for DOWN, 1
	; for LEFT and 0 for RIGHT (values 16, 8, 4, 2, 1 respectively).  The
	; POLl routines also leave this value in the accumulator.
	;
	; This file is INCLUDEd from game.asm and shouldn't be assembled on
	; its own.
	;
	; Copyright (C) Damian Walker 2012
	;

	;
	; Numeric selection routine
	;

	; take A as the currently selected number, and store and print it
.ctlnum	call ctlndi	; display the default number
.ctlndl	call kbdpol	; read the controls
	and $1f		; just the controls
	jr nz,ctlndl	; wait until they are all released
	; main control loop which runs till FIRE is activated
.ctlnlp	call ctlqrl	; ensure that nothing's pressed
	call ctlact	; wait for control to be activated
	bit 4,a		; is FIRE activated?
	jr nz,ctlndn	; yes, so we're done here
	bit 1,a		; is LEFT activated?
	jr nz,ctlndc	; yes, so decrement the number
	bit 0,a		; is RIGHT activated?
	jr nz,ctlnic	; yes, so increment the number
	jr ctlnlp	; otherwise continue reading controls
	; decrement number when LEFT is activated
.ctlndc	ld a,(wrkncs)	; look at number currently selected
	or a		; check to see if it's zero
	jr z,ctlnlp	; if it is, ingore the decrement
	dec a		; otherwise, decrement a
	call ctlndi	; update display
	jr ctlnlp	; continue reading
	; increment number when RIGHT is activated
.ctlnic	ld a,(wrkmax)	; look at the maximum allowed value
	ld c,a		; store it for comparison
	ld a,(wrkncs)	; look at the currently selected number
	cp c		; compare with the maximum
	jr z,ctlnlp	; if already at maximum, ingore increment
	inc a		; otherwise, increment a
	call ctlndi	; update display
	jr ctlnlp	; continue reading
	; finish editing the number, load into accumulator
.ctlndn	ld a,(wrkncs)	; load A with number currently selected
	ret		; return

	; display the selected number before waiting for a control
.ctlndi	ld (wrkncs),a	; store number currently selected
	call numasc	; convert it to an ASCII string
	ld hl,wrknum	; point source at the string
	ld de,$5075	; point destination near end of message window
	ld b,3		; we want to print 3 characters
	call msgprc	; so get on with it
	ret
	;
	; Wait routines
	;

	; wait until all controls but fire are released (entry point)
.ctlrdr	ld d,$0f	; we're looking for direction controls only
	jr ctlspd	; skip to setting speed
	; wait until ALL controls are released with quick timeout
.ctlqrl	ld d,$1f	; check for all controls
	ld c,$04	; timeout about 12 times per second
	jr ctlrlp	; skip to control release loop
	; wait until ALL controls are released (alternative entry point)
.ctlrel	ld d,$1f	; we're waiting for ALL controls to be released
	; wait until controls are released
.ctlspd	ld c,$08	; move approximately 6 times per second
.ctlrlp	call kbdpol	; poll the control device
	and d		; isolate the bits used for controls
	jr z,ctlrdn	; break out of the loop if nothing pressed
	halt		; otherwise wait for an interrupt ...
	dec c		; ... decrease the timer ...
	jp p,ctlrlp	; ... and scan the controls again or time out
.ctlrdn	ret		; done

	; wait until a control is activated
.ctlact	call kbdpol	; poll the control device
	and $1f		; isolate the bits used for controls
	jr z, ctlact	; repeat until something is activated
	ret		; done

	;
	; Poll routines
	;

	; poll the keyboard
.kbdpol	ld b,5		; number of controls to scan
	ld hl,kbdtbl	; look at table of keystable of keys
.kbdchk	ld a,(hl)	; which keyboard row to look at?
	inc hl		; then the next next byte ...
	in a,($fe)	; look at that keyboard row
	and (hl)	; ... isolates the specific key (Z flag = pressed)
	inc hl		; point at next byte without hurting flags
	ld a,(ctlopt)	; load the current value from CTLOPT
	jr nz,kbdrol	; key is up, leave carry reset
	scf		; key is down, set carry flag
.kbdrol	rl a		; rotate carry flag into CTLOPT
	ld (ctlopt),a	; store value in CTLOPT
	djnz kbdchk	; check next key if appropriate
	ret		; return
.kbdtbl	defb $fd,$01	; FIRE (A)
	defb $fd,$02	; UP (S)
	defb $fe,$04	; DOWN (X)
	defb $7f,$08	; LEFT (N)
	defb $7f,$04	; RIGHT (M)

	; poll the kemptston joystick
.joypol	in a,($1f)	; check kempston
	ld (ctlopt),a	; save bits directly to ctlopt
	ret		; return

