	;
	; Barbarians ZX
	; End-of-turn Processing
	;
	; There are four parts here: the spread of the barbarians, the
	; economic updates, resetting all troop "exhausted" markers so they
	; can move again, and checking for end game.  The economic updates bit
	; also resets city "exhausted" markers so the garrison can move out
	; once more.
	;
	; This file is INCLUDEd from game.asm and shouldn't be assembled on
	; its own.
	;
	; Copyright (C) Damian Walker 2012
	;

	; check first that the game is not already over
.turn	ld a,(datend)	; look at the end game flags
	or a		; are either of them set?
	jp nz,turend	; yes, so remind the player the game is over

	; then "please wait"
	ld hl,msgwt	; point to "please wait" message
	call msgprt	; print it

	;
	; Spread the barbarians!
	;

	; grow the barbarian numbers in their own squares
	ld hl,datmap	; point at the map
	ld b,$f0	; there are 240 squares
.turswl	ld a,(hl)	; what is here?
	bit 2,a		; is there something belonging to the player?
	jr nz,turswn	; yes, on to next square
	bit 3,a		; is there a dead city?
	jr nz,turswn	; yes, on to next square
	cp $10		; are there any barbarians here?
	jr c,turswn	; no, on to the next square
	and $f0		; lose all but barbarian numbers x 16
	ld c,a		; remember them
	call rand16	; get us a random number
	ld a,(randsd)	; what is it?
	and $f0		; mask off lower bits
	cp c		; is it greater than the barbarian numbers?
	jr c,turswn	; no, so no increase
	jr z,turswn	; the numbers are equal, so still no increase
	ld a,(hl)	; retrieve square contents
	add $10		; increase barbarian numbers
	ld (hl),a	; and store again
	ld a,(ttlbar)	; load total barbarians on the map
	inc a		; add one
	ld (ttlbar),a	; save the value
	cp $f0		; is it 240 or above?
	jr c,turswn	; no, we avoid defeat due to number of enemies
	ld a,$02	; the mark of defeat
	ld (datend),a	; store in the "end game" byte
	ld hl,msgovw	; point to the "overwhelmed" message
	jp turegm	; report the sorry tale
	jp turfin	; finish
.turswn	inc hl		; point to next square
	djnz turswl	; continue until done

	; build a list of suitable target squares to invade
	ld hl,datmap	; point source at map
	ld de,turtgt	; point destination at target table
	ld bc,$f000	; there are 240 squares to scan & none found vulnerable
.turtgl	ld a,(hl)	; what is at the map square?
	cp $03		; is it the sea?
	jr z,turtgn	; yes, barbarians aren't lemmings - NEXT!
	cp $10		; is anyone here at all?
	jr c,turtgb	; no, on to look for nearby barbarians who could invade
	bit 2,a		; is this something (living) of the player's?
	jr z,turtgn	; no, must be barbarians or a ruin - NEXT!
.turtgb	push hl		; transfer our map pointer ...
	pop ix		; ... to an index register
	ld a,l		; we need to look carefully where we are
	cp $10		; are we on the top row?
	jr c,turtso	; yes, so don't look north, otherwise:
	ld a,(ix-$10)	; look north
	call turtbc	; check for barbarians & poss mark square as vulnerable
	jr nz,turtgn	; barbarians found! on to next square
	ld a,l		; otherwise recall our location
.turtso	cp $e0		; are we on the bottom row?
	jr nc,turtwe	; yes, don't look south, otherwise:
	ld a,(ix+$10)	; look south
	call turtbc	; check for barbarians & poss mark square as vulnerable
	jr nz,turtgn	; barbarians found! on to next square
	ld a,l		; otherwise recall our location
.turtwe	and $0f		; look only at the horzontal part
	jr z,turtea	; we're at western edge, so don't look west, otherwise:
	ld a,(ix-$01)	; look west
	call turtbc	; check for barbarians & poss mark square as vulnerable
	jr nz,turtgn	; barbarians found! on to next square
	ld a,l		; otherwise recall our location ...
	and $0f		; ... and isolate horizontal part for examination
.turtea	cp $0f		; are we at the eastern edge?
	jr z,turtgn	; yes, don't look east, otherwise:
	ld a,(ix+$01)	; look east
	call turtbc	; check for barbarians & poss mark square as vulnerable
.turtgn	inc hl		; barbarians on to the next map square
	djnz turtgl	; continue scanning till done

	; check whether and how much the barbarians can spread
	ld a,(datlvl)	; what is the difficulty level 0..2?
	inc a		; add 1 to make it 1..3 maximum squares to spread to
	cp a,c		; is the number of vulnerable squares greater?
	jr c,turspr	; yes, so spread limited by level
	ld a,c		; otherwise it's limited by vulnerable squares
	or a		; are there any squares we can spread to?
	jp z,tureco	; no, so no barbarian spread

	; now they can get on with the business of invasion
.turspr	ld b,a		; store the number of squares to expand by
.turspl	call rand16	; get a random number
	ld a,c		; we want to limit it by number of locations
	call randmo	; so do it
	ld hl,turtgt	; point at target table
	ld d,0		; DE is our randomised offset
	ld e,a		; 
	add hl,de	; produce address within target table
	ld a,(hl)	; A is now the map location of the square to invade
	ld l,a		; put it in L
	ld h,datmap/256	; point H to the map page
	ld a,(hl)	; what are the barbarians moving into?
	bit 2,a		; is it something belonging to the player?
	jr nz,turspa	; yes, to attack it!

	; move into an empty square
	or $10		; set first barbarian into the square
	ld (hl),a	; store on the map
	ld a,(ttlbar)	; what are the total barbarian numbers?
	inc a		; add the one we've just created
	ld (ttlbar),a	; store the new total
	cp $f0		; is it 240 or above?
	jr c,turspm	; no, we avoid being overwhelmed by enemies this turn
	ld a,$02	; two is the mark of defeat
	ld (datend),a	; store in the "end game" variable
	ld hl,msgovw	; point to the "overwhelmed" message
	jp turegm	; report the sorry tale

	; attack a player's city or army
.turspa	push de		; preserve target list offset
	call tursbb	; point DE to the largest adjacent horde
	jr z,tursps	; if no adjacent barbarians, no battle
	ex de,hl	; swap source and destination
	push bc
	call battle	; do battle
	pop bc
.tursps	pop de		; restore target list offset

	; remove an attacked square from the list
.turspm	dec c		; there is now one less square to choose from
	ld hl,turtgt	; point HL at the target list
	push hl		; remember HL
	push de		; note the offset we'll be overwriting
	ld e,c		; point HL at the last item in the target list
	add hl,de	;
	ld a,(hl)	; load this location number
	pop de		; restore the offset we're overwriting
	pop hl		; point again at the start of the target list
	add hl,de	; advance pointer to entry for used-up location
	ld (hl),a	; overwrite

	; done with this excursion - any more?
.turspn	djnz turspl	; continue expanding until done

	;
	; Process economics
	;

	; by default we don't sanction cities and armies, that would be rude
.tureco	xor a		; mark down "no sanctions"
	ld (wrksnc),a	; store this value

	; process wood production
	ld a,(ttlwod)	; take the current wood level
	ld b,12		; there are twelve cities to process
	ld ix,ctyinf	; point to the city information table
	ld de,7		; there are seven bytes per table entry
.turwlp	add a,(ix+1)	; add the city's wood production
	cp $f0		; has the total reached or exceeded 240?
	jr nc,turwlm	; yes, skip remaining production and apply limit
	add ix,de	; otherwise look to next city ...
	djnz turwlp	; ... and continue production
	jr turwst	; go to store all the wood
.turwlm	ld a,$ef	; set wood at 239
.turwst	ld (ttlwod),a	; store the wood

	; process iron production
	ld a,(ttlirn)	; take the current wood level
	ld b,12		; there are twelve cities to process
	ld ix,ctyinf	; point to the city information table
	ld de,7		; there are seven bytes per table entry
.turilp	add a,(ix+2)	; add the city's iron production
	cp $f0		; has the total reached or exceeded 240?
	jr nc,turilm	; yes, skip remaining production and apply limit
	add ix,de	; otherwise look to next city ...
	djnz turilp	; ... and continue production
	jr turist	; go to store all the iron
.turilm	ld a,$ef	; set iron at 239
.turist	ld (ttlirn),a	; store the iron

	; process food production and consumption
	ld h,0		; food always starts < 256
	ld d,h		; individual cities' consumption always < 256
	ld a,(ttlfod)	; load current food value ...
	ld l,a		; ... into low half of 16-bit running total
	ld b,12		; there are twelve cities to process
	ld ix,ctyinf	; point to the city information table
.turflp	ld e,(ix+0)	; read in the city's food production
	add hl,de	; add it to our running total
	or a		; clear the carry flag
	ld e,(ix+4)	; read in the population
	sbc hl,de	; subtract that number from the food total
	or a		; clear the carry flag
	ld e,(ix+5)	; read in the garrison numbers
	sbc hl,de	; subtract that number also from the food total
	ld e,7		; we want to advance by 7 bytes to the next city
	add ix,de	; so advance our pointer
	djnz turflp	; process next city
	; check for negative food
	bit 7,h		; has food gone negative?
	jr z,turflc	; no, so skip sanctions and check food limit
	ld hl,0		; zero our food numbers
	ld a,(wrksnc)	; check the current sanctions
	set 0,a		; we need to sanction cities due to lack of food
	ld (wrksnc),a	; store this setting
.turflc	ld a,h		; check upper byte of food
	or a		; is it zero?
	jr nz,turflm	; no, so food needs limiting to 239
	ld a,l		; what's the lower byte of food?
	cp $f0		; does it exceed 239?
	jr c,turfst	; no, so on to store it
.turflm	ld a,$ef	; food tops at 239
.turfst	ld (ttlfod),a	; store food

	; process gold production and consumption
	ld h,0		; gold always starts < 256
	ld d,h		; individual cities' consumption always < 256
	ld a,(ttlgld)	; load current gold value ...
	ld l,a		; ... into low half of 16-bit running total
	ld b,12		; there are twelve cities to process
	ld ix,ctyinf	; point to the city information table
.turgcl	ld e,(ix+3)	; read in the city's gold production (ship money)
	add hl,de	; add it to our running total
	ld a,(ix+0)	; what is the population?
.turgpt	sub 5		; apply poll tax to group of 5 population
	jr c,turgct	; if there were not five people left, finish poll tax
	inc hl		; otherwise collect poll tax from them ...
	jr turgpt	; ... and look for more people to tax :-)
.turgct	inc hl		; finally, apply the city tax
	ld e,(ix+5)	; what troop units have we in the garrison?
	sbc hl,de	; subtract their pay
	ld e,7		; we want to advance by 7 bytes to the next city
	add ix,de	; so advance our pointer
	djnz turgcl	; process next city
	ld ix,trptbl	; now for the troop table
	ld b,12		; there are 12 armies
.turgal	ld e,(ix+0)	; how many troop units in this army?
	sbc hl,de	; subtract their pay
	inc ix		; advance our pointer ...
	inc ix		; ... to the next table line
	djnz turgal	; and continue paying armies till we're done
	; check for negative gold
	bit 7,h		; has gold gone negative?
	jr z,turglc	; no, so skip sanctions and check gold limit
	ld a,(wrksnc)	; yes, so load our sanctions ...
	set 1,a		; set the "no gold left" sanction
	ld (wrksnc),a	; and save this value again
	ld hl,0		; zero our gold
.turglc	ld a,h		; check upper byte of gold
	or a		; is it zero?
	jr nz,turglm	; no, so gold needs limiting to 239
	ld a,l		; what's the lower byte of gold?
	cp $f0		; does it exceed 239?
	jr c,turgst	; no, so on to store it
.turglm	ld a,$ef	; food tops at 239
.turgst	ld (ttlgld),a	; store food

	; update cities, including sanctions
	ld b,12		; start the city count again
	ld ix,ctyinf	; point at the first city
.turcul	xor a		; we want to clear ...
	ld (ix+6),a	; ... the "troops exhausted" bit
	ld a,(ix+4)	; check city's existing population
	or a		; is city in ruins?
	jr z,turclv	; yes, so leave city as is
	ld a,(wrksnc)	; check to see what sanctions apply
	and $01		; are we out of food?
	jr z,turcpi	; no, so on to increase population
	ld hl,ttlpop	; yes, so point to the total population
	dec (hl)	; and decrement that too
	dec (ix+4)	; decrement the city's population
	jr nz,turclv	; if still has population, leave it standing
	ld a,$0d	; B is equal to 13 - city number ...
	sub b		; ... so what city should we look for on the map?
	ld hl,datmap	; point to the map
.turcml	bit 3,(hl)	; is this a city?
	jr z,turcms	; no, skip checks for this square
	ld c,(hl)	; load contents of map square into C
	srl c		; shift city bits into lower nybble ...
	srl c		; ... so we can check against our city number
	srl c		;
	srl c		;
	cp c		; so is this our city?
	jr z,turcru	; yes, knock it down! otherwise:
.turcms	inc l		; point to next map square
	jr turcml	; back to check again
.turcru	res 2,(hl)	; turn the city into a ruin
	push bc		; we need to borrow the counter
	dec a		; reduce city number
	add a,a		; turn it into an offset for the city name table
	add a,a		;
	add a,a		;
	ld e,a		; transfer the offset ...
	ld d,0		; ... to somewhere we can make use of it
	ld hl,namcty	; point to city name table
	add hl,de	; add the offset
	ld de,msgstv	; point to "starves" message
	ld bc,8		; there are eight characters in a city name
	ldir		; transfer them
	pop bc		; recall our city counter
	ld hl,msgstv	; point again at the "starves" message
	call notprt	; display as a notification
	jr turclv	; leave city now
.turcpi	call rand16	; get a random number
	ld a,(randsd)	; what is it?
	and $0f		; we want the range 0 to 15
	ld c,a		; keep it aside
	ld a,(ix+4)	; what is the current population?
	cp c		; does the random number exceed it?
	jr nc,turcbc	; no, so straight on to bankruptcy check, or:
	inc (ix+4)	; yes, so increase the population by 1
	ld hl,ttlpop	; point to total population
	inc (hl)	; increment that too
.turcbc	ld a,(wrksnc)	; check sanctions again
	and $02		; are we bankrupt?
	jr z,turclv	; no, so leave city as is
	ld hl,ttltrp	; point to total troops
	dec (hl)	; and decrement that count
	dec (ix+5)	; decrement the garrison
	jp p,turclv	; if it hasn't gone negative, move on
	inc (ix+5)	; otherwise increase it back to 0 again
	inc (hl)	; and restore total troops
.turclv	ld de,7		; there are seven bytes per city
	add ix,de	; move city pointer to next entry in table
	djnz turcl0	; sanctions for next city
	jr turarm	; all done, go to update armies now
.turcl0	jp turcul	; go on to next city

	; update armies, including sanctions
.turarm	ld b,12		; there are 12 armies
	ld hl,trptbl	; point at the troop table
	ld c,0		; keep a count of the number of deserters
.tuctlp	xor a		; set accumulator to zero, so we can ...
	or (hl)		; ... load it while checking flags
	jr z,turtlv	; if there are no troops, leave as is
	cp 1		; also if there is only one troop ...
	jr z,turtlv	; ... similarly leave as is
	ld a,(wrksnc)	; check the sanctions
	and $02		; are we out of gold?
	jr z,turtlv	; no, so no desertions
	dec (hl)	; otherwise one troop unit deserts
	inc c		; update our running total
.turtlv	inc hl		; point at the "exhausted" byte
	xor a		; get a cheap zero ...
	ld (hl),a	; ... and overwrite the byte with it
	inc hl		; now point to the next entry
	djnz tuctlp	; continue processing armies till done
	; update the empire total
	ld a,(ttltrp)	; load the total troops
	sub c		; subtract any deserters
	ld (ttltrp),a	; store the new total

	;
	; check for end game
	;

	; victory?
	ld a,(ttlbar)	; how many barbarians?
	or a		; have they all gone?
	jr nz,turdef	; no, check for defeat, or:
.turbgn	ld a,$01	; set the "victory" flag
	ld (datend),a	; store in the "end game" byte
	ld hl,msgvic	; point to the victory message
	jp turegm	; spread the good news

	; defeat due to lack of population?
.turdef	ld a,(ttlpop)	; how many population?
	or a		; what, you mean they're all dead?
	jr nz,turfin	; no, so on to update the screen
	ld a,$02	; everybody's dead, Dave
	ld (datend),a	; store in the "end game" byte
	ld hl,msgdef	; point to the defeat message
	jp turegm	; tell the sorry tale

	;
	; Finish turn processing
	;

	; update all displays then return to the map
.turfin	call panwld	; update the Empire panel
	call mapdrw	; redraw the map
	jp cursor	; back to the map

	;
	; Small routines
	;

	; the game is ended - error
.turend	ld hl,msgend	; "the game is over"
	jp errprt	; display error and back to map

	; find the largest horde adjacent to HL, store in DE
.tursbb	push bc		; we use these as workspace
	ld bc,0		; zero our "which" and "how many" workspaces
	push hl		; pass map pointer ...
	pop ix		; ... to index register
	; check barbarians to the north
	ld a,l		; we need to look carefully where we are
	cp $10		; are we on the top row?
	jr c,tursso	; yes, so don't look north, otherwise:
	ld a,(ix-$10)	; look north
	call tursbc	; check for barbarians
	jr z,tursso	; none here, next direction
	ld c,a		; store size of biggest horde so far
	ld b,-$10	; store direction of biggest horde so far
	; check barbarians to the south
.tursso	ld a,l		; otherwise recall our location
	cp $e0		; are we on the bottom row?
	jr nc,turswe	; yes, don't look south, otherwise:
	ld a,(ix+$10)	; look south
	call tursbc	; check for barbarians
	jr z,turswe	; none here, check next direction
	cp c		; does previous horde exceed this one?
	jr c,turswe	; yes, so leave these people be
	ld c,a		; store this as size of biggest horde so far
	ld b,$10	; store direction of this horde
	; check barbarians to the west
.turswe	ld a,l		; otherwise recall our location
	and $0f		; look only at the horzontal part
	jr z,tursea	; we're at western edge, so don't look west, otherwise:
	ld a,(ix-$01)	; look west
	call tursbc	; check for barbarians
	jr z,tursea	; none here, check next direction
	cp c		; does previous horde exceed this one?
	jr c,tursea	; yes, so leave these people be
	ld c,a		; store this as size of biggest horde so far
	ld b,-$01	; store direction of this horde
	; check barbarians to the east
.tursea	ld a,l		; otherwise recall our location ...
	and $0f		; ... and isolate horizontal part for examination
	cp $0f		; are we at the eastern edge?
	jr z,tursbe	; yes, don't look east, otherwise:
	ld a,(ix+$01)	; look east
	call tursbc	; check for barbarians
	jr z,tursbe	; none here, check next direction
	cp c		; does previous horde exceed this one?
	jr c,tursbe	; yes, so leave these people be
	ld c,a		; store this as size of biggest horde so far
	ld b,$01	; store direction of this horde
	; point DE to the largest horde
.tursbe	ld a,c		; how big is the largest horde?
	or a		; is it zero?
	jr z,tursb1	; return if zero, leaving zero flag set
	ld d,0		; set high byte of direction
	bit 7,b		; if direction positive ...
	jr z,tursbn	; ... leave as is
	ld d,$ff	; otherwise, revise high byte of direction
.tursbn	ld e,b		; set low byte of direction
	push hl		; note down current map location
	add hl,de	; add direction offset to it ...
	ex de,hl	; ... giving horde location which we put in DE
	or $ff		; ensure the Z flag is reset
	pop hl		; recall army or city location
.tursb1	pop bc		; recall the counters we noted earlier
	ret		; all done here

	; check square (contents A) for barbarians
.tursbc	bit 2,a		; is something of ours there?
	jr nz,tursb0	; yes, not barbarians!
	bit 3,a		; is there a ruin there?
	jr nz,tursb0	; yes, not barbarians!
	cp $10		; is there anyone there?
	jr c,tursb0	; no, not even barbarians!
	and $ff		; reset the zero flag
	ret		; done
.tursb0	xor a		; set the zero flag
	ret		; done

	; check square (contents A) for barbarians
.turtbc	bit 2,a		; is something of ours there?
	jr nz,turtbn	; yes, not barbarians!
	bit 3,a		; is there a ruin there?
	jr nz,turtbn	; yes, not barbarians!
	cp $10		; is there anyone there?
	jr c,turtbn	; no, not even barbarians!
	ld a,l		; so there are barbarians there after all
	ld (de),a	; *this* square is ripe for conquest
	inc de		; move destination pointer to next target entry
	inc c		; increment counter and reset the zero flag
	ret		; done
.turtbn	xor a		; set the zero flag
	ret		; done

	; end game message - to be printed in the centre of the map
.turegm	push hl		; the following two routines our message pointer
	call panwld	; update the Empire panel
	call mapdrw	; redraw the map
	pop hl		; recall our message pointer
	ld de,$482c	; point to upper half of message area
	ld b,$08	; each line is eight characters
	call msgprc	; print those characters
	ld de,$484c	; point to lower half of message area
	ld b,$08	; bottom line has eight characters too
	call msgprc	; print those characters
	ld ix,$592c	; point IX to upper half of attributes
	ld a,$46	; bright yellow on black
	ld b,$08	; again, eight characters per line
.turegy	ld (ix+$00),a	; turn to character yellow
	ld (ix+$20),a	; turn bottom character yellow
	inc ix		; look at next character
	djnz turegy	; continue until both lines are yellow
	ld hl,msghtf	; "hit fire" message
	call msgprt	; print it
.turerl	call kbdpol	; poll the control device
	and $10		; check the fire button
	jr nz,turerl	; continue doing so till fire released
.turefr	call kbdpol	; poll the control device again
	and $10		; check the fire button again
	jr z,turefr	; continue until fire is pressed
	call mapdrw	; redraw the map
.turer2	call kbdpol	; poll the control device
	and $10		; check the fire button
	jr nz,turer2	; continue doing so till fire released
	jp cursor	; all done

	;
	; Extra storage
	;

	; large workspace - no room for it lower down
.turtgt	defs $f0	; 240 bytes for targets