	;
	; Barbarians ZX
	; Trading in Resources
	;
	; These are the routines for buying and selling.
	;
	; This file is INCLUDEd from game.asm and shouldn't be assembled on
	; its own.
	;
	; Copyright (C) Damian Walker 2012
	;

	;
	; Code specific for Buying
	;

	; entry point - check first that the game is not already over
.mktbuy	ld a,(datend)	; look at the end game flags
	or a		; are either of them set?
	jp nz,turend	; yes, so remind the player the game is over

	; set up the buying of goods
	ld de,msgmkt	; prepare to copy to destination message
	ld hl,txtbuy	; prepare to copy from "buy" text
	ld bc,4		; there are four characters (room for "sell")
	ldir		; copy
	ld b,3		; there are three resources
	ld hl,ttlfod	; starting with food
	ld (wrkres),hl	; store pointer to food
	ld hl,txtfod	; point at text for food
	; main buying loop - 
.mktblp	push bc		; we need to preserve our counter
	ld de,msgmkt+5	; we want to insert resource name into message
	ld bc,4		; all names are same length (food/wood/iron)
	ldir		; copy the resource name
	ld (wrktxt),hl	; store the updated pointer
	ld hl,msgmkt	; point at the entire market message
	call msgprt	; print it
	; determine the maximum of this resource we can buy
	ld a,(ttlgld)	; how much gold is there?
	srl a		; it takes two gold to buy a resource
	ld c,a		; store this maximum for later comparison
	ld a,$ef	; 239 is the maximum we can store
	ld hl,(wrkres)	; point to what is stored currently
	sub (hl)	; subtract it to see how much room we have
	cp c		; is gold a more pressing limit?
	jr c,mktbgt	; no, free space is the limiting factor, or:
	ld a,c		; yes, so use gold as the limit to what we can buy
	; ask how much we want to buy
.mktbgt	ld (wrkmax),a	; and store it in the appropriate variable
	ld a,0		; initialise a to 0
	call ctlnum	; ask user for a number
	; now do the buying
	ld b,a		; store amount we want to buy
	add a,a		; work out the cost
	ld c,a		; store the cost
	ld a,(ttlgld)	; what is our gold?
	sub c		; subtract our costs from it
	ld (ttlgld),a	; put gold back in the vault
	ld a,b		; get back the actual amount of stuff we bought
	ld hl,(wrkres)	; get back the pointer to our current resource
	add (hl)	; add it to what we've just bought
	ld (hl),a	; and store it
	inc hl		; point to next resource
	ld (wrkres),hl	; and store that pointer
	call panwld	; update the empire panel after purchase
	pop bc		; recall our counter
	ld hl,(wrktxt)	; point back at resource text
	djnz mktblp	; on to the next resource, or ...
	call panlcm	; restore the map square description
	jp cursor	; back to the map when we're done

	;
	; Code specific for Selling
	;

	; entry point - check first that the game is not already over
.mktsel	ld a,(datend)	; look at the end game flags
	or a		; are either of them set?
	jp nz,turend	; yes, so remind the player the game is over

	; set up the selling of goods
	ld de,msgmkt	; prepare to copy to destination message
	ld hl,txtsel	; prepare to copy from "buy" text
	ld bc,4		; there are four characters (room for "sell")
	ldir		; copy
	ld b,3		; there are three resources
	ld hl,ttlfod	; starting with food
	ld (wrkres),hl	; store pointer to food
	ld hl,txtfod	; point at text for food
	; main selling loop - 
.mktslp	push bc		; we need to preserve our counter
	ld de,msgmkt+5	; we want to insert resource name into message
	ld bc,4		; all names are same length (food/wood/iron)
	ldir		; copy the resource name
	ld (wrktxt),hl	; store the updated pointer
	ld hl,msgmkt	; point at the entire market message
	call msgprt	; print it
	; determine the maximum of this resource we can sell
	ld hl,(wrkres)	; point at the empire's store for this resource
	ld a,(hl)	; how much is there?
	ld c,a		; store this maximum for later comparison
	ld a,$ef	; 239 is the maximum gold we can store
	ld hl,ttlgld	; point to our treasury
	sub (hl)	; subtract it to see how much room we have
	jp m,mktssp	; gold is 128 or more, so it is not a limit
	add a,a		; two resources are sold for each gold
	cp c		; is space a more pressing limit?
	jr c,mktsgt	; no, gold is the limiting factor, or:
.mktssp	ld a,c		; yes, so use space as the limit to what we can buy
	; ask how much we want to sell
.mktsgt	ld (wrkmax),a	; and store it in the appropriate variable
	ld a,0		; initialise a to 0
	call ctlnum	; ask user for a number
	; now do the selling
	ld b,a		; store amount we want to sell
	srl a		; work out the sale value
	ld c,a		; store the cost
	ld a,(ttlgld)	; what is our gold?
	add c		; add our revenue to it
	ld (ttlgld),a	; put gold back in the vault
	ld hl,(wrkres)	; which resource are we selling again?
	ld a,(hl)	; what was our total store of this resource?
	sub b		; take out what we have sold
	ld (hl),a	; and store it
	inc hl		; point to next resource
	ld (wrkres),hl	; and store that pointer
	call panwld	; update the empire panel after purchase
	pop bc		; recall our counter
	ld hl,(wrktxt)	; point back at resource text
	djnz mktslp	; on to the next resource, or ...
	call panlcm	; restore the map square description
	jp cursor	; back to the map when we're done

	;
	; Partial Messages
	;

	; buy or sell?
.txtbuy	defm "BUY "
.txtsel	defm "SELL"

	; what resource?
.txtfod	defm "FOOD"
	defm "WOOD"
	defm "IRON"