	;
	; Intergalactic Space Rescue - a puzzle game for the 16K ZX Spectrum
	; Assembler code for the arithmetic routines
	;
	; Copyright (C) Damian Walker 2012
	; Created 15-Dec-2012
	;

	; Integer 8-bit division
	; inputs:
	;   D = divisor
	;   E = dividend
	; outputs:
	;   D = quotient
	;   E = remainder
.div8	ld a,d		; move divisor to accumulator
	ld d,0		; initialise quotient
.div8lp	sub e		; loop - subtract dividend from divisor
	jr c,div8dn	; quit if we're below zero
	inc d		; otherwise increment quotient ...
	jr div8lp	; ... and go to subtract again
.div8dn	add e		; restore remainder
	ld e,a		; store remainder in E
	ret		; all done

	; Integer 16-bit division
	; inputs:
	;   HL = divisor
	;   DE = dividend
	; outputs:
	;   HL = remainder
	;   DE = quotient
.div16	push bc		; store BC as we'll be using it as the quotient
	ld bc,0		; initialise the quotient
	or a		; reset the carry flag
.div16r	sbc hl,de	; loop - subtract dividend from divisor
	jr c,div16d	; quit if we're below zero
	inc bc		; otherwise increment quotient ...
	jr div16r	; ... and go to subtract again
.div16d	add hl,de	; restore remainder
	ld d,b		; move quotient to DE
	ld e,c		;
	pop bc		; restore BC
	ret		; all done