	;
	; Intergalactic Space Rescue - a puzzle game for the 16K ZX Spectrum
	; Player control routines
	;
	; These control player input by keyboard or kempston joystick.  If the
	; player selects joystick at the beginning of the program, then the
	; joystick routine is moved to overwrite the keyboard routines - other
	; parts of the program then exclusively call the keyboard routine
	; address without worrying about what the actual control method is.
	;
	; Both routines store the status of the controls in a variable CTLOPT,
	; with the following bits set: bit 4 for FIRE, 3 for UP, 2 for DOWN, 1
	; for LEFT and 0 for RIGHT (values 16, 8, 4, 2, 1 respectively).  The
	; POLl routines also leave this value in the accumulator.
	;
	; This file is INCLUDEd from game.asm and shouldn't be assembled on
	; its own.
	;
	; Copyright (C) Damian Walker 2012
	; Created 13-Dec-2012
	;

	;
	; Wait routines
	;

	; wait until all controls are released
.ctlrel	call ctlpol	; poll the controls
	or a		; is anything activated?
	jr nz,ctlrel	; yes, so continue waiting
	ret		; return when done

	; wait until any control is activated
.ctlact	call ctlpol	; poll the controls
	or a		; is anything activated?
	jr z,ctlact	; no, so continue waiting
	ret		; return when done

	; wait until FIRE is activated
.ctlfir	call ctlpol	; poll the controls
	bit 4,a		; is fire pressed?
	jr z,ctlfir	; no, go back to poll controls again
	ret		; otherwise return

	;
	; Poll routines
	;

	; entry address of poll routines
.ctlpol			; usual address when called from elsewhere

	; poll the keyboard
	;   constant CTLOPT = address to save 5-bit activated controls to
	;   returns A = copy of byte saved to CTLOPT
.kbdpol	push bc		; save BC which we overwrite
	push hl		; save HL which we overwrite
	ld b,5		; number of controls to scan
	ld hl,kbdtbl	; look at table of keystable of keys
.kbdchk	ld a,(hl)	; which keyboard row to look at?
	inc hl		; then the next next byte ...
	in a,($fe)	; look at that keyboard row
	and (hl)	; ... isolates the specific key (Z flag = pressed)
	inc hl		; point at next byte without hurting flags
	ld a,(ctlopt)	; load the current value from CTLOPT
	jr nz,kbdrol	; key is up, leave carry reset
	scf		; key is down, set carry flag
.kbdrol	rl a		; rotate carry flag into CTLOPT
	ld (ctlopt),a	; store value in CTLOPT
	djnz kbdchk	; check next key if appropriate
	pop hl		; retrieve HL as it was on entry
	pop bc		; retrieve BC as it was on entry
	ret		; return
.kbdtbl	defb $fd,$01	; FIRE (A)
	defb $fd,$02	; UP (S)
	defb $fe,$04	; DOWN (X)
	defb $7f,$08	; LEFT (N)
	defb $7f,$04	; RIGHT (M)

	; poll the kemptston joystick
	;   constant CTLOPT = address to save 5-bit activated controls to
	;   returns A = copy of byte saved to CTLOPT
.joypol	in a,($1f)	; check kempston
	ld (ctlopt),a	; save bits directly to ctlopt
	ret		; return

