	;
	; Intergalactic Space Rescue - a puzzle game for the 16K ZX Spectrum
	; Assembler code for various game logic routines
	;
	; Copyright (C) Damian Walker 2012
	; Created 18-Dec-2012
	;

	;
	; Gameplay routines
	;

	; implement side effects on moving
	; inputs:
	;   A = proposed new ship location
	; outputs:
	;   A = actual new ship location
.shipck	push bc		; store entry values of registers to be corrupted
	push de		;
	push hl		;
	ld (rescxy),a	; make this the ship location (for now)
	ld c,a		; put proposed ship location aside
	call mapmem	; get memory address for map location
	; process effects of ship location
.nflash	ld a,(hl)	; what is there?
	and $7f		; mask out "explored" bit
	or a		; is it deep space?
	jr z,dspace	; yes, process it
	dec a		; planet?
	jr z,planet	; yes, process it
	dec a		; asteroids?
	jr z,asters	; yes, process them
	; to get here we must be at a hyperspace
	set 7,(hl)	; mark location as "seen"
	call h1anim	; show rotation animation
	ld a,(rescxy)	; recall location
	call drtile	; draw the tile as we're about to move away
.hspace	call rand16	; get a random number 0..99
	ld hl,(randsd)	;
	ld de,100	;
	call div16	;
	ex de,hl	; put aside location number
	ld a,e		; what is the location number?
	call mapmem	; point at the address for that location
	ld a,(hl)	; what is there?
	and $7f		; mask out the the "seen" bit
	cp $03		; is it a hyperspace?
	jr nz,hspace	; it's not a hyperspace, try again
	ld a,e		; recall the location number
	cp c		; is it the same as the location we moved to?
	jr z,hspace	; yes, try again (hyperspace should go somewhere else)
	ld c,a		; make this our new proposed location
	ld (rescxy),a	;
	set 7,(hl)	; mark location as "seen"
	call h2anim	; secondary animation
	jr dspafl	; on to decrement fuel as for deep space
	; process asteroids
.asters	set 7,(hl)	; set the "seen" bit
	call a_anim	; animation with asteroid noise
	call rand16	; get a random number 1..shfuel
	ld a,(randsd)	;
	ld d,a		;
	ld a,(shfuel)	; 
	dec a		; 
	jr z,z_fuel	; don't randomise fuel, as we've run out
	ld e,a		; 
	call div8	; 
	inc e		; E contains random number
	ld a,(shfuel)	; recall fuel level
	sub e		; subtract E from it
.z_fuel	ld (shfuel),a	; store new fuel figures
	jr putshp	; done with asteroids
	; process planet
.planet	set 7,(hl)	; set the "seen" bit
	call p_anim	; animation with planet noise
	ld a,$12	; take 18 units of fuel ...
	ld (shfuel),a	; ... and put them in the fuel tank
	jr putshp	; done with planet
	; process deep space
.dspace	ld a,(beacxy)	; first check where the beacon is
	cp c		; is it here?
	jr nz,dsckfl	; no, on to check fuel level
	set 7,(hl)	; set the "seen" bit
	call s_anim	; flash with success noise
	jr dspafl	; on to set this square as seen
.dsckfl	ld a,(shfuel)	; see how much fuel is left
	dec a		; is the ship about to run out?
	jr nz,dscksn	; no, on to check if the square is seen
	set 7,(hl)	; set the "seen" bit
	call f_anim	; flash with failure noise
	jr dspafl	; on to set this square as seen
.dscksn	bit 7,(hl)	; has the player seen this space before?
	jr nz,dspafl	; yes, skip the animation
	set 7,(hl)	; set the "seen" bit
	call d_anim	; flash with deep space noise
.dspafl	ld hl,shfuel	; point at fuel
	dec (hl)	; decrement it
	; put the ship down in its new location
.putshp	ld a,c		; what is its new location?
	ld (rescxy),a	; put the ship there
	call drstat	; update the message and stats
	; check for success
	ld a,(beacxy)	; where is the beacon
	cp c		; is it in the same place as the ship?
	jr z,succss	; yes, so show success message
	call drship	; finally ensure the ship is visible again
	; now check for failure
	ld a,(shfuel)	; what is our fuel?
	or a		; do we have any left?
	jr nz,endmov	; yes, so just go on to end of routine
	; show failure message
.failur	ld hl,faimsg	; point to failure message
	jr shoend	; show as end-of-level message
	; show success message
.succss	call drship	; show the ship at its new location
	ld hl,(mssion)	; check to see what the current mission is
	ld de,999	; we need to test it against 999
	or a		; clear carry flag
	sbc hl,de	; is level number 999?
	jr z,fngame	; yes, the game is over
	ld hl,sucmsg	; point to success message
	jr shoend	; go on to print it
.fngame	;ld hl,finmsg	; point to finished message
	jp victry
.shoend	ld b,8		; six characters per line
	ld de,$484c	; point to lower half row 5 of map
	call msgprc	; print these six characters
	ld b,8		; six characters on second line
	ld de,$486c	; point to upper half row 6 of map
	call msgprc	; print second half of message
	ld hl,$594c	; point to attributes of printed message
	ld (hl),$46	; make first character bright yellow
	push hl		; point to next location on
	pop de		;
	inc de		;
	ld bc,7		; fill in remaining 5 bytes of top line
	ldir		;
	ld de,$5973	; point to end of second line
	ld bc,8		; fill in 6 bytes of bottom line
	lddr		;
	ld hl,firmsg	; point to "press fire" message
	call msgprt	; print it in the normal place
	call ctlrel	; ensure no controls are activated
.endfir	call ctlact	; now wait for fire to be pressed
	bit 4,a		;
	jr z,endfir	;
	call dr_map	; redraw the map
	; and that's it
.endmov	pop hl		; retrieve entry values of registers
	pop de		;
	pop bc		;
	ret		; return to calling program

	;
	; Game calculations
	;

	; calculate the signal strength
	; outputs:
	;   A = strength of signal
.signal	push bc		; store entry values of registers we corrupt here
	push de		;
	push hl		;
	ld a,(rescxy)	; see where the rescue ship is
	ld d,a		; convert this to row/column pair
	ld e,10		;
	call div8	;
	ex de,hl	; put these values aside
	ld a,(beacxy)	; see where the beacon is
	ld d,a		; convert this to row/column pair
	ld e,10		;
	call div8	;
	ld a,d		; find difference between rows
	sub h		;
	jr nc,rowpos	;
	cpl		;
	inc a		;
.rowpos	ld b,a		; put row difference aside
	ld a,e		; find difference between columns
	sub l		;
	jr nc,colpos	;
	cpl		;
	inc a		;
.colpos	ld c,a		; put column difference aside
	ld a,$12	; maximum signal is 18
	sub b		; subtract row distance
	sub c		; subtract column distance
	pop hl		; restore values of corrupted registers
	pop de		;
	pop bc		;
	ret		; done with calculation

	; convert map location to map data memory location
	; inputs:
	;   A = map location
	; outputs:
	;   HL = memory location
.mapmem	push de		; we corrupt DE so store it
	ld e,a		; convert location A into an offset
	ld d,0		;
	ld hl,mapdat	; point HL to map data
	add hl,de	; add the offset
	pop de		; retrieve DE's entry value
	ret		; return to calling process

	;
	; Data for these routines
	;

	; messages for success and failure
.sucmsg	defm "  SHIP   FOUND! "
.faimsg	defm " OUT OF   FUEL  "
.finmsg	defm "  GAME  FINISHED"
.firmsg	defm " PRESS FIRE TO CONTINUE "
