	;
	; Intergalactic Space Rescue - a puzzle game for the 16K ZX Spectrum
	; Assembler code for program initialisation
	;
	; Created 10-Dec-2012
	;

	; set the border colour
	ld a,$00	; we want black border colour
	out ($fe),a	; make it so

	;
	; Ascertain the control method
	;

	; print the message
.ctl	ld hl,ctlmsg	; point at the controls message
	call msgprt	; print it

	; get the player's response
.ctlget	ld a,$bf	; let's look at row J-ENTER of keyboard
	in a,($fe)	; poll keyboard
	and $0c		; isolate J and K
	cp $0c		; are both keys up?
	jr z,ctlget	; continue to read keyboard till J/K pressed
	; transfer the correct input routine to ctlpol
	ld de,ctlpol	; this is where the control routine goes
	ld hl,kbdpol	; assume first that player wants keyboard
	ld bc,6		; we need to copy 6 bytes at most
	and $08		; look specifically at the J key
	jr nz,ctlset	; if up, don't use joystick routine
	ld hl,joypol	; if K not pressed then we want joystick
.ctlset	ldir		; copy the appropriate routine to ctlpol

	;
	; Fill in the screen colours
	;

	; colour the screen according to compressed table
.atr	ld de,$5800	; point DE at attribute file
	ld hl,attrtb	; point HL at compressed attribute table
.atrblk	ld a,(hl)	; first byte of block
	cp 0		; if it's zero...
	jp z,newgam	; then we're done
	bit 7,a		; is this a length byte?
	jr z,atrsng	; no, transfer a single byte
	and $7f		; remove high bit
	ld b,a		; transfer to counter
	inc hl		; next byte is attribute...
	ld a,(hl);	; ...so load it in
	jr atrcpy	; on to copying
.atrsng	ld b,1		; single byte
.atrcpy	ld (de),a	; copy to the screen
	inc de		; point to next location
	djnz atrcpy	; continue till all bytes done
	inc hl		; next byte
	jr atrblk	; next block

	; compressed attribute table
.attrtb	defb $a0,$05	; top line
	defb $05,$84,$47,$05,$94,$00,$05,$84,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$47,$82,$00,$47,$05,$94,$00,$05,$47,$82,$00,$47,$05
	defb $05,$84,$47,$05,$94,$00,$05,$84,$47,$05
	defb $a0,$05	; divider above message line
	defb $84,$05,$98,$44,$84,$05
	defb $a0,$05	; bottom line
	defb $00

	; control message
.ctlmsg	defm "    KEYS OR JOYSTICK    "

