	;
	; Intergalactic Space Rescue - a puzzle game for the 16K ZX Spectrum
	; Assembler code for generation of levels or missions
	;
	; Copyright (C) Damian Walker 2012
	; Created 15-Dec-2012
	;

	;
	; Main generation routine
	;

	; start by saving the registers
.lvlgen	push bc		; preserve the register values
	push de		;
	push hl		;

	; display "Please wait" message
	ld hl,plwait	; point to "Please wait" message
	call notprt	; print it and impose an artificial delay

	; generate level code and initialise random seed
	ld hl,(mssion)	; look at mission number
	call gncode	; generate level code

	; fill the map with empty space
	ld hl,mapdat	; point to start of map
	ld (hl),0	; zero the first map square
	ld bc,99	; there are 99 more
	push hl		; point at the same map space
	pop de		;
	inc de		; one location further
	ldir		; copy the other 99 spaces

	; generate the planets
	ld b,10		; there are ten planets on every level
	ld c,1		; 1 is the code for a planet
	call featur	; generate the planets

	; generate the asteroids
	call diffic	; determine the number of asteroids on this level
	ld c,2		; 2 is the code for an asteroid
	call featur	; generate the asteroids

	; generate the hyperspaces
	call diffic	; determine the number of hyperspaces on this level
	ld c,3		; 3 is the code for a hyperspace
	call featur	; generate the hyperspaces

	; place the ships on the level
.lships	call findmt	; find an empty space for the rescue ship
	ld a,e		; store it ...
	ld (rescxy),a	; ... as current position ...
	ld (rscini),a	; ... and initial position of rescue ship
	call findmt	; fina an empty space for the stricken ship
	ld a,e		; store it ...
	ld (beacxy),a	; ... as the beacon position
	call signal	; calculate signal strength
	cp 10		; is it 10 or stronger?
	jr nc,lships	; yes, we're too near, try again
	ld a,(rescxy)	; recall ship location
	call mapmem	; convert to an address
	set 7,(hl)	; mark location as "seen"
	ld a,$12	; get a tank full of fuel ...
	ld (shfuel),a	; ... and put it in the tank
	call signal	; calculate initial signal strength
	ld (psignl),a	; store in the "previous signal" variable

	; now randomise the number generator
	ld hl,($5c78)	; get random number from timer
	ld (randsd),hl	; save as next seed

	; all done
	pop hl		; restore the register values
	pop de		;
	pop bc		;
	ret		; done

	;
	; Subroutines
	;

	; generate code if level not 0
	; inputs:
	;   HL = level number
	; outputs:
	;   A = level code
	;   (lvcode) = level code
.gncode	push de		; store DE before we corrupt it
	push hl		; create a number $0000..$ffff from level number ...
	pop de		;
	add hl,hl	;
	add hl,hl	;
	add hl,hl	;
	add hl,hl	;
	add hl,de	;
	ld (randsd),hl	; ... to use level number as random seed
	ex de,hl	; retrieve the level number
	ld a,h		; check if HL is 0
	or l		;
	jr z,svcode	; if it is, skip code calculation
	call rand16	; generate a random code
	ld a,(randsd)	; take LSB ...
	ld d,a		; ... as divisor
	ld e,100	; take 100 as dividend
	call div8	; do the division, remainder in D
	ld a,e		; take the remainder
.svcode	ld (lvcode),a	; store the level code for later reference
	pop de		; restore DE
	ret		; return to calling process

	; generate map features
	; inputs:
	;   B = number of features to generate
	;   C = type of feature to generate
.featur	push de		; preserve registers like a good boy
	push hl		;
.featlp	call findmt	; find an empty map square
	ld (hl),c	; otherwise put map feature into square
	djnz featlp	; on to the next feature until done
	pop hl		; restore registers
	pop de		;
	ret		; all done

	; determine number of "difficult" map features for this level
	; outputs:
	;   B = number of features
.diffic	push de		; preserve the registers like a good boy
	push hl		;
	ld hl,(mssion)	; what is the mission number?
	ld de,48	; we add an extra feature every 48 levels
	call div16	; (D)E now contains the quotient, 0..20
	ld a,10		; difficult features start at 10 on level 0
	add a,e		; add the number of extra features
	ld b,a		; put into B ready for use
	pop hl		; restore the register values
	pop de		;
	ret		; all done

	; find a random location that is currently empty
	; outputs:
	;   (D)E = map square location 0..99
	;   HL = map square address in memory
.findmt	call rand16	; generate a random number
	ld hl,(randsd)	; look at it
	ld de,100	; we want it to be 0 to 99
	call div16	; HL holds the remainder, a random map square
	ex de,hl	; now DE is map square
	ld hl,mapdat	; point HL at start of map
	add hl,de	; advance HL to the desired map location
	ld a,(hl)	; what is there?
	or a		; is it clear?
	jr nz,findmt	; square occupied, so we need to look elsewhere
	ret

	;
	; Messages and other data
	;

	; messages
.plwait	defm "     GENERATING MAP     "