	;
	; Intergalactic Space Rescue - a puzzle game for the 16K ZX Spectrum
	; Assembler code for the main game loop and menu
	;
	; Copyright (C) Damian Walker 2012
	; Created 14-Dec-2012
	;

	;
	; Initialisation for game and for levels
	;

	; create a new game
.newgam	ld hl,$00	; current level number should be 0
	ld (mssion),hl	; initialise it

	; create a new level
.newlvl	call lvlgen	; generate level
	call dr_map	; draw the map
	call drstat	; display fuel, beacon and location
	call mssprt	; display mission information

	;
	; Main control routine
	;

	; display status and wait for player to do something
.maingm	call drstat	; display fuel, beacon and location
	call ctlrel	; ensure no controls are pressed
	call ctlact	; wait for a control to be pressed

	; act upon player's control selection
	bit 4,a		; is fire pressed?
	jp nz,menu	; yes, bring up the menu
	ld a,(rescxy)	; otherwise look at ship location
	ld d,a		; transfer it to D
	ld e,$0a	; take the map width
	call div8	; now D=Y and E=X

	; check we're not moving off the map
	ld hl,movtbl	; refer to the movement table
	ld a,(ctlopt)	; recall controls
	bit 0,a		; are we moving right?
	jr z,movecl	; no, check left
	ld a,9		; look at the right-hand edge
	cp e		; is that where we are?
	jr z,maingm	; yes, so don't move further
	jr movesh	; otherwise move ship
.movecl	bit 1,a		; are we moving left?
	jr z,movecd	; no, check down instead
	ld a,e		; are we at the left edge?
	or a		;
	jr z,maingm	; yes, so don't move further
	jr movelt	; otherwise move ship
.movecd	bit 2,a		; are we moving down?
	jr z,movecu	; no, check up instead
	ld a,9		; look at bottom edge
	cp d		; is that where we are?
	jr z,maingm	; yes, so don't move further
	jr movedn	; otherwise move ship
.movecu	ld a,d		; are we at the upper edge?
	or a		;
	jr z,maingm	; yes, so don't move further

	; point HL to row of movement table for direction pressed
.moveup	inc hl		; advance down the table thrice for up ...
.movedn	inc hl		; ... twice for down ...
.movelt	inc hl		; ... just once for left

	; check that we can and should move the rescue ship now
.movesh	ld a,(shfuel)	; how much fuel to we have?
	or a		; is there any left?
	jr z,maingm	; no, so we can't move anyway
	ld a,(rescxy)	; recall ship position
	ld c,a		; set aside for a moment
	ld a,(beacxy)	; check beacon position
	cp c		; have we found the beacon?
	jr z,maingm	; yes, so there is no need to move

	; store the current signal strength
	call signal	; calculate the current signal
	ld (psignl),a	; store it in the "previous signal" variable

	; move the ship according to table entry HL
	ld a,c		; recall rescue ship position
	call drtile	; draw map contents at ship position
	ld a,(hl)	; get facing offset
	ld (rescdr),a	; store for drawing later
	add a,c		; add the cursor location to the facing offset
	call shipck	; check for effects on the ship
	jr maingm	; back to the game loop

	; movement table
.movtbl	defb $01 ; movement right
	defb $ff ; movement left
	defb $0a ; movement down
	defb $f6 ; movement up

	;
	; The menu system
	;

	; entry point for the menu routine - decide default option
.menu	ld a,(rescxy)	; check rescue ship location
	ld c,a		; put aside for a moment
	ld a,(beacxy)	; check beacon location
	cp c		; are the two locations the same?
	jr z,mnextm	; yes, so on to next mission
	ld a,(shfuel)	; what fuel have we?
	or a		; have we any?
	jr z,mstart	; no, so "restart mission"
	xor a		; make default option "cancel"
	jr menurp	; on to process the menu
	; player is out of fuel - "restart mission" default option
.mstart	ld a,$02	; make default option "restart mission"
	jr menurp	; on to process the menu
	; player has found the beacon - "new game" or "next mission"
.mnextm	ld hl,(mssion)	; what is our current mission?
	ld bc,999	; 999 is the last mission
	sbc hl,bc	; is 999 our mission?
	jr z,mnewgm	; yes, so "new game" - there is no next mission
	ld a,$03	; make default option "next mission"
	jr menurp	; on to process the menu
.mnewgm	ld a,$05	; make default option "new game"

	; menu loop - print the currently selected menu option
.menurp	ld (menopt),a	; store accumulator as last used option
	;ld a,(menopt)	; load last used menu option
	ccf		; clear the carry flag prior to rotation
	rlca		; convert to an offset
	rlca		;
	rlca		;
	ld e,a		;
	rlca		;
	add a,e		;
	ld e,a		;
	ld d,0		;
	ld hl,mentxt	; point to menu text table
	add hl,de	; point down to specific option's text
	call msgprt	; print the option text

	; wait for new LEFT/RIGHT activation or FIRE release
.menctl	call ctlpol	; poll the control device
	and $0f		; just look at the directional bits
	jr nz,menctl	; repeat until all direction controls released
.menupl	call ctlpol	; poll the control device
	bit 4,a		; has the fire button been released?
	jr z,menrel	; yes, process menu option
	and $03		; otherwise we're interested only in left/right
	jr z,menupl	; if neither is pressed, repeat

	; process LEFT/RIGHT control to cycle through menu options
	bit 1,a		; is left control activated?
	jr z,menrgt	; no, so we're moving right
	ld a,$ff	; otherwise we're moving left
.menrgt	ld b,a		; store offset
	ld a,(menopt)	; look at last-chosen menu option
	add a,b		; add the offset
	cp $ff		; have we passed the first option?
	jr z,menust	; handle passing the first option elsewhere
	cp $06		; have we passed the last option?
	jr c,menurp	; no, so show new option
	xor a		; otherwise set to first option again ...
	jr menurp	; and show it

	; we've moved left past the first option - cycle to the last
.menust	ld a,$05	; select last option on the menu
	jr menurp	; repeat menu

	; FIRE button released - act on this menu option
.menrel	ld a,(menopt)	; retrieve menu option
	sla a		; convert it to an offset
	ld e,a		;
	ld d,0		;
	ld hl,menjmp	; point to the jump table
	add hl,de	; point to the specific option's entry
	ld e,(hl)	; load entry into DE
	inc hl		;
	ld d,(hl)	;
	ex de,hl	; swap entry into HL ...
	jp (hl)		; ... and jump there

	; table of menu option text
.mentxt	defm "   CANCEL MENU OPTION   "
	defm "SHOW MISSION INFORMATION"
	defm "  RESTART THIS MISSION  "
	defm "   ON TO NEXT MISSION   "
	defm "    CHOOSE A MISSION    "
	defm "     BEGIN NEW GAME     "

	; table of jump locations for menu options
.menjmp	defw maingm	; cancel menu
	defw msinfo	; show mission information
	defw startm	; restart mission, after confirmation
	defw nextmn	; start next mission, after confirmation
	defw chsemn	; choose a mission
	defw ngconf	; new game, after confirmation
