	;
	; Intergalactic Space Rescue - a puzzle game for the 16K ZX Spectrum
	; Assembler code for animation effects
	;
	; Copyright (C) Damian Walker 2013
	; Created 07-Jan-2013
	;

	;
	; Generic flashing animation routine
	;

	; simple flash animation alternating between ship and map feature
	; inputs:
	;   HL = address of delay/sound routine to use
.flanim	push bc		; store entry values of registers
	ld b,2		; initialise the flash counter
.flloop	call drship	; draw the ship
	call flwait	; wait for 1/4 second with appropriate noise
	ld a,(rescxy)	; point to ship location
	call drtile	; draw the tile behind the ship
	call flwait	; wait for 1/4 second with appropriate noise
	djnz flloop	; repeat animation until done
	pop bc		; retrieve values of registers
	pop hl		; (HL was pushed by calling process)
	ret		; all done

	; dummy subroutine, transfer straight to (HL)
.flwait	jp (hl)		; code at destination will have a RET at the end

	;
	; Deep Space Animations
	;

	; main animation routine
.d_anim	push hl		; store HL before overwriting
	ld hl,d_wait	; assign silent wait routine
	jp flanim	; standard flash animation

	; delay routine for deep space (i.e. silence)
.d_wait	push bc		; store values of registers before overwriting
	ld b,$0c	; approximate 1/4 second, or 1/5 for 60Hz systems
.d_wtlp	halt		; wait for next interrupt
	djnz d_wtlp	; count down until delay done
	pop bc		; retrieve overwritten values
	ret		; return to calling routine

	; animation routine on successful mission
.s_anim	push hl		; store HL before overwriting
	ld hl,$800c	; low-pitched beep
	ld (s_wksp),hl	; store this
	ld hl,s_wait	; assign success noise wait routine
	jp flanim	; standard flash animation

	; delay routine for successful mission
.s_wait	push bc		; store values of registers before overwriting
	push hl		;
	ld b,$0c	; approximate 1/4 second, or 1/5 for 60Hz systems
	ld hl,(s_wksp)	; load pitch
.s_wtlp	halt		; wait for next interrupt
	call tone	; make a noise
	dec h		; raise the tone
	djnz s_wtlp	; count down until delay done
	ld (s_wksp),hl	; store this
	pop hl		; retrieve register values
	pop bc		;
	ret		; return to calling routine
	; workspace
.s_wksp	defs 2		; pitch and length of beep

	; animation routine on failed mission
.f_anim	push hl		; store HL before overwriting
	ld hl,$c00c	; high-pitched beep
	ld (f_wksp),hl	; store this
	ld hl,f_wait	; assign success noise wait routine
	jp flanim	; standard flash animation

	; delay routine for failed mission
.f_wait	push bc		; store values of registers before overwriting
	push hl		;
	ld b,$0c	; approximate 1/4 second, or 1/5 for 60Hz systems
	ld hl,(f_wksp)	; load pitch
.f_wtlp	halt		; wait for next interrupt
	call tone	; make a noise
	inc h		; lower the tone (!)
	djnz f_wtlp	; count down until delay done
	ld (f_wksp),hl	; store this
	pop hl		; retrieve register values
	pop bc		;
	ret		; return to calling routine
	; workspace
.f_wksp	defs 2		; pitch and length of beep

	;
	; Planet animation
	;

	; planet animation routine
.p_anim	push hl		; store HL before overwriting
	ld hl,p_wait	; use planet sound/wait routine
	jp flanim	; on to standard flash animation

	; delay with noise for planet animation
.p_wait	push bc		; store values of registers before overwriting
	push hl		;
	ld b,$0c	; approximate 1/4 second, or 1/5 for 60Hz systems
	ld hl,$ff08	; low-pitched rumbling noise
	call tone	; make a noise
.p_wtlp	halt		; wait for next interrupt
	djnz p_wtlp	; count down until delay done
	pop hl		; retrieve register values
	pop bc		;
	ret		; return to calling routine

	;
	; Asteroid animation
	;

	; main animation routine
.a_anim	push hl		; store HL before overwriting
	ld hl,a_wait	; use asteroid sound/wait routine
	jp flanim	; on to standard flash animation

	; delay routine with noise for asteroid animation
.a_wait	push bc		; store values of registers before overwriting
	push hl		;
	ld b,$0c	; approximate 1/4 second, or 1/5 for 60Hz systems
	ld hl,$ff08	; low-pitched rumbling noise
.a_wtlp	halt		; wait for next interrupt
	bit 2,b		; should we have silence?
	jr nz,a_slnt	; yes
	call noise	; make a noise
.a_slnt	djnz a_wtlp	; count down until delay done
	pop hl		; retrieve register values
	pop bc		;
	ret		; return to calling routine

	;
	; Hyperspace animations
	;

	; initial spinning animation
.h1anim	push bc		; store registers about to be corrupted
	push de		;
	push hl		;
	ld d,0		; zero upper half of offset
	ld b,8		; we rotate the ship 8 times
	ld a,(rescdr)	; what direction are we facing?
	rrca		; change bits 0/1 to a value 0..3 to correspond ...
	rrca		; ... with sprite numbers right,up,down,left
	ld hl,$0108	; point HL to start of noise generator data
.h1loop	ld e,a		; cycle through values 00->10->11->01->00 ...
	rr e		; ... or right->down->left->up->right
	rla		;
	rr e		;
	rla		;
	xor $02		;
	and $03		;
	ld c,a		; preserve temporary direction
	call drrotn	; show the ship rotated
	ld a,c		; restore temporary direction
	ld c,b		; save rotation counter for a moment
	ld b,6 		; delay approximately 1/8 second, 6 frames
.h1wait	halt		; wait for interrupt
	call noise	; make a noise
	inc h		; lower the pitch
	inc h		;
	inc h		;
	inc h		;
	djnz h1wait	; continue waiting until delay done
	ld b,c		; retrieve rotation counter
	djnz h1loop	; continue rotating until done
	pop hl		; retrieve corrupted registers
	pop de		;
	pop bc		;
	ret		; all done

	; secondary animation after movement
.h2anim	push hl		; store HL before overwriting
	ld hl,h2wait	; use hyperspace sound/wait routine
	jp flanim	; on to standard flash animation

	; draw rotated rescue ship
.drrotn	push de		; store on the stack the same registers ...
	push hl		; ... as does DRTILE below
	push af		; store temporary rotated ship tile number
	ld a,(rescxy)	; where is the ship?
	ld e,a		; store this location for later use
	ld d,0		; zero upper half of location word
	pop af		; recall rotated ship tile number
	jp drskip	; from now on act as DRTILE

	; delay and noise for secondary hyperspace animation
.h2wait	push bc		; store values of registers before overwriting
	ld b,$0c	; approximate 1/4 second, or 1/5 for 60Hz systems
.h2wtlp	halt		; wait for next interrupt
	djnz h2wtlp	; count down until delay done
	pop bc		; retrieve overwritten values
	ret		; return to calling routine
