	;
	; Intergalactic Space Rescue - a puzzle game for the 16K ZX Spectrum
	; Assembler code for drawing screen elements
	;
	; Copyright (C) Damian Walker 2012
	; Created 15-Dec-2012
	;

	;
	; Ship drawing routines
	;

	;
	; Map drawing routines
	;

	; draw the whole map
.dr_map	di		; disable interrupts for fast drawing
	push bc		; remember value of BC on entry
	ld b,100	; there are 100 locations ...
.drloop	ld a,100	; calculate location
	sub b		;
	call drtile	; draw graphic tile at this location
	djnz drloop	; on to draw next location till done
	call drship	; draw the rescue ship
	pop bc		; recall value of BC on entry
	ei		; enable interrupts again
	ret		; finished drawing

	; draw correct map graphic at location A
	; inputs:
	;   A = location to draw
.drtile	push de		; store entry values of registers
	push hl		;
	ld e,a		; convert location into 16-bit offset
	xor a		; 
	ld d,a		; 
	ld hl,mapdat	; point HL at the map
	add hl,de	; add offset
	ld a,(hl)	; what's on the map?
	bit 7,a		; has it been seen?
	jr z,drblnk	; no, so it's blank
	add a,$04	; map features are 4..7
	and $7f		; reset the top bit
	jr drskip	; skip the code for blanking out the square
.drblnk	ld a,$09	; select the blank sprite
.drskip	ld (wktile),a	; temporarily store sprite number
	ld a,e		; recall map location
	push de		; store it on the stack - we need it twice
	call fupper	; get memory location for upper half of sprite
	ld a,(wktile)	; recall sprite number ...
	call drhalf	; ... and draw the top half
	pop de		; what was the location again?
	ld a,e		; transfer to A
	call flower	; get memory location for lower half of sprite
	ld a,(wktile)	; recall sprite number again
	or $80		; set to bit to signify we want to ...
	call drhalf	; ... draw the lower half
	pop hl		; retrieve entry values of registers
	pop de		;
	ret		; done with dawing tile
	; workspace
.wktile	defs 1		; workspace for map tile

	; draw rescue ship graphic at appropriate location
.drship	push de		; store on the stack the same registers ...
	push hl		; ... as does DRTILE below
	ld a,(rescxy)	; where is the ship?
	ld e,a		; store this location for later use
	ld d,0		; zero upper half of location word
	ld hl,beacxy	; point at the beacon location
	cp (hl)		; are they at the same place?
	jr z,drbeac	; yes, so we're drawing a ship/beacon
	ld a,(rescdr)	; otherwise see which way we're facing
	rrca		; change this to a value 0..3 to correspond ...
	rrca		; ... with sprite numbers right,up,down,left
	and $03		;
	jr drskip	; from now on act as DRTILE
.drbeac	ld a,$08	; this is the sprite for two ships together
	jr drskip	; from now on act as DRTILE

	; find screen address for a given map location
	; inputs:
	;   A = map location
	; outputs:
	;   DE = screen memory location
	; entry points:
	;   FUPPER = entry to find upper half of location
	;   FLOWER = entry to find lower half of location
.fupper	push hl		; store entry value of HL
	ld hl,upptbl	; point HL to table of upper row locations
	jr fdhalf	; the rest of the location is common to maplwr
	; entry point for lower half of map sqaure
.flower	push hl		; store hl
	ld hl,lowtbl	; point HL to table of lower row locations
.fdhalf	push bc		; store entry value of BC
	ld d,a		; transfer map location
	ld e,10		; to be divided by row width
	call div8	; now D=row, E=column
	push de		; store for later retrieval
	ld e,d		; turn row into an offset (in words)
	ld d,0		;
	add hl,de	; apply offset to point at correct table ...
	add hl,de	; ... entry for map row
	ld e,(hl)	; load screen address for that map row
	inc hl		;
	ld d,(hl)	;
	ex de,hl	;
	pop de		; retrieve column number from stack
	ld d,0		;
	add hl,de	; add it to the screen row address
	add hl,de	;
	ex de,hl	; transfer result back into DE
	pop hl		; retrieve original values of registers
	pop bc		;
	ret		; done
	; screen addresses for each map row (upper)
.upptbl	defw $4026,$4066,$40a6,$40e6,$4826,$4866,$48a6,$48e6,$5026,$5066
	; screen addresses for each map row (lower)
.lowtbl	defw $4046,$4086,$40c6,$4806,$4846,$4886,$48c6,$5006,$5046,$5086

	; draw half a map graphic
	; inputs:
	;   A = hsssssss; h=top(0)/bottom(1); s=sprite number
	;   DE = screen address
.drhalf	push bc		; save registers to be overwritten
	push hl		;
	sla a		; shift top bit of A into carry
	rl c		; and store in bottom bit of c
	srl a		; restore A without its top bit
	ld b,a		; store a into counter
	ld hl,mapgfx	; point to start of map sprite graphics
	push de		; remember screen address DE for a moment
	bit 0,c		; which half of the sprite are we printing?
	jr z,findsp	; find the right sprite
	ld de,$0010	; bottom, so skip top half of sprite data ...
	add hl,de	; ... by adding it to HL	
.findsp	ld de,$0024	; set D to length of sprite information (de)
	and b		; is counter 0?
	jr z,sfound	; if so, we're already pointing at the right sprite
.nextsp	add hl,de	; otherwise point to next sprite ...
	djnz nextsp	; ... and check again
	; draw the pixels
.sfound	pop de		; retrieve screen address
	push de		; and store it again as we'll be corrupting it
	ld b,8		; 8 lines for this half of sprite
.pixrow	ldi		; transfer first byte from sprite to screen
	ldi		; transfer second byte from sprite to screen
	inc bc		; we didn't want to decrement BC...
	inc bc		; ... so restore it again
	dec e		; point back to left-hand character ...
	dec e		;
	inc d		; ... then point to next screen row
	djnz pixrow	; and output the next row
	; paint the attributes
	bit 0,c		; if zero, we're drawing the top half of the sprite
	jr nz,drattr	; if non-zero, we're drawing the bottom
	ld de,$000e	; we want to skip 14 bytes first
	add hl,de	;
.drattr	inc hl		; skip two more bytes to reach the correct attr source
	inc hl		;
	pop de		; regain screen location
	srl d		; the following code should convert the pixel ...
	srl d		; ... address in DE to an attribute address
	srl d		;
	ld a,$50	;
	or d		;
	ld d,a		; DE now contains the attribute address
	ldi		; transfer first attribute
	ldi		; transfer second attribute
	pop hl		; restore registers
	pop bc		;
	ret		; done with this half square

	;
	; Status drawing routines
	;

	; draw current map location and statistics
.drstat	push de		; store entry values of registers
	push hl		; 
	; draw the fuel gauge and indicator
	ld hl,$5ac1	; point to fuel indicator attribute
	ld e,$60	; it will be bright green by default
	ld a,(shfuel)	; check current fuel again
	cp 10		; is it half full?
	jr nc,drflin	; no, draw it as is
	ld e,$70	; otherwise turn it yellow
	cp 5		; is it less than a quarter full?
	jr nc,drflin	; no, draw it as is
	ld e,$50	; otherwise turn it red
	cp 2		; is it nearly empty?
	jr nc,drflin	; no, draw it as is
	ld e,$d0	; otherwise flash it red
.drflin	ld (hl),e	; turn the light the desired colour
	ld hl,$5842	; point to fuel gauge area in attributes
	call drgaug	; draw the gauge
	; draw the signal gauge and indicator
	ld e,$e0	; indicator will be flashing green by default
	call signal	; calculate the signal strength
	cp $11		; is rescue ship close to objective?
	jr nc,drsgnl	; yes, draw indicator in this colour
	ld e,$00	; try black instead
	ld hl,psignl	; point to previous signal strength
	cp (hl)		; compare current with previous signal
	jr z,drsgnl	; if equal, leave black
	ld e,$60	; turn indicator steady green
	jr nc,drsgnl	; if closer, leave green
	ld e,$50	; otherwise indicator should be red
.drsgnl	ld hl,$5ade	; point to signal indicator attribute
	ld (hl),e	; turn the light the desired colour
	ld hl,$585c	; point to signal gauge area in attributes
	call drgaug	; draw the gauge
	; check for win or loss
.statvc	ld a,(rescxy)	; where is the rescue ship?
	ld d,a		; remember this location
	ld a,(beacxy)	; where is the beacon?
	cp d		; is it in the same place?
	jr nz,statfl	; no, check for no fuel instead
	ld hl,bcnmsg	; otherwise point to "mission complete" message ...
	jr stamsg	; ... and go on to print it
.statfl	ld a,(shfuel)	; what is our fuel level again?
	or a		; are we out of fuel?
	jr nz,drname	; no, print map feature name instead
	ld hl,nofmsg	; otherwise point to "out of fuel"
	jr stamsg	; go to print message
	; prepare status text with feature name
.drname	ld a,(rescxy)	; where is the ship?
	ld e,a		; convert this to a 16-bit offset
	ld d,0		;
	ld hl,mapdat	; point to the map area
	add hl,de	; advance to the rescue ship's location
	ld a,(hl)	; what is there?
	add a,a		; multiply by 24 and convert to a 16-bit offset
	add a,a		;
	add a,a		;
	ld e,a		;
	add a,a		;
	add a,e		;
	ld e,a		;
	ld hl,ftrnam	; point to feature name table
	add hl,de	; advance to the appropriate feature
	; output the status text
.stamsg	call msgprt	; print its name
	pop hl		; retrieve entry values of registers
	pop de		;
	ret		; all done

	; draw a gauge
	; inputs:
	;   A = value/level of gauge
	;   HL = address of top left attribute of gauge
.drgaug	push bc		; store entry values of registers
	push de		;
	ld de,$1f	; almost the length of one line of attributes
	ld b,$12	; 18 is the maximum gauge value
	ld c,0		; gauge above its level is black
.ggerow	cp b		; is the gauge value this high?
	jr c,ggsame	; no, so we don't change colour yet
	ld c,$06	; otherwise the gauge is yellow from here on
.ggsame	ld (hl),c	; paint the gauge, left character
	inc hl		; advance, to ...
	ld (hl),c	; ... paint the gauge, right character
	add hl,de	; advance to the next attribute line, left character
	djnz ggerow	; paint the next row, if appropriate
	pop de		; restore entry values of registers
	pop bc		;
	ret		; done with this gauge

	;
	; Graphics and text for drawing
	;

	; rescue ship moving right
.mapgfx	defb $00,$00,$7E,$00,$38,$00,$2C,$00,$1E,$00,$5F,$80,$7E,$40,$7E,$20
	defb $5F,$F8,$7F,$F4,$70,$02,$5F,$FC,$1F,$80,$3F,$00,$7F,$80,$00,$00
	defb $47,$47,$47,$47 ; attributes
	; rescue ship moving up
	defb $00,$00,$01,$80,$03,$C0,$02,$40,$06,$60,$04,$20,$0D,$B0,$56,$6A
	defb $75,$AE,$6A,$56,$6A,$56,$7D,$BE,$6E,$76,$42,$42,$01,$80,$00,$00
	defb $47,$47,$47,$47 ; attributes
	; rescue ship moving down
	defb $00,$00,$01,$80,$43,$C2,$6A,$56,$7D,$BE,$6B,$D6,$6F,$F6,$74,$2E
	defb $54,$2A,$0E,$70,$06,$60,$07,$E0,$03,$C0,$03,$C0,$01,$80,$00,$00
	defb $47,$47,$47,$47 ; attributes
	; rescue ship moving left
	defb $00,$00,$00,$7E,$00,$1C,$00,$34,$00,$78,$01,$EA,$02,$6E,$04,$6E
	defb $1F,$EA,$3F,$EE,$7E,$0E,$3F,$FA,$01,$F8,$00,$FC,$01,$FE,$00,$00
	defb $47,$47,$47,$47 ; attributes
	; deep space
	defb $00,$00,$00,$08,$00,$00,$08,$00,$1C,$02,$08,$20,$00,$00,$00,$00
	defb $00,$00,$00,$02,$01,$00,$40,$00,$00,$00,$00,$08,$10,$00,$00,$00
	defb $47,$07,$07,$47 ; attributes
	; planet
	defb $07,$E0,$1E,$F8,$3F,$A8,$7D,$F4,$7F,$5A,$FF,$EA,$EE,$A9,$FF,$EC
	defb $D5,$52,$FF,$DA,$AA,$51,$6B,$54,$5A,$A8,$0A,$A0,$14,$88,$02,$40
	defb $41,$41,$41,$04 ; attributes
	; asteroids
	defb $00,$00,$06,$06,$36,$02,$30,$30,$00,$78,$48,$7A,$62,$30,$00,$00
	defb $00,$00,$62,$60,$70,$64,$30,$00,$06,$06,$06,$0E,$00,$0C,$00,$00
	defb $06,$42,$42,$02 ; attributes
	; hyperspace
	defb $00,$00,$07,$60,$08,$10,$01,$00,$2A,$64,$48,$F2,$52,$F2,$12,$60
	defb $55,$0A,$42,$D2,$48,$02,$24,$20,$13,$88,$00,$10,$07,$60,$00,$00
	defb $03,$43,$03,$03 ; attributes
	; rescue ship and stricken ship together
	defb $00,$00,$1C,$00,$3E,$00,$7F,$00,$7D,$00,$79,$00,$33,$00,$1F,$80
	defb $01,$FC,$60,$BA,$38,$D8,$34,$F8,$3E,$F0,$26,$80,$78,$40,$00,$00
	defb $07,$47,$47,$07 ; attributes
	; blank map graphic (may be replaced with "unexplored" indicator)
	defb $00,$00,$00,$00,$3F,$FC,$20,$04,$2A,$A4,$25,$54,$2a,$a4,$25,$54
	defb $2A,$A4,$25,$54,$2A,$A4,$25,$54,$20,$04,$3F,$FC,$00,$00,$00,$00
	defb $01,$01,$01,$01 ; attributes

	; names of map features
.ftrnam	defm " YOU ARE IN DEEP SPACE  "
	defm "REFUELLED AT THE PLANET "
	defm "NAVIGATED THE ASTEROIDS "
	defm "WENT THROUGH HYPERSPACE "

	; end of mission messages
.nofmsg	defm "  YOU ARE OUT OF FUEL!  "
.bcnmsg	defm "    MISSION COMPLETE    "
