	;
	; Intergalactic Space Rescue - a puzzle game for the 16K ZX Spectrum
	; Assembler code for message printing
	;
	; Created 13-Dec-2012
	;

	;
	; Ooutput message text of fixed length, leaving colour alone
	;

	; notification print - delay after the printing of the message
	;   HL = address of fixed-length message to print
	;   constant MSGPOS = screen address of first character top pixels
	;   constant MSGLEN = length of the message display line
.notprt	push bc		; store the registers this routine overwrites
	call msgprt	; print the message
	ld b,100	; the delay will be 100/50ths second
.notpr0	halt		; wait for interrupt
	djnz notpr0	; continue till 100 interrupts have passed
	pop bc		; retrieve value of BC
	ret		; all done

	; standard message filling entire message display line
	;   HL = address of fixed-length message to print
	;   constant MSGPOS = screen address of first character top pixels
	;   constant MSGLEN = length of the message display line
.msgprt	push bc		; save BC before we overwrite it
	push de		; save DE before we overwrite it
	ld de,msgpos	; screen memory where messages will appear
	ld b,msglen	; length of message display line
	call msgprc	; print these characters
	pop de		; retrieve DE as it was on entry
	pop bc		; retrieve BC as it was on entry
	ret		; all done

	; display a message of specified length at specified location
	;   HL = address of fixed-length message to print
	;   DE = screen address of first character, top pixel line
	;   B  = length of message
.msgprc	ld a,(hl)	; load character into A
	push hl		; store our string address while we borrow HL
	push de		; store screen address temporarily
	sub $20		; subtract value of space from A
	ld l,a		; transfer to HL
	ld h,0		;
	add hl,hl	; turn HL into an offset to CHRSET
	add hl,hl	;
	add hl,hl	;
	ex de,hl	; transfer offset to DE
	ld hl,chrset	; point to character set
	add hl,de	; add the offset
	pop de		; regain our screen address
	ld c,b		; store character count
	ld b,$08	; 8 pixel lines in a character
	push de		; push our screen address again
	; fill a single pixel row at a time
.msgprl	ld a,(hl)	; load character data
	ld (de),a	; save onto screen
	inc d		; point DE to next pixel row on screen
	inc hl		; point HL to next pixel row in character set
	djnz msgprl	; transfer remaining pixel rows
	ld b,c		; restore character count
	pop de		; restore DE to the correct row in screen memory
	inc e		; point DE to next character in screen memory
	pop hl		; retrieve character pointer
	inc hl		; increment it to point to the next character
	djnz msgprc	; print remaining characters
	ret		; all done, return
