	;
	; Intergalactic Space Rescue - a puzzle game for the 16K ZX Spectrum
	; Assembler code for the victory screen
	;
	; Created 08-Jan-2012
	;

	;
	; The victory screen routine
	;

	; draw the victory screen - pixels first
.victry	ld hl,vicscr	; point to victory screen graphics
	ld c,$14	; there are 20 character lines to draw
	ld ix,scrtbl	; point IX to screen address table
.viclin	ld e,(ix+0)	; point DE to the start of the pixel line
	ld d,(ix+1)	;
	ld b,$08	; there are eight pixel lines per character line
.vicrow	push bc		; store pixel row counter
	ld bc,$14	; there are 20 bytes per line
	ldir		; transfer those bytes to the screen
	ld e,(ix+0)	; reset E again
	inc d		; point D to the next line
	pop bc		; retrieve pixel row counter
	djnz vicrow	; continue to transfer pixel rows until done
	inc ix		; point to next screen address
	inc ix		;
	dec c		; decrement the character line counter
	jr nz,viclin	; continue to transfer character rows till done
	; transfer attribute rows
	ld de,$5826	; point to first attribute row
	ld c,$14	; there are 20 rows
.vicatr	push bc
	ld bc,$14	; there are 20 characters per row
	ldir		; transfer the attribute row
	pop bc
	ld a,$0c	; advance attribute pointer by 12
	add a,e		;
	ld e,a		;
	jr nc,vic_nc	;
	inc d		;
.vic_nc	dec c		; count down to next row
	jr nz,vicatr	; continue colouring rows till done
	; wait for FIRE to be pressed
	ld hl,sgcnfm	; point to "FIRE TO RESTART GAME" message
	call msgprt	; print it
	call ctlrel	; wait for all controls to be released
	call ctlfir	; wait for FIRE to be activated
	jp newgam	; new game

	;
	; The Graphics Data
	;

	; screen address tables for character lines
.scrtbl	defw $4026,$4046,$4066,$4086,$40a6,$40c6,$40e6,$4806,$4826,$4846
	defw $4866,$4886,$48a6,$48c6,$48e6,$5006,$5026,$5046,$5066,$5086

	; line based output of pixel data:
.vicscr	defb $00,$00,$00,$14,$00,$08,$00,$00,$00,$04
	defb $15,$00,$23,$00,$00,$00,$00,$00,$00,$00
	defb $20,$00,$00,$16,$80,$10,$00,$00,$00,$02
	defb $0A,$A0,$28,$00,$00,$00,$00,$00,$00,$00
	defb $00,$00,$00,$49,$00,$0C,$00,$00,$20,$08
	defb $29,$00,$05,$80,$00,$00,$00,$00,$00,$00
	defb $00,$04,$00,$A4,$80,$38,$00,$00,$00,$00
	defb $08,$4A,$05,$D0,$00,$10,$00,$04,$00,$20
	defb $00,$00,$02,$B9,$00,$14,$00,$00,$00,$40
	defb $02,$00,$01,$80,$00,$00,$00,$08,$00,$50
	defb $80,$00,$12,$4A,$00,$3C,$00,$00,$00,$34
	defb $00,$AA,$21,$A0,$00,$00,$00,$02,$00,$0A
	defb $00,$00,$0A,$01,$00,$1E,$20,$00,$00,$A4
	defb $0A,$C0,$8B,$00,$00,$00,$00,$09,$01,$55
	defb $80,$00,$45,$00,$00,$5C,$00,$00,$00,$54
	defb $05,$E8,$09,$80,$80,$00,$00,$01,$40,$A2
	defb $00,$00,$2A,$00,$00,$08,$00,$00,$05,$24
	defb $E5,$1D,$B9,$00,$20,$00,$00,$08,$07,$58
	defb $00,$00,$25,$00,$01,$08,$80,$00,$04,$00
	defb $F1,$8F,$A4,$02,$00,$00,$00,$00,$01,$C8
	defb $00,$00,$0A,$00,$37,$18,$A8,$00,$0A,$20
	defb $EA,$2A,$D2,$80,$00,$00,$00,$00,$02,$20
	defb $00,$05,$0B,$05,$DF,$FC,$FC,$00,$01,$10
	defb $58,$4A,$92,$40,$00,$00,$20,$00,$02,$94
	defb $00,$06,$94,$00,$3F,$3F,$FF,$00,$08,$22
	defb $65,$90,$6A,$80,$00,$00,$00,$00,$02,$40
	defb $00,$03,$EE,$25,$0B,$18,$E4,$00,$05,$10
	defb $50,$54,$5D,$40,$00,$00,$00,$00,$00,$22
	defb $08,$05,$5A,$80,$01,$10,$40,$00,$00,$52
	defb $D2,$A8,$2A,$00,$00,$00,$00,$00,$0A,$00
	defb $00,$41,$6D,$70,$00,$10,$00,$00,$02,$2A
	defb $D0,$55,$28,$80,$00,$00,$00,$00,$41,$40
	defb $00,$01,$2A,$10,$00,$3C,$00,$04,$00,$5A
	defb $45,$A8,$90,$00,$00,$00,$00,$00,$00,$00
	defb $01,$20,$04,$90,$00,$78,$00,$00,$00,$4D
	defb $A5,$AC,$54,$00,$00,$00,$00,$00,$00,$A0
	defb $00,$08,$B1,$00,$00,$1C,$00,$00,$00,$2B
	defb $10,$B2,$20,$00,$08,$00,$00,$00,$00,$08
	defb $00,$04,$08,$00,$00,$3C,$00,$00,$00,$25
	defb $9A,$A9,$28,$00,$00,$00,$00,$00,$00,$00
	defb $00,$02,$24,$00,$00,$18,$00,$00,$00,$0A
	defb $24,$A4,$80,$00,$00,$00,$04,$00,$00,$5A
	defb $80,$91,$0A,$80,$00,$30,$00,$00,$04,$02
	defb $AA,$94,$08,$00,$00,$00,$00,$00,$00,$0A
	defb $00,$4A,$55,$00,$00,$08,$00,$20,$00,$4A
	defb $44,$42,$00,$00,$00,$00,$00,$00,$00,$35
	defb $C4,$49,$0A,$80,$00,$10,$00,$00,$00,$05
	defb $53,$94,$00,$00,$00,$00,$00,$00,$40,$0A
	defb $10,$29,$26,$80,$00,$00,$00,$00,$00,$56
	defb $6A,$82,$00,$00,$00,$00,$00,$00,$10,$05
	defb $5C,$04,$32,$00,$00,$00,$00,$00,$00,$0B
	defb $B4,$50,$00,$00,$00,$00,$00,$00,$00,$05
	defb $44,$29,$54,$00,$20,$00,$00,$00,$04,$A7
	defb $D2,$00,$00,$00,$00,$00,$00,$00,$12,$85
	defb $2A,$4A,$50,$00,$00,$00,$00,$00,$04,$9B
	defb $6A,$00,$00,$00,$00,$00,$00,$00,$04,$A5
	defb $AA,$25,$68,$20,$00,$00,$00,$00,$02,$6F
	defb $A0,$00,$00,$20,$00,$00,$00,$00,$0B,$48
	defb $31,$10,$AA,$00,$00,$40,$00,$00,$02,$51
	defb $D4,$00,$00,$00,$00,$00,$20,$00,$06,$6A
	defb $48,$49,$6A,$20,$00,$00,$00,$00,$09,$AA
	defb $20,$00,$00,$00,$00,$00,$00,$00,$15,$91
	defb $60,$24,$B5,$10,$00,$00,$40,$40,$51,$20
	defb $00,$05,$00,$00,$00,$00,$00,$00,$00,$A8
	defb $50,$12,$D4,$40,$00,$00,$00,$02,$00,$00
	defb $00,$04,$00,$00,$00,$00,$00,$00,$03,$A5
	defb $A8,$04,$94,$10,$00,$00,$11,$40,$00,$00
	defb $00,$05,$00,$00,$00,$00,$00,$0A,$40,$50
	defb $40,$00,$68,$A0,$00,$00,$24,$0A,$00,$00
	defb $00,$00,$00,$00,$00,$00,$00,$14,$01,$49
	defb $50,$01,$14,$15,$00,$02,$2A,$C5,$00,$00
	defb $00,$00,$00,$00,$00,$08,$00,$54,$14,$28
	defb $00,$15,$50,$54,$80,$04,$94,$54,$06,$FC
	defb $00,$00,$00,$00,$00,$00,$00,$2B,$49,$08
	defb $00,$16,$4C,$06,$80,$25,$15,$54,$12,$0B
	defb $80,$00,$02,$00,$00,$00,$01,$54,$A4,$54
	defb $00,$AA,$01,$41,$24,$95,$08,$A8,$20,$00
	defb $80,$00,$00,$00,$00,$00,$02,$F5,$5D,$00
	defb $00,$1A,$80,$20,$14,$2D,$84,$A0,$20,$00
	defb $00,$00,$00,$00,$00,$00,$02,$BF,$7F,$50
	defb $2A,$5C,$49,$15,$40,$92,$00,$00,$20,$00
	defb $40,$00,$00,$00,$00,$00,$02,$04,$FE,$40
	defb $25,$4A,$29,$50,$20,$0B,$40,$00,$18,$07
	defb $80,$00,$00,$00,$00,$00,$05,$10,$A8,$D4
	defb $12,$B0,$14,$A8,$02,$04,$00,$10,$05,$50
	defb $00,$00,$00,$00,$00,$01,$2A,$0B,$42,$E2
	defb $00,$AA,$05,$68,$A1,$02,$00,$00,$08,$04
	defb $00,$00,$00,$00,$00,$01,$AA,$04,$20,$E9
	defb $50,$A8,$B3,$B4,$A4,$08,$80,$00,$00,$02
	defb $00,$00,$00,$08,$00,$02,$AA,$56,$01,$C0
	defb $00,$4A,$29,$B6,$55,$02,$40,$00,$08,$02
	defb $00,$00,$00,$00,$00,$01,$51,$15,$88,$F0
	defb $80,$29,$55,$69,$52,$85,$00,$00,$00,$02
	defb $00,$00,$00,$00,$00,$00,$45,$3F,$15,$D8
	defb $40,$49,$09,$50,$55,$A1,$00,$00,$10,$01
	defb $00,$00,$00,$00,$00,$00,$12,$3F,$22,$F8
	defb $80,$00,$14,$48,$49,$44,$00,$00,$00,$01
	defb $00,$00,$00,$00,$00,$01,$AA,$5D,$9A,$05
	defb $40,$00,$91,$24,$09,$11,$00,$00,$10,$01
	defb $00,$00,$00,$00,$00,$00,$81,$2D,$28,$1F
	defb $14,$10,$2C,$92,$10,$24,$40,$00,$00,$03
	defb $00,$00,$00,$00,$00,$0A,$6A,$56,$14,$17
	defb $04,$09,$0A,$92,$00,$09,$00,$00,$10,$00
	defb $80,$10,$00,$01,$00,$12,$10,$55,$16,$15
	defb $58,$12,$AB,$A9,$05,$05,$28,$1C,$00,$01
	defb $80,$00,$00,$02,$20,$0E,$52,$5C,$34,$33
	defb $2C,$10,$AA,$E4,$01,$22,$49,$5F,$C0,$00
	defb $80,$00,$02,$01,$00,$25,$90,$05,$08,$14
	defb $A8,$02,$93,$2A,$00,$09,$7F,$6B,$C0,$01
	defb $40,$00,$00,$00,$20,$56,$44,$54,$24,$0A
	defb $4F,$A0,$41,$52,$00,$18,$FF,$2A,$C0,$00
	defb $C0,$00,$00,$00,$80,$15,$A5,$06,$08,$2A
	defb $D5,$97,$0A,$48,$A0,$06,$7F,$55,$40,$01
	defb $FE,$03,$FF,$00,$00,$2A,$AD,$36,$20,$5A
	defb $D4,$95,$A1,$20,$14,$00,$FE,$02,$A0,$03
	defb $F8,$00,$FF,$00,$40,$14,$AB,$37,$1A,$5A
	defb $D3,$45,$9D,$41,$80,$81,$0E,$00,$40,$0D
	defb $E0,$00,$3F,$00,$05,$56,$07,$79,$24,$2E
	defb $C9,$D1,$AA,$A8,$3E,$00,$03,$00,$20,$2D
	defb $C0,$00,$0F,$00,$00,$A9,$43,$AD,$AA,$6A
	defb $57,$44,$AA,$85,$01,$50,$2C,$00,$00,$6B
	defb $80,$00,$03,$00,$05,$12,$02,$34,$98,$27
	defb $81,$62,$6E,$A0,$02,$42,$00,$80,$00,$AA
	defb $00,$00,$00,$00,$00,$50,$82,$0E,$64,$91
	defb $4B,$28,$2B,$40,$00,$A9,$00,$60,$21,$55
	defb $00,$00,$00,$C0,$00,$88,$05,$41,$B0,$44
	defb $40,$95,$9A,$A0,$00,$91,$54,$10,$02,$AB
	defb $00,$00,$00,$E0,$00,$20,$02,$82,$44,$20
	defb $11,$94,$4C,$40,$00,$0A,$D7,$10,$0C,$A8
	defb $00,$00,$00,$0F,$00,$A0,$01,$FA,$FE,$0A
	defb $48,$9B,$47,$00,$00,$01,$80,$A0,$00,$94
	defb $00,$00,$00,$07,$00,$00,$00,$B9,$6A,$50
	defb $A5,$D4,$A4,$04,$00,$07,$00,$80,$05,$24
	defb $00,$00,$00,$03,$40,$80,$00,$54,$54,$0A
	defb $30,$BA,$25,$05,$00,$01,$C0,$40,$03,$20
	defb $00,$00,$00,$01,$00,$00,$01,$58,$2A,$49
	defb $EA,$54,$80,$02,$50,$00,$A0,$28,$00,$C8
	defb $00,$00,$00,$01,$00,$00,$02,$54,$55,$12
	defb $BA,$D6,$00,$04,$10,$00,$B0,$0A,$40,$18
	defb $00,$00,$00,$00,$00,$00,$01,$5A,$25,$86
	defb $E9,$18,$00,$02,$44,$00,$EA,$00,$00,$00
	defb $80,$00,$00,$00,$00,$00,$05,$54,$99,$AB
	defb $7C,$CE,$80,$00,$14,$00,$FF,$01,$F8,$08
	defb $80,$00,$00,$00,$00,$00,$00,$94,$54,$2D
	defb $04,$B1,$20,$00,$7A,$02,$55,$06,$A8,$00
	defb $1F,$FF,$FF,$FF,$00,$00,$10,$20,$16,$05
	defb $42,$94,$80,$00,$12,$E0,$AA,$86,$68,$08
	defb $07,$FF,$FF,$FE,$00,$00,$04,$01,$16,$00
	defb $15,$50,$00,$00,$09,$02,$55,$4A,$A8,$01
	defb $00,$7F,$FF,$F8,$40,$00,$12,$82,$4C,$12
	defb $0A,$4A,$80,$00,$01,$41,$29,$22,$A8,$08
	defb $10,$00,$0F,$C0,$20,$00,$00,$90,$2A,$10
	defb $09,$20,$00,$10,$02,$00,$8A,$0A,$A8,$00
	defb $00,$80,$00,$00,$60,$00,$05,$04,$1A,$00
	defb $04,$14,$84,$04,$00,$80,$05,$20,$28,$00
	defb $00,$07,$00,$00,$C0,$10,$00,$02,$AD,$00
	defb $00,$90,$10,$00,$00,$0A,$05,$00,$90,$08
	defb $00,$00,$00,$F8,$00,$00,$00,$00,$96,$00
	defb $80,$10,$08,$01,$00,$05,$02,$30,$14,$00
	defb $00,$00,$00,$00,$00,$00,$00,$04,$96,$00
	defb $00,$00,$00,$00,$00,$00,$FE,$0F,$02,$08
	defb $00,$00,$00,$FF,$9F,$00,$21,$AD,$4A,$40
	defb $40,$00,$00,$00,$00,$00,$F0,$07,$00,$00
	defb $00,$00,$00,$F0,$07,$00,$10,$A3,$89,$64
	defb $80,$00,$00,$00,$00,$00,$80,$33,$00,$08
	defb $00,$00,$01,$00,$11,$00,$0A,$49,$55,$00
	defb $A0,$20,$00,$00,$00,$03,$00,$81,$00,$00
	defb $00,$00,$1F,$00,$04,$80,$04,$44,$55,$64
	defb $40,$00,$00,$00,$00,$1F,$00,$00,$80,$08
	defb $00,$01,$EA,$00,$07,$E0,$02,$52,$A9,$01
	defb $50,$00,$00,$00,$00,$FF,$08,$20,$C0,$00
	defb $00,$0D,$36,$50,$18,$F8,$02,$16,$55,$51
	defb $40,$00,$04,$00,$07,$FF,$20,$08,$E0,$08
	defb $01,$52,$DB,$88,$60,$DC,$09,$AB,$A0,$05
	defb $40,$00,$00,$00,$3F,$FF,$00,$02,$F8,$00
	defb $12,$55,$55,$4A,$40,$F7,$01,$AB,$91,$41
	defb $00,$00,$00,$FE,$00,$00,$00,$00,$FE,$08
	defb $01,$2A,$AA,$AE,$80,$04,$7F,$00,$20,$04
	defb $00,$00,$00,$F0,$00,$10,$00,$00,$BF,$00
	defb $00,$82,$AA,$AA,$50,$01,$1F,$00,$80,$00
	defb $00,$00,$00,$80,$02,$80,$00,$00,$E8,$06
	defb $00,$29,$55,$55,$88,$00,$9F,$00,$80,$20
	defb $00,$00,$03,$00,$02,$00,$00,$00,$80,$00
	defb $80,$00,$15,$55,$A5,$00,$07,$00,$40,$09
	defb $00,$00,$1F,$00,$08,$40,$00,$07,$0A,$00
	defb $20,$01,$4A,$A9,$90,$80,$13,$00,$40,$10
	defb $20,$00,$BF,$00,$20,$20,$00,$7F,$50,$00
	defb $08,$00,$20,$A9,$AA,$50,$08,$00,$41,$04
	defb $00,$01,$DF,$01,$80,$00,$07,$FA,$00,$00
	defb $03,$00,$0A,$45,$AA,$88,$04,$00,$00,$A0
	defb $00,$01,$FF,$04,$00,$04,$7F,$AF,$00,$00
	defb $00,$40,$00,$25,$AA,$A5,$02,$C0,$40,$68
	defb $04,$02,$00,$10,$FF,$F8,$05,$00,$00,$10
	defb $00,$18,$00,$49,$55,$57,$80,$A0,$41,$10
	defb $00,$01,$80,$40,$FF,$80,$50,$00,$00,$04
	defb $00,$02,$00,$04,$55,$55,$50,$F0,$80,$AA
	defb $00,$01,$A2,$00,$F8,$05,$00,$00,$00,$02
	defb $00,$00,$C0,$21,$15,$55,$88,$A0,$48,$10
	defb $00,$02,$40,$00,$80,$50,$00,$20,$00,$00
	defb $80,$00,$18,$00,$41,$55,$A5,$D8,$24,$08
	defb $00,$02,$A1,$07,$05,$00,$00,$00,$00,$00
	defb $20,$00,$03,$20,$0A,$55,$A8,$68,$01,$50
	defb $08,$01,$D0,$7F,$50,$00,$00,$00,$08,$00
	defb $08,$00,$00,$40,$01,$15,$AA,$B4,$00,$20
	defb $00,$01,$C8,$7A,$00,$00,$00,$00,$00,$00
	defb $02,$00,$00,$00,$00,$22,$55,$D4,$01,$48
	defb $00,$00,$68,$6F,$00,$00,$00,$00,$00,$00
	defb $01,$00,$00,$00,$00,$08,$AA,$5A,$04,$A4
	defb $00,$00,$8B,$E0,$00,$A1,$00,$00,$00,$00
	defb $00,$50,$00,$00,$00,$00,$95,$54,$02,$88
	defb $00,$00,$45,$C0,$00,$18,$00,$00,$00,$00
	defb $00,$04,$00,$00,$00,$00,$01,$54,$89,$6A
	defb $00,$00,$23,$E0,$00,$4A,$20,$00,$00,$00
	defb $04,$0A,$80,$00,$00,$00,$02,$29,$A4,$80
	defb $00,$00,$10,$60,$00,$05,$00,$00,$00,$00
	defb $02,$01,$20,$00,$00,$00,$00,$00,$A4,$34
	defb $80,$08,$08,$C0,$00,$12,$00,$00,$00,$00
	defb $04,$04,$14,$00,$00,$00,$00,$01,$92,$24
	defb $00,$00,$06,$10,$00,$00,$80,$00,$00,$00
	defb $00,$02,$82,$80,$00,$00,$00,$00,$A5,$0A
	defb $80,$00,$01,$E0,$00,$00,$20,$00,$00,$00
	defb $00,$00,$00,$50,$00,$00,$00,$02,$D5,$52
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $00,$02,$00,$2A,$00,$00,$00,$04,$DA,$89
	defb $40,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $00,$28,$00,$8A,$A8,$00,$00,$10,$AA,$52
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $01,$04,$00,$00,$AD,$40,$01,$48,$C9,$49
	defb $80,$00,$00,$00,$00,$00,$00,$02,$00,$00
	defb $00,$30,$01,$15,$52,$15,$54,$5F,$04,$92
	defb $00,$00,$00,$00,$16,$00,$00,$00,$00,$00
	defb $00,$8A,$00,$04,$54,$00,$02,$15,$52,$02
	defb $80,$00,$00,$00,$08,$00,$00,$00,$00,$00
	defb $00,$50,$00,$25,$55,$00,$08,$5E,$A8,$02
	defb $00,$00,$00,$00,$0A,$00,$00,$00,$00,$08
	defb $00,$08,$00,$11,$2A,$00,$0A,$17,$00,$01
	defb $00,$20,$00,$00,$20,$00,$00,$20,$00,$00
	defb $20,$20,$01,$54,$AA,$00,$51,$05,$00,$0A
	defb $00,$00,$00,$00,$20,$80,$00,$00,$00,$00
	defb $10,$00,$01,$54,$82,$80,$44,$DE,$A0,$09
	defb $00,$00,$20,$00,$02,$00,$00,$00,$00,$00
	defb $40,$02,$04,$95,$50,$02,$AA,$B5,$20,$54
	defb $00,$00,$10,$00,$22,$C0,$00,$00,$00,$00
	defb $20,$01,$A0,$94,$40,$28,$4A,$FD,$A4,$22
	defb $00,$00,$00,$01,$0A,$80,$00,$00,$00,$00
	defb $00,$05,$00,$4A,$95,$15,$2F,$2E,$41,$14
	defb $00,$00,$80,$08,$41,$40,$00,$00,$00,$00
	defb $00,$00,$00,$22,$40,$89,$04,$B5,$A0,$80
	defb $00,$00,$00,$05,$54,$00,$00,$00,$00,$01
	defb $10,$00,$20,$15,$20,$24,$B5,$12,$00,$00
	defb $88,$00,$40,$12,$52,$00,$00,$00,$04,$00
	defb $00,$00,$08,$50,$80,$04,$94,$A8,$00,$00
	defb $00,$00,$14,$00,$A0,$00,$00,$00,$00,$00
	defb $00,$20,$40,$55,$00,$12,$A5,$10,$00,$00
	defb $80,$00,$02,$00,$28,$00,$00,$00,$00,$00
	defb $00,$28,$08,$28,$84,$15,$2A,$80,$01,$02
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $3C,$78,$91,$E3,$C7,$8F,$12,$20,$78,$F3
	defb $CF,$12,$3C,$00,$F1,$E3,$C7,$89,$1E,$00
	defb $66,$CD,$DB,$36,$6C,$DF,$B3,$60,$CD,$FB
	defb $D9,$BB,$60,$01,$9B,$16,$0C,$D9,$B1,$00
	defb $60,$CD,$FB,$06,$6C,$C6,$33,$60,$CC,$61
	defb $99,$BF,$3C,$01,$9B,$C3,$CC,$19,$BC,$00
	defb $60,$CD,$BB,$67,$CF,$C6,$33,$60,$FC,$61
	defb $99,$B7,$06,$01,$F3,$00,$6C,$19,$B0,$00
	defb $66,$CD,$9B,$36,$CC,$C6,$33,$7E,$CC,$63
	defb $D9,$B3,$66,$C1,$B3,$16,$6C,$D9,$B1,$00
	defb $3C,$78,$91,$E2,$6C,$C6,$1E,$3C,$CC,$63
	defb $CF,$12,$3C,$80,$99,$E3,$C7,$8F,$1E,$00
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $3C,$F2,$07,$8F,$00,$24,$78,$90,$12,$3C
	defb $48,$F0,$1E,$3C,$84,$F1,$03,$C7,$8F,$1C
	defb $66,$F6,$0C,$DF,$80,$66,$CD,$98,$33,$66
	defb $CD,$88,$33,$66,$CD,$9B,$06,$2F,$D8,$B6
	defb $66,$66,$0C,$C6,$00,$7E,$CD,$98,$3F,$66
	defb $CD,$E0,$30,$66,$FD,$9B,$07,$83,$1E,$33
	defb $7C,$66,$0C,$C6,$00,$3C,$CD,$98,$33,$7E
	defb $CD,$80,$30,$66,$FD,$F3,$06,$03,$18,$33
	defb $60,$F7,$EC,$C6,$30,$18,$CD,$98,$33,$66
	defb $79,$88,$33,$66,$CD,$83,$F6,$23,$18,$B6
	defb $20,$F3,$C7,$86,$30,$18,$78,$F0,$12,$66
	defb $30,$F0,$1E,$3C,$48,$81,$E3,$C3,$0F,$1C
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $3C,$48,$F0,$12,$3C,$78,$E1,$E3,$C7,$81
	defb $0B,$CF,$1E,$79,$E2,$47,$80,$1E,$24,$70
	defb $7E,$CD,$88,$33,$66,$CD,$B3,$16,$0F,$C1
	defb $9B,$D8,$30,$7B,$37,$6C,$00,$33,$76,$D8
	defb $18,$FD,$E0,$3F,$66,$CD,$9B,$C3,$C3,$01
	defb $F9,$8F,$1E,$33,$37,$E7,$80,$33,$7E,$CC
	defb $18,$CD,$80,$33,$7E,$F9,$9B,$00,$63,$01
	defb $F9,$81,$83,$33,$36,$E0,$C0,$3F,$6E,$CC
	defb $18,$CD,$88,$33,$66,$D9,$B3,$16,$63,$01
	defb $9B,$D9,$B3,$7B,$36,$6C,$D8,$33,$66,$D8
	defb $18,$48,$F0,$12,$66,$4C,$E1,$E3,$C3,$00
	defb $93,$CF,$1E,$79,$E2,$47,$90,$33,$24,$70
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $3C,$78,$F1,$23,$C7,$00,$91,$E2,$47,$80
	defb $F1,$E3,$CF,$3C,$79,$09,$E2,$47,$80,$00
	defb $62,$CD,$9B,$B6,$2D,$81,$9B,$36,$6C,$C1
	defb $9B,$17,$EF,$66,$C5,$9B,$17,$6F,$C0,$00
	defb $78,$CD,$9B,$F7,$8C,$C1,$FB,$36,$6C,$C1
	defb $9B,$C1,$86,$66,$F1,$FB,$C7,$E3,$00,$00
	defb $60,$FD,$F3,$76,$0C,$C0,$F3,$36,$6F,$81
	defb $F3,$01,$86,$7C,$C1,$FB,$06,$E3,$00,$00
	defb $62,$CD,$B3,$36,$2D,$80,$63,$36,$6D,$81
	defb $B3,$11,$8F,$6C,$C5,$9B,$16,$63,$18,$00
	defb $3C,$CC,$99,$23,$C7,$00,$61,$E3,$C4,$C0
	defb $99,$E1,$8F,$26,$78,$91,$E2,$43,$18,$00
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	defb $00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	; line based output of attribute data:
	defb $01,$47,$01,$01,$01,$42,$07,$00,$45,$01
	defb $01,$08,$08,$01,$01,$45,$00,$01,$01,$01
	defb $44,$01,$01,$01,$42,$57,$42,$00,$01,$01
	defb $08,$01,$01,$01,$01,$00,$07,$01,$01,$01
	defb $01,$01,$01,$01,$00,$42,$00,$47,$01,$01
	defb $08,$01,$01,$00,$47,$00,$07,$00,$03,$01
	defb $01,$01,$01,$01,$47,$44,$01,$01,$01,$01
	defb $01,$01,$00,$47,$00,$00,$42,$00,$03,$01
	defb $01,$01,$01,$01,$01,$01,$01,$01,$05,$05
	defb $05,$01,$07,$00,$00,$47,$03,$03,$03,$01
	defb $01,$01,$01,$01,$01,$01,$01,$43,$05,$05
	defb $05,$00,$00,$47,$00,$03,$03,$19,$0B,$01
	defb $01,$01,$01,$01,$46,$46,$46,$05,$05,$05
	defb $05,$47,$07,$01,$03,$03,$18,$19,$0B,$08
	defb $08,$08,$01,$01,$46,$46,$46,$05,$05,$05
	defb $0D,$08,$08,$01,$03,$03,$03,$19,$0B,$08
	defb $08,$01,$01,$01,$01,$46,$70,$05,$05,$05
	defb $08,$08,$08,$08,$07,$03,$01,$03,$01,$0B
	defb $01,$01,$01,$01,$01,$01,$01,$05,$05,$05
	defb $01,$01,$01,$01,$05,$44,$01,$01,$01,$03
	defb $01,$47,$07,$00,$05,$05,$28,$28,$05,$05
	defb $05,$05,$05,$28,$28,$05,$01,$08,$01,$01
	defb $42,$05,$05,$28,$28,$28,$28,$28,$05,$05
	defb $05,$05,$05,$05,$28,$28,$28,$05,$01,$01
	defb $07,$05,$28,$28,$05,$05,$05,$43,$07,$01
	defb $01,$05,$05,$05,$05,$05,$28,$05,$01,$01
	defb $01,$47,$05,$05,$00,$01,$01,$00,$00,$00
	defb $01,$01,$01,$01,$00,$00,$05,$05,$01,$01
	defb $01,$45,$00,$00,$01,$01,$00,$07,$00,$45
	defb $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
	defb $01,$00,$01,$01,$01,$01,$00,$00,$42,$01
	defb $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
	defb $44,$44,$44,$44,$44,$44,$44,$44,$44,$44
	defb $44,$44,$44,$44,$44,$44,$44,$44,$44,$00
	defb $44,$44,$44,$44,$44,$44,$44,$44,$44,$44
	defb $44,$44,$44,$44,$44,$44,$44,$44,$44,$44
	defb $44,$44,$44,$44,$44,$44,$44,$44,$44,$44
	defb $44,$44,$44,$44,$44,$44,$44,$44,$44,$44
	defb $44,$44,$44,$44,$44,$44,$44,$44,$44,$44
	defb $44,$44,$44,$44,$44,$44,$44,$44,$44,$00
