	;
	; Intergalactic Space Rescue - a puzzle game for the 16K ZX Spectrum
	; Assembler code for making noises
	;
	; If these routines are to be called for more than 1/50 second, then
	; interrupts should be disabled first.  NOISE and TONE may be called
	; for brief periods between interrupts.
	;
	; Copyright (C) Damian Walker 2012
	; Created 15-Dec-2012
	;

	; pseudo-random noise
	; inputs:
	;   H = pitch, or delay between clicks
	;   L = length of sound, in clicks
.noise	push af		; store registers about to be corrupted
	push bc		;
	push de		;
	ld c,l		; initialise counter for sound length
	ld de,(noisea)	; pick up noise data from where we left off
.noislp	ld a,(de)	; load byte for noise
	and $18		; isolate bits that deal with sound
	out ($fe),a	; output the sound
	ld b,h		; initialise the delay between clicks
.noisdl	djnz noisdl	; count down
	inc de		; point to next data
	dec c		; decrement counter for sound length
	jr nz,noislp	; continue making sound till done
	ld a,d		; check high bit of noise address
	and $1f		; ensure it stays within the lower ROM
	ld d,a		;
	ld (noisea),de	; store current noise address for next time
	pop de		; retrieve uncorrupted register values
	pop bc		;
	pop af		;
	ret		; all done
	; data
.noisea	defw $0000	; address of random data to be used as noise

	; constant tone
	; inputs:
	;   H = pitch, or delay between clicks
	;   L = length of sound, in clicks
.tone	push af		; store registers about to be corrupted
	push bc		;
	ld c,l		; initialise counter for sound length
	xor a
.tonelp	out ($fe),a	; output the sound
	xor $18		; toggle speaker bits
	ld b,h		; initialise the delay between clicks
.tonedl	djnz tonedl	; count down
	dec c		; decrement counter for sound length
	jr nz,tonelp	; continue making sound till done
	pop bc		;
	pop af		;
	ret		; all done

	; ping
	; inputs:
	;    H = pitch, or delay between clicks
	;    L = length of sound, in clicks
.ping	halt
	call tone
	dec l
	jr nz,ping
	ret