	;
	; Intergalactic Space Rescue - a puzzle game for the 16K ZX Spectrum
	; Assembler code for game-wide variables and constants
	;
	; These routines generate a 16-bit random number, and perform 8-bit
	; modulus arithmetic to reduce the number to a useful range for the
	; game.  Both routines have been adapted from code in the public 
	; domain.
	;
	; This file is INCLUDEd from game.asm and shouldn't be assembled on
	; its own.
	;
	; Copyright (C) Damian Walker 2012
	;

	; 16-bit Random number generator slightly modified from PD
	;   constant RANDSD = address of seed and generated random number
.rand16	push de		; store DE on stack
	push hl		; store HL on stack
	ld de,(randsd)	; seed should have been set from timer or some such
	ld a,d		; load A from seed high
	ld h,e		; load H from seed low
	ld l,$fd	; load L with 253
	or a		; reset carry flag
	sbc hl,de	; subtract seed from HL
	sbc a,0		; subtract carry from A
	sbc hl,de	; subtract seed from HL again
	ld d,0		; clear D
	sbc a,d		; subtract carry from A again
	ld e,a		; load D with A
	sbc hl,de	; subtract (D)E from HL
	jr nc,rand	; if HL positive, set random number now
	inc hl		; otherwise increase HL first
.rand	ld (randsd),hl	; save over seed
	pop hl		; retrieve HL
	pop de		; retrieve DE
	ret		; return

	; Simple modulus code to ensure number in desired range
	;   A = 8-bit divisor
	;   constant RANDSD = address of seed and last generated number
.randmo	push bc		; store BC on the stack
	push hl		; store HL on the stack
	ld hl,(randsd)	; retrieve random number
	res 7,h		; ensure positive
	ld c,a		; set BC to dividend
	ld b,0		; we're never interested in numbers > 255
.randml	or a		; reset carry flag
	sbc hl,bc	; subtract dividend from HL
	jp p,randml	; keep doing it till negative
	add hl,bc	; add the divided back again
	ld a,l		; result back in A
	pop hl		; retrieve HL
	pop bc		; retrieve DE
	ret		; return

