	;
	; Intergalactic Space Rescue - a puzzle game for the 16K ZX Spectrum
	; Assembler code for game-wide variables and constants
	;
	; This file looks more complicated than it would otherwise be because
	; I want to store data overwriting the now unused loader code, and the
	; game initialisation code once it has been executed.
	;
	; The origin defines the start of the on-off initialisation routine.
	; Thus values written during initialisation must be placed BEFORE the
	; origin, and values written once initialisation is complete may be
	; placed AFTER the origin.
	;
	; Created 10-Dec-2012
	;

	;
	; Constants
	;

	; display constants
defc	msgpos = $50c4		; address of message display line 1st char top
defc	msglen = $18		; 24 characters in display window

	;
	; Addresses of variables in memory
	;

	; player control
;defc	ctlopt = ASMPC		; ASMPC supposed to = ORG here
defc	ctlopt = $5d30		; control option saved here
defc	menopt = ctlopt + 1	; menu option chosen

	; random number generation
defc	randsd = menopt + 1	; the full random number seed
defc	randsl = randsd		; low byte of RANDSD
defc	randsh = randsd + 1	; high byte of RANDSD

	; game variables
defc	mssion = randsd + 2	; mission number
defc	rescxy = mssion + 2	; rescue ship position on map
defc	beacxy = rescxy + 1	; beacon position on map
defc	shfuel = beacxy + 1	; fuel left in ship
defc	mapdat = shfuel + 1	; 100 bytes of map data
defc	rscini = mapdat + 100	; initial position of rescue ship
defc	rescdr = rscini + 1	; last direction of rescue ship
defc	lvcode = rescdr + 1	; level code
defc	psignl = lvcode + 1	; previous signal strength