	;
	; Ossuary - an adventure game for the Sinclair ZX Spectrum
	; One-off initialisation routines
	;
	; Copyright (C) Damian Walker 2013
	; Created 29-Jan-2013
	;

	;
	; Miscellaneous initialisation tasks
	;

	; set the border colour
	ld a,$00	; we want black border colour
	out ($fe),a	; make it so

	; Randomise seed
	ld hl,($5c78)	; load the Spectrum timer
	ld (randsd),hl	; save to seed

	;
	; Ascertain the control method
	;

	; print the message
.ctl	ld hl,ctlmsg	; point at the controls message
	call msgprt	; print it

	; get the player's response
.ctlget	call rand16	; keep the dice shaking while we wait
	ld a,$bf	; let's look at row J-ENTER of keyboard
	in a,($fe)	; poll keyboard
	and $0c		; isolate J and K
	cp $0c		; are both keys up?
	jr z,ctlget	; continue to read keyboard till J/K pressed
	; transfer the correct input routine to ctlpol
	ld de,ctlpol	; this is where the control routine goes
	ld hl,kbdpol	; assume first that player wants keyboard
	ld bc,6		; we need to copy 6 bytes at most
	and $08		; look specifically at the J key
	jr nz,ctlset	; if up, don't use joystick routine
	ld hl,joypol	; if K not pressed then we want joystick
.ctlset	ldir		; copy the appropriate routine to ctlpol

	;
	; Fill in the screen colours
	;

	; colour the screen according to compressed table
.atr	ld de,$5800	; point DE at attribute file
	ld hl,attrtb	; point HL at compressed attribute table
.atrblk	ld a,(hl)	; first byte of block
	cp 0		; if it's zero...
	jp z,newgam	; then we're done
	bit 7,a		; is this a length byte?
	jr z,atrsng	; no, transfer a single byte
	and $7f		; remove high bit
	ld b,a		; transfer to counter
	inc hl		; next byte is attribute...
	ld a,(hl)	; ...so load it in
	jr atrcpy	; on to copying
.atrsng	ld b,1		; single byte
.atrcpy	bit 7,a		; is this a "skip" value?
	jr nz,atrskp	; yes, so skip the required number of bytes
	ld (de),a	; copy to the screen
	inc de		; point to next location
	djnz atrcpy	; continue till all bytes done
	inc hl		; next byte
	jr atrblk	; next block
.atrskp	ld c,b		; convert 8-bit B ...
	ld b,0		; ... into 16-bit BC
	ex de,hl	; swap registers temporarily for adding
	add hl,bc	; move screen pointer past area to skip
	ex de,hl	; swap registers back again
	inc hl		; next byte
	jr atrblk	; next block

	; compressed attribute table
.attrtb	defb $86,$06,$16, $85,$07,$88,$16,$85,$07,$16,$87,$06
	defb $82,$4d,$82,$47,$06,$07,$92,$00,$07,$06,$84,$00,$06
	defb $06,$82,$4d,$82,$07,$06,$07,$92,$00,$07,$06,$84,$00,$06
	defb $06,$82,$4e,$82,$47,$06,$07,$92,$00,$07,$87,$06
	defb $82,$4e,$82,$07,$06,$07,$92,$00,$07,$06,$84,$00,$06
	defb $06,$82,$4c,$82,$47,$06,$07,$92,$00,$07,$06,$84,$00,$06
	defb $06,$82,$4c,$82,$07,$06,$07,$92,$00,$07,$06,$84,$00,$06
	defb $06,$82,$4a,$82,$47,$06,$07,$92,$00,$07,$06,$84,$00,$06
	defb $06,$82,$4a,$82,$07,$06,$07,$92,$00,$07,$06,$84,$00
	defb $87,$06,$07,$92,$00,$07,$06,$84,$00,$06
	defb $06,$84,$47,$06,$07,$92,$00,$07,$06,$84,$00
	defb $87,$06,$07,$92,$00,$07,$06,$84,$00,$06
	defb $86,$ff,$07,$92,$00,$07,$06,$84,$00,$06
	defb $86,$ff,$07,$92,$00,$07,$06,$84,$00,$06
	defb $86,$ff,$07,$92,$00,$07,$86,$06
	defb $86,$ff,$07,$92,$00,$07,$8c,$ff
	defb $07,$92,$00,$07,$8c,$ff
	defb $07,$92,$00,$07,$8c,$ff
	defb $07,$92,$00,$07,$8c,$ff
	defb $16,$07,$90,$16,$07,$16,$93,$ff
	defb $8a,$01,$94,$ff
	defb $01,$a7,$ff
	defb $01,$96,$ff
	defb $01,$00

	;
	; Data
	;

	; control message
.ctlmsg	defm "KEYS OR JOYSTICK"
