	;
	; Ossuary - an adventure game for the Sinclair ZX Spectrum
	; Code for the inventory system's menu and associated routines
	;
	; Copyright (C) Damian Walker 2013
	; Created 16 Feb 2013
	;

	;
	; Menu routines
	;

	; entry point - decide what the default option should be
.invmnu	ld a,c		; store current inventory slot number
	ld (lstitm),a	; 
	ld d,0		; zero upper half of offset register pair DE
	call invadr	; get inventory item address
	ld a,(hl)	; what is there?
	or a		; is there anything?
	jr z,im_can	; no, so "cancel" is the default option
	cp $05		; is it edible>
	jr c,im_eat	; yes, so "consume" is the default option
	ld a,$01	; the top two options are already wielded
	cp c		; are we looking at a wielded item?
	jr nc,im_put	; yes, so "put away" is the default option
	ld c,$01	; set current option to "wield"
	jr im_lp	; proceed to loop
.im_can	ld c,$00	; set current option to "close inventory"
	jr im_lp	; proceed to loop
.im_eat	ld c,$03	; set current option to "consume"
	jr im_lp	; proceed to loop
.im_put	ld c,$02	; set current option to "put away"
	; menu looping point
.im_lp	ld a,c		; take current option
	add a,a		; convert to an 8-bit offset in the menu text table
	add a,a		;
	add a,a		;
	add a,a		;
	ld e,a		; convert 8-bit offset to 16-bit offset
	ld hl,im_txt	; point to the menu text
	add hl,de	; add the text offset
	call msgprt	; print the menu text
	; wait for a new LEFT/RIGHT activation or FIRE release
	ld b,$03	; we are only interested in LEFT and RIGHT
	call ctlslr	; wait for these to be released, if necessary
.im_pol	call ctlpol	; now poll the control device to see what is pressed
	bit 4,a		; has the fire button been released?
	jr z,im_rel	; yes, process menu option
	and $03		; otherwise we're interested only in left/right
	jr z,im_pol	; if neither is pressed, repeat
	; turn LEFT/RIGHT control into a menu offset
	bit 1,a		; is left control activated?
	jr z,im_rt	; no, so we're moving right
	ld a,$ff	; otherwise we're moving left
.im_rt	add a,c		; add the offset to the last-chosen menu option
	cp $ff		; have we passed the first option?
	jr z,im_sta	; yes, so handle this
	cp $05		; have we passed the last option?
	jr z,im_end	; yes, so handle this
	ld c,a		; otherwise update selected menu option
	jr im_lp	; back to menu loop
	; we've moved left past the first option - cycle to the last
.im_sta	ld c,$04	; select last option on the menu
	jr im_lp	; repeat menu
	; we've moved right past the last option - cycle to the first
.im_end	ld c,$00	; set to first option again ...
	jr im_lp	; and show it
	; select chosen option
.im_rel	ld a,c		; recall menu option
	add a,a		; convert to an 8-bit offset in the jump table
	ld e,a		; convert that to 16-bit offset
	ld a,(lstitm)	; recall inventory slot number
	ld c,a		; put it where it belongs
	ld hl,im_jmp	; point to the jump table
	add hl,de	; advance to the appropriate option
	ld e,(hl)	; load entry into DE
	inc hl		;
	ld d,(hl)	;
	ex de,hl	; swap entry into HL ...
	jp (hl)		; ... and jump there

	; menu text
.im_txt	defm "CLOSE INVENTORY "
	defm "   WIELD ITEM   "
	defm " PUT ITEM AWAY  "
	defm "  CONSUME ITEM  "
	defm "  DISCARD ITEM  "

	; menu jump table
.im_jmp	defw movupd	; do nothing with inventory, continue moving
	defw wield	; wield an item
	defw putawy	; put item away in bag
	defw consum	; eat an apple or drink a potion
	defw discrd	; discard an item

	;
	; Item manipulation routines
	;

	; wield an item
.wield	call invadr	; get address of current inventory slot
	ld a,(hl)	; what is there?
	or a		; is there anything?
	jr z,wld_no	; cannot wield this - on to error message
	ld de,herinv	; point to first wielded slot
	ld b,0		;
	ld a,(de)	; what is there?
	or a		; is it free?
	jr z,wld_do	; yes, on to wield it
	inc de		; otherwise look at the next slot
	inc b		;
	ld a,(de)	; what is there?
	or a		; is it free?
	jr nz,wld_hf	; no, so go to print error message
.wld_do	ld a,(hl)	; look at the selected item
	ld (de),a	; put it into hand ...
	ld (hl),0	; ... removing it from bag
	ld a,b		; look at hand which wields the item
	ld (lstitm),a	; this is now the current inventory slot
	call dr_inv	; redraw the inventory
	call clcmod	; recalculate the modifiers
	ld hl,wldmsg	; point to "item wielded" message
	ld (wk_msg),hl	; queue message for output
	call invsnd	; play inventory sound
	jp emoves	; allow enemy to move
.wld_no	ld hl,nw_msg	; point to "nothing to wield" message
	jr wld_dn	; finish wielding
.wld_hf	ld hl,hf_msg	; point to "hands full" message
.wld_dn	ld (wk_msg),hl	; store message to print
	jp movupd	; update screen and continue

	; consume an item
.consum	ld hl,hero_s	; point to hero strength
	ld a,(hl)	; initialise maximum health to strength
	inc hl		; move on to hero agility
	add a,(hl)	; add this to maximum health
	inc hl		; move on to hero intelligence
	add a,(hl)	; add this to maximum health
	ld hl,hero_h	; point to current health level
	cp (hl)		; is it already at maximum?
	jr z,con_ah	; yes, on to error message
	ld b,a		; set aside maximum health for a moment
	call invadr	; get address of current inventory slot
	ld a,(hl)	; what is there?
	or a		; is there anything?
	jr z,con_no	; no, on to error message
	cp $05		; is it a non-consumable?
	jr nc,con_no	; yes, on to error message
	and $01		; is it a potion?
	jr z,con_pn	; yes, consume the potion
	ld a,(hero_h)	; otherwise apple... load hero's current health
	add a,$04	; add goodness from apple
	cp b		; does that exceed maximum health?
	jr c,con_st	; no, so store health
.con_pn	ld a,b		; otherwise set health to maximum
.con_st	ld (hero_h),a	; store updated hero health
	ld (hl),0	; remove consumed item
	call drstat	; update statistics
	call dr_inv	; update inventory
	ld hl,conmsg	; point to "consumed" message
	ld (wk_msg),hl	; queue for printing
	call invsnd	; play inventory sound
	jp emoves	; now allow enemies to move
.con_ah	ld hl,ncheal	; point to "already healthy" message
	jr con_er	; on to queue it
.con_no	ld hl,nconms	; point to "nothing to consume" message
.con_er	ld (wk_msg),hl	; queue for printing
	jp movupd	; on to update screen

	; put item away from hand into rucksack
.putawy	ld a,c		; what is the current item slot?
	cp $02		; are we looking in the rucksack?
	jr nc,put_wr	; yes, item is already put away... on to error
	ld hl,herinv+11	; point to last inventory item
	ld b,10		; there are ten inventory slots is the rucksack
	xor a		; each one will be check for empty
.put_ci	cp (hl)		; is the inventory slot empty?
	jr z,put_mt	; yes, so stop searching
	dec hl		; look at another inventory slot
	djnz put_ci	; continue checking inventory
	; there's no free inventory slot
	ld hl,fulmsg	; point to "your rucksack is full" message
	jr put_er	; on to finish with picking up
	; item is not in hand
.put_wr	ld hl,nhnmsg	; point to "item not in hand" message
.put_er	ld (wk_msg),hl	; store message to print
	jp movupd	; update screen and continue
	; empty inventory slot found - put item away
.put_mt	ex de,hl	; DE now contains slot to move to
	call invadr	; what in-hand slot were we looking at?
	ld a,(hl)	; what is there?
	or a		; is there anything to put away?
	jr z,put_wr	; no, so error message
	ld (de),a	; store item in rucksack
	ld (hl),0	; remove from hand
	ld a,b		; what inventory slot was the item put into?
	inc a		; 
	ld (lstitm),a	; this is now the current inventory slot
	call clcmod	; recalculate modifiers
	call dr_inv	; redraw inventory
	ld hl,putmsg	; point to "item put away" message
	ld (wk_msg),hl	; queue message for output
	call invsnd	; play inventory sound
	jp emoves	; allow enemy to move

	; discard an item
.discrd	call invadr	; what item slot were we looking at?
	ld a,(hl)	; what does the hero have there?
	or a		; is there anything there?
	jr z,dis_nt	; nothing there, error
	ld b,a		; remember the item
	push hl		; store the inventory slot address
	ld a,(hero_l)	; where is the hero?
	call mapadr	; where is that map block in memory?
	ld a,(hl)	; what is there?
	and $0f		; just isolate the "item" bits
	jr nz,dis_cd	; something here already - error
	ld a,(hl)	; take empty path
	or b		; add object to it
	ld (hl),a	; store on the map
	pop hl		; retrieve the inventory slot address
	ld (hl),0	; remove the discarded item
	call clcmod	; recalculate modifiers
	call dr_inv	; draw inventory
	ld hl,dismsg	; point to "item discarded" message
	ld (wk_msg),hl	; queue message for output
	call invsnd	; play inventory sound
	jp emoves	; allow enemy to move
.dis_nt	ld hl,ntdmsg	; point to "nothing to drop" message
	jr dis_er	; on to queue error message
.dis_cd	ld hl,cdhmsg	; point to "cannot drop here" message
.dis_er	ld (wk_msg),hl	; queue message for output
	jp movupd	; update messages and display

	;
	; Subroutines
	;

	; recalculate modifiers after wielding/unwielding
.clcmod	push bc		; preserve values of registers to be corrupted
	push hl		;
	call zermod	; zero the modifiers
	ld hl,herinv	; point to top of inventory
	ld b,2		; we will look at two slots
	ld c,b		; 2 is a useful value here
.clcmlp	push hl		; store inventory pointer on stack
	ld a,(hl)	; what is in the current slot?
	ld hl,heroms	; first point at strength modifier to check weapons
	cp $07		; is it an axe?
	jr nz,wldswd	; no, check for sword
	ld a,(hl)	; get strength modifier
	add a,c		; add 2
	jr adwswd	; on to add sword modifier
.wldswd	cp $06		; is it a sword?
	jr nz,wlddag	; no, check for dagger
	ld a,(hl)	; get strength modifier
.adwswd	add a,c		; add 2
	jr adwdag	; on to add dagger modifier too
.wlddag	cp $05		; is it a dagger?
	jr nz,wldirn	; no, check for iron shield
	ld a,(hl)	; get strength modifier
.adwdag	add a,c		; add 2
	ld (hl),a	; store strength modifier
	jr clcmnx	; on to next item
.wldirn	inc hl		; point to agility modifier
	cp $09		; is the item an iron shield?
	jr nz,wldwds	; no, on to check for wooden shield
	ld a,(hl)	; get agility modifier
	add a,c		; add 2 to it
	jr adwwds	; on to add wooden shield too
.wldwds	cp $08		; is the item a wooden shield?
	jr nz,wldwnd	; no, on to next check for wand
	ld a,(hl)	; get agility modifier
.adwwds	add a,c		; add 2 to it
	ld (hl),a	; store agility modifier
	jr clcmnx	; on to next item
.wldwnd	inc hl		; point to intelligence modifier
	cp $0c		; is the item a wand?
	jr nz,wldamu	; no, on to check for amulet
	ld a,(hl)	; get intelligence modifier
	add a,c		; add 2 to it
	ld (hl),a	; store intelligence modifier
	jr clcmnx	; on to next item
.wldamu	cp $0b		; is the item an amulet?
	jr nz,clcmnx	; no, on to next item
	ld a,(hl)	; get intelligence modifier
	add a,c		; add 2 to it
	ld (hl),a	; store intelligence modifier
.clcmnx	pop hl		; retrieve inventory pointer
	inc hl		; point to next inventory item
	djnz clcmlp	; continue till both items checked
	call drstat	; show updated stat modifiers
	pop hl		; restore values of corrupted registers
	pop bc		;
	ret		; all done

	; messages
.wldmsg	defm "ITEM NOW WIELDED"
.nw_msg	defm "NOTHING TO WIELD"
.hf_msg	defm " HANDS ARE FULL "
.conmsg	defm " ITEM CONSUMED  "
.nconms	defm " NO EDIBLE ITEM "
.ncheal	defm "ALREADY HEALTHY "
.nhnmsg	defm "ITEM NOT IN HAND"
.putmsg	defm "ITEM IS PUT AWAY"
.dismsg	defm " ITEM DISCARDED "
.ntdmsg	defm "NOTHING TO DROP "
.cdhmsg	defm "CANNOT DROP HERE"