	; Ossuary - an adventure game for the ZX Spectrum
	; Loader assembly language code
	;
	; This program resides in the BASIC area, embedded in a REM on the
	; first line of the BASIC program.  The only other BASIC command
	; is RANDOMIZE USR 23760, which runs the routine.
	;
	; What it does: first, transfers the CYNINGSTAN logo to the screen.
	; Then loads in a loading screen, which also contains hidden in-game
	; graphics obscured by black-on-black attributes (as well as some
	; openly-visible decorative graphics that remain on-screen throughout
	; the game).
	;
	; Then it loads the main game block.  This overwrites the CYNINGSTAN
	; logo which is no longer needed, along with the RANDOMIZE command and
	; all memory that follows it.  The main game will later overwrite
	; parts of this loader with game data.
	;
	; Copyright (C) Damian Walker 2013
	; Created 10-Nov-2012 (for Barbarians)
	; Updated 28-Jan-2013
	;

	;
	; The program
	;

	; origin address
	org $5CD0	; $5CD0 = 23760 = char after REM on 1st BASIC line
	; fill the screen with white-on-white
	ld hl,$5800
	ld de,$5801
	ld bc,$2FF
	ld (hl),$3F
	ldir
	; copy the cyningstan pattern
	ld ix,scrpos	; point at first line on screen
	ld hl,cyning	; point at first byte of message
.copyln	ld d,(ix+$01)	; point DE to the correct screen area
	ld e,(ix+$00)
	ld bc,16	; number of bytes to transfer
	ldir		; transfer the bytes
	inc ix		; point at next line on screen
	inc ix
	ld a,(linect)	; check the line counter
	dec a		; decrement it
	jr z,colour	; return if we're done
	ld (linect),a	; otherwise store the line counter
	jr copyln	; copy the next line
	; set the colours for the cyningstan pattern
.colour	ld a,0		; start of count
	ld b,$38	; black text on white background?
	ld hl,$5828	; start of attributes
	ld de,$0010	; for skipping to next line
.cpaint	ld (hl),b	; save attribute
	inc hl		; next attribute
	inc a		; count up
	cp $20		; all done?
	jr z,loader	; proceed to screen and program loading if so
	cp $10		; end of first line?
	jr nz,skpinc	; no, skip "newline"
	add hl,de	; beginning of next line
.skpinc	jr cpaint	; next byte
.loader	ld a,$ff	; tell ROM to load data, not header
	scf		; carry set for LOAD (not VERIFY)
	ld de,$1b00	; number of bytes in the screen
	ld ix,$4000	; start address of the screen
	call $0556	; ld-bytes
	ld a,$ff	; tell ROM to load data again
	scf		; carry set for load
	ld de,$1eda	; main binary is 7898 bytes
	ld ix,linect	; we can overwrite this now
	call $0556	; ld-bytes

	;
	; Data used by the program
	;

	; The line counter
.linect	defb $10

	; Start addresses of 16 screen lines
.scrpos	defw $4028,$4128,$4228,$4328,$4428,$4528,$4628,$4728
	defw $4048,$4148,$4248,$4348,$4448,$4548,$4648,$4748

	; The source image
.cyning	defb $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	defb $ff,$ff,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01
	defb $c8,$13,$00,$3c,$70,$ee,$0c,$ce,$0c,$0f,$81,$cf,$c0,$c0,$e0,$c1
	defb $c8,$13,$00,$ff,$30,$ce,$0c,$ce,$0c,$3f,$c3,$ff,$c1,$c0,$e0,$c1
	defb $f8,$1f,$01,$c3,$b9,$cf,$0c,$cf,$0c,$70,$e6,$33,$01,$e0,$f0,$c1
	defb $c4,$23,$01,$80,$19,$8f,$8c,$cf,$8c,$60,$76,$03,$01,$e0,$f8,$c1
	defb $c3,$c3,$03,$00,$1f,$8d,$8c,$cd,$8c,$c0,$07,$03,$03,$70,$d8,$c1
	defb $c2,$43,$03,$00,$0f,$0d,$cc,$cd,$cc,$c0,$03,$c3,$03,$30,$dc,$c1
	defb $c2,$43,$03,$00,$0f,$0c,$ec,$cc,$ec,$c7,$f0,$e3,$07,$30,$ce,$c1
	defb $c3,$c3,$03,$00,$06,$0c,$6c,$cc,$6c,$c7,$f0,$33,$07,$f8,$c6,$c1
	defb $c4,$23,$01,$80,$06,$0c,$7c,$cc,$7c,$60,$70,$33,$07,$f8,$c7,$c1
	defb $f8,$1f,$01,$c3,$86,$0c,$3c,$cc,$3c,$70,$e6,$33,$0e,$1c,$c3,$c1
	defb $c8,$13,$00,$ff,$06,$0c,$1c,$cc,$1c,$3f,$c7,$e3,$0c,$0c,$c1,$c1
	defb $c8,$13,$00,$3e,$06,$0c,$1c,$cc,$1c,$0f,$83,$c3,$1c,$0e,$c1,$c1
	defb $ff,$ff,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01
	defb $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff