	;
	; Ossuary - an adventure game for the Sinclair ZX Spectrum
	; The main game code
	;
	; Copyright (C) Damian Walker 2013
	; Created 28-Jan-2013
	;

	; origin address
	org $5d30	; check this against LINECT in the loader

	;
	; Other source files
	;

	; constants and variables
	include "variables.asm"	; game variables

	; game routines
	include "init.asm"	; one-off initialisation
	include "newgam.asm"	; new game creation
	include "newlvl.asm"	; new level creation
	include "moves.asm"	; movement of hero and enemies
	include "menu.asm"	; menu system
	include "invent.asm"	; inventory subsystem
	include "invmnu.asm"	; inventory menu
	include "endgam.asm"	; end-game presentation

	; subroutines
	include "display.asm"	; graphical display
	include "msgprt.asm"	; message printing
	include "control.asm"	; keyboard and joystick control
	include "random.asm"	; random number generation
	include "arithm.asm"	; arithmetic
	include "noise.asm"	; making noises
	include "tape.asm"	; loading, saving and restarting games

	; data
	include "charset.def"