	;
	; Ossuary - an adventure game for the Sinclair ZX Spectrum
	; Code for the menu and some of its simpler functions
	;
	; Copyright (C) Damian Walker 2013
	; Created 05 Feb 2013
	;

	;
	; Menu routines
	;

	; entry point - decide what the default option should be
.menu	ld d,0		; zero upper half of offset register pair DE
	ld a,(hero_l)	; what is the hero's coordinates?
	call mapadr	; translate to a map block address HL
	ld a,(hl)	; what is here?
	and $0f		; is there anything here?
	jr z,mn_inv	; no, go to set inventory option
	cp $0f		; are the stairs here?
	jr z,mn_des	; yes, so go to set "descend" option
	ld c,$02	; some other object, so "pick up" is default option
	jr mn_lp	; proceed to loop
.mn_inv	ld c,$01	; set "inventory" as the default option
	jr mn_lp	; proceed to loop
.mn_des	ld c,$03	; set "descend" as default option
	; menu looping point
.mn_lp	ld a,c		; take current option
	add a,a		; convert to an 8-bit offset in the menu text table
	add a,a		;
	add a,a		;
	add a,a		;
	ld e,a		; convert 8-bit offset to 16-bit offset
	ld hl,mn_txt	; point to the menu text
	add hl,de	; add the text offset
	call msgprt	; print the menu text
	; wait for a new LEFT/RIGHT activation or FIRE release
	ld b,$03	; we are only interested in LEFT and RIGHT
	call ctlslr	; wait for these to be released, if necessary
.mn_pol	call ctlpol	; now poll the control device to see what is pressed
	bit 4,a		; has the fire button been released?
	jr z,mn_rel	; yes, process menu option
	and $03		; otherwise we're interested only in left/right
	jr z,mn_pol	; if neither is pressed, repeat
	; turn LEFT/RIGHT control into a menu offset
	bit 1,a		; is left control activated?
	jr z,mn_rt	; no, so we're moving right
	ld a,$ff	; otherwise we're moving left
.mn_rt	add a,c		; add the offset to the last-chosen menu option
	cp $ff		; have we passed the first option?
	jr z,mn_sta	; yes, so handle this
	cp $08		; have we passed the last option?
	jr z,mn_end	; yes, so handle this
	ld c,a		; otherwise update selected menu option
	jr mn_lp	; back to menu loop
	; we've moved left past the first option - cycle to the last
.mn_sta	ld c,$07	; select last option on the menu
	jr mn_lp	; repeat menu
	; we've moved right past the last option - cycle to the first
.mn_end	ld c,$00	; set to first option again ...
	jr mn_lp	; and show it
	; select chosen option
.mn_rel	ld a,c		; recall menu option
	add a,a		; convert to an 8-bit offset in the jump table
	ld e,a		; convert that to 16-bit offset
	ld hl,mn_jmp	; point to the jump table
	add hl,de	; advance to the appropriate option
	ld e,(hl)	; load entry into DE
	inc hl		;
	ld d,(hl)	;
	ex de,hl	; swap entry into HL ...
	jp (hl)		; ... and jump there

	; menu text
.mn_txt	defm "WAIT A MOMENT..."
	defm " VIEW INVENTORY "
	defm "  PICK UP ITEM  "
	defm " DESCEND STAIRS "
	defm " SAVE THIS GAME "
	defm "  LOAD IN GAME  "
	defm " START NEW GAME "
	defm "  CANCEL MENU   "

	; menu jump table
.mn_jmp	defw emoves	; wait a moment (allow enemies to move"
	defw invent	; inventory subsystem
	defw pickup	; pick up an object
	defw descnd	; descend the stairs
	defw savgam	; save the game
	defw lodgam	; load a game
	defw newgmc	; confirm new game
	defw movupd	; back to screen update

	;
	; Pick up code and data
	;

	; pick up an item - start by checking if there's something here
.pickup	ld a,(hero_l)	; recall hero location
	call mapadr	; convert this to a map address HL
	ex de,hl	; remember its map block address as DE
	ld a,(de)	; what is there?
	and $0f		; isolate bits representing the item
	jr z,pic_no	; nothing to pick up - go to error
	cp $0f		; is the "item" the stairs?
	jr z,pic_no	; can't pick these up - go to error
	cp $03		; does the item need to be in the inventory?
	jr c,pic_gd	; no it's gold - so handle it differently
	; check to see if there's a free inventory slot
	ld c,a		; remember what this item is
	ld hl,herinv+11	; point to last inventory item
	ld b,12		; there are twelve inventory slots
	xor a		; each one will be check for empty
.pic_ci	cp (hl)		; is the inventory slot empty?
	jr z,pic_mt	; yes, so stop searching
	dec hl		; look at another inventory slot
	djnz pic_ci	; continue checking inventory
	; there's no free inventory slot
	ld hl,fulmsg	; point to "your rucksack is full" message
	jr pic_er	; on to finish with picking up

	; empty inventory slot found - pick up item
.pic_mt	ld (hl),c	; store the item in the inventory
	ld a,b		; store item slot number for next inventory access
	dec a		;
	ld (lstitm),a	;
	call clcmod	; recalculate modifiers (e.g. weapon straight to hand)
	call dr_inv	; redraw the inventory
	call invsnd	; play the inventory sound
	jr pic_rm	; on to remove the item from the map

	; this is gold - add it to the total
.pic_gd	ld hl,(hergld)	; point to the gold store
.pic_cg	inc hl		; count gold from purse or casket ...
	inc hl		; ... 3 for purse, 6 for casket ...
	inc hl		; ... which will be converted to 2/5 later
	dec a		; remove gold from purse or casket
	jr nz,pic_cg	; continue counting till empty
	dec hl		; now reduce by 1 as described above
	ld (hergld),hl	; store the gold
	call drgold	; redraw the gold counter
	call gldsnd	; sound the clink of gold

	; remove the item from the map
.pic_rm	ex de,hl	; now HL contains map block pointer again
	ld (hl),$20	; make sure it contains the hero alone
	ld hl,picmsg	; "picked up object" message
	ld (wk_msg),hl	; ensure appropriate message to be printed
	jp emoves	; now allow creatures to move

	; error while picking up - nothing here!
.pic_no	ld hl,nopmsg	; point to "nothing here" message
	; error while picking up - entry point when pointer set
.pic_er	ld (wk_msg),hl	; ensure message will be printed
	jp movupd	; update message and map (skip enemy moves)

	; pick-up messages
.fulmsg	defm "YOUR BAG IS FULL"
.nopmsg	defm "NOTHING TO TAKE!"
.picmsg	defm " PICKED UP ITEM "

	;
	; Descend the stairs
	;

	; entry point
.descnd	ld a,(hero_l)	; recall hero location
	call mapadr	; convert this to a map address HL
	ld a,(hl)	; what is there?
	and $0f		; isolate item bits
	cp $0f		; are these the stairs?
	jr z,lvlinc	; yes, so on to prepare for new level
	ld hl,dnsmsg	; point to "no stairs here" message
	ld (wk_msg),hl	; ensure message will be printed
	jp movupd	; update message and map (skip enemy moves)

	; increase level number and difficulty
.lvlinc	or $10		; restore the open ground bit
	ld (hl),a	; store this to the map
	ld hl,glevel	; point to the level number
	inc (hl)	; increase it
	ld a,(hl)	; what is it?
	cp $18		; is this the last level?
	jr z,desnow	; yes, so skip difficulty increase
.chaspc	call rand16	; generate a random number
	ld a,(randsd)	; get 8-bit value
	ld d,a		; turn into divisor
	ld e,3		; load 3 as dividend ...
	call div8	; to create a random number 0..3
	ld d,0		; turn into 16-bit offset
	ld hl,nmemin	; point to level difficulty information
	add hl,de	; add offset
	ld a,e		; see which aspect has been chosen
	cp $00		; is it minimum enemy?
	jr nz,desc_0	; no, it is max or aggression
	ld a,(nmemax)	; this value cannot exceed maximum enemy
	jr desc_1	; on to check value
.desc_0	add a,$07	; nmemax cannot exceed 8, nmeagr cannot exceed 9
.desc_1	cp (hl)		; compare maximum to current value
	jr z,chaspc	; it is at maximum already, choose something else
	inc (hl)	; increase the chosen difficulty aspect
.desnow	ld hl,waitms	; point to "Please wait" message
	call msgprt	; print it
	call mapdrw	; redraw the map with the hero gone
	call dessnd	; make the stairs noise
	jp newlvl	; on to generate the new level

	; messages
.dnsmsg	defm " NO STAIRS HERE "