	;
	; Ossuary - an adventure game for the Sinclair ZX Spectrum
	; Code for new game
	;
	; This part of the program initialises the game variables, and
	; generates a player character, giving him a few items in his
	; inventory.
	;
	; Copyright (C) Damian Walker 2013
	; Created 30-Jan-2013
	;

	;
	; Initialise the game
	;

	; display wait message
.newgam	ld hl,waitms	; point to "Generating hero" message
	call msgprt	; print it

	; initialise certain game variables
	ld hl,glevel	; start at game level
	ld (hl),$01	; set it to 1
	push hl		; transfer source pointer ...
	pop de		; ... to destination pointer ...
	inc de		; ... and increment
	ld bc,3		; that 1 should be copied to following 3 variables
	ldir		; set min, max and aggression of enemies
	ld hl,exp_pt	; set experience points to zero
	ld (hl),0	;
	inc hl		; point HL to necromancer health
	ld (hl),24	; make them 24

	;
	; Generate the hero
	;

	; initial minimum stats
	ld hl,hero_s	; point to strength
	ld (hl),$02	; store minimum value
	inc hl		; point to agility
	ld (hl),$02	; store minimum value
	inc hl		; point to intelligence
	ld (hl),$02	; store minimum value
	call zermod	; zero the modifiers

	; increase stats to sensible level
	ld b,$0f	; increase stats by a total of 15
.statlp	call rand16	; get random number 0..2 as stat index
	ld a,(randsd)	;
	ld d,a		;
	ld e,3		;
	call div8	;
	ld d,0		;
	ld hl,hero_s	; point to strength
	add hl,de	; add the stat index
	ld a,(hl)	; what is that stat now?
	cp $0c		; has it reached 12?
	jr z,statlp	; yes, so on to choose another stat
	inc (hl)	; otherwise increase the stat
	djnz statlp	; continue until all points distributed
	ld a,$15	; health should be 21
	ld (hero_h),a	; store it now

	; initialise the inventory and gold
	ld de,herinv	; point destination to hero inventory
	ld hl,stitem	; point source to starting items
	ld bc,$0c	; there are twelve item spaces
	ldir		; copy them
	ld hl,0		; the player starts with no gold
	ld (hergld),hl	; store it
	xor a		; zero accumulator
	ld (lstitm),a	; store that zero in "last item referenced"

	; artificial delay
	ld b,100	; 100 frames
.ndelay	halt		; wait for next interrupt
	djnz ndelay	; count down 100 interrutps

	; display the character
	call drstat	; draw the character stats
	call drgold	; draw the gold
	call dr_inv	; draw the inventory

	; on to the next part of the program
	jr newlvl	; go to generate the first level

	;
	; Subroutines
	;

	; zero the modifiers
.zermod	push hl		; preserve registers to be corrupted
	xor a		; get a zero
	ld hl,heroms	; point to strength modifier
	ld (hl),a	; zero it
	inc hl		; point to agility modifier
	ld (hl),a	; zero it
	inc hl		; point to intelligence modifier
	ld (hl),a	; zero it
	inc hl		; point to health modifier
	ld (hl),a	; zero it
	pop hl		; restore corrupted registers
	ret		; all done

	;
	; Data
	;

	; starting items
.stitem	defb $00	; empty left hand
	defb $00	; empty right hand
	defb $00	; empty slot
	defb $00	; empty slot
	defb $00	; empty slot
	defb $00	; empty slot
	defb $00	; empty slot
	defb $00	; empty slot
	defb $00	; empty slot
	defb $04	; a potion
	defb $03	; an apple
	defb $03	; an apple

	; messages
.waitms	defm " PLEASE WAIT... "