	;
	; Ossuary - an adventure game for the Sinclair ZX Spectrum
	; Code for new level
	;
	; The level is made up of blocks in a 16x16 grid.  This is split into
	; nine "cells" in a 3x3 grid.  Each cell can be a chamber or a corridor,
	; and cells are linked in a random pattern.  This pattern is not
	; always a true maze; usually there are multiple paths from the player
	; to the stairwell.
	;
	; Copyright (C) Damian Walker 2013
	; Created 30-Jan-2013
	;

	;
	; Decide the cell layout
	;

	; scramble the cell numbers
.newlvl	ld hl,celord	; point to cell list
	ld b,9		; there are nine cells
.cellsl	call rand16	; generate a random number
	ld a,(randsd)	; reduce to range 0..8
	ld d,a		;
	ld e,9		;
	call div8	;
	ld d,0		; turn random number into 16-bit offset
	push hl		; turn offset into full address
	ld hl,celord	;
	add hl,de	;
	ex de,hl	;
	pop hl		;
	ld a,(de)	; swap the two values
	ld c,a		; 
	ld a,(hl)	; 
	ld (hl),c	;
	ld (de),a	;
	inc hl		;
	djnz cellsl	; continue till numbers are scrambled

	; clear paths between cells from last level
	xor a		; first we fill the cells with zero
	ld hl,celmap	; point HL to cell data
	ld (hl),a	; save the zero
	push hl		; point DE to next location
	pop de		;
	inc de		;
	ld bc,$0008	; there are eight more cells to copy
	ldir		; copy the zero

	; rebuild paths between cells for this level
	ld hl,celord	; look at the cell order
	ld b,8		; there are EIGHT links to make
.cell_0	ld d,(hl)	; what is the current cell?
	ld c,d		; store it for later
	ld e,3		; we want to divide by 3
	call div8	; D now contains Y coordinate, E contains X
	ld (wkcell),de	; save origin cell
	inc hl		; point to next cell
	ld d,(hl)	; what is the next cell?
	ld e,3		; we want to divide by 3
	call div8	; D now contains Y coordinate, E contains X
	ld (wkcell+2),de ; save origin cell
	push hl		; now we use HL to point to cell map
	ld hl,celmap	; point to start of cell map
	ld e,c		; recall current cell number
	ld d,0		; turn into a 16-bit offset
	add hl,de	; now hl points to current cell map data
	; beat a vertical path
.cellvp	ld a,(wkcell+3)	; what is the destination Y coordinate?
	ld c,a		; store it for comparison
	ld a,(wkcell+1)	; what is the current Y coordinate?
	cp c		; compare destination Y coordinate to it
	jr z,cellhp	; we're lined up vertically, on to horizontal
	jr c,celldn	; skip if destination is to the south
	set 3,(hl)	; set north bit of current cell
	dec hl		; point HL one cell to the north
	dec hl		;
	dec hl		;
	set 2,(hl)	; set south bit of cell above
	dec a		; decrease current Y coordinate
.cell_1	ld (wkcell+1),a	; store it
	jr cellvp	; continue with the vertical path
.celldn	set 2,(hl)	; set south bit of current cell
	inc hl		; point HL one cell to the south
	inc hl		;
	inc hl		;
	set 3,(hl)	; set north bit of cell below
	inc a		; increase current y coordinate
	jr cell_1	; on to store & continue vertical path
	; beat a horizontal path
.cellhp	ld a,(wkcell+2)	; what is the destination X coordinate?
	ld c,a		; store it for comparison
	ld a,(wkcell)	; what is the current X coordinate?
	cp c		; compare the destination X coordinate to it
	jr z,cell_2	; done linking this cell if they're equal
	jr c,cellrt	; skip if destination to the east
	set 1,(hl)	; set west bit of current cell
	dec hl		; point HL to the west
	set 0,(hl)	; set east bit of adjacent cell
	dec a		; decrement current X coordinate
.cell_3	ld (wkcell),a	; store it
	jr cellhp	; continue with the horizontal path
.cellrt	set 0,(hl)	; set east bit of current cell
	inc hl		; point HL to the east
	set 1,(hl)	; set west bit of adjacent cell
	inc a		; increment current X coordinate
	jr cell_3	; on to store & continue horizontal path
	; done with these two cells
.cell_2	pop hl		; retrieve cell order pointer
	djnz cell_0	; continue till all cells linked

	; decide which cells are chambers and which are corridors
	ld hl,celmap	; point HL to the cell map
	ld b,$09	; there are nine cells to check
.cellcl	ld a,(hl)	; what is here?
	cp $08		; if dead end with north exit ...
	jr z,cellch	; ... then this is a chamber
	cp $04		; same for the south ...
	jr z,cellch	;
	cp $02		; ... the west ...
	jr z,cellch	;
	cp $01		; ... and the east
	jr z,cellch	;
	call rand16	; otherwise the outcome is random
	ld a,(randsd)	; what is the random number?
	and $80		; check bit 7
	jr z,cellch	; make this a chamber if not set
	jr cell_4	; otherwise leave as a corridor
.cellch	ld a,$80	; set chamber bit
	or (hl)		; combine with exits
	ld (hl),a	; store
.cell_4	inc hl		; point to next cell
	djnz cellcl	; continue until all cells done

	; fill the level map with solid wall
	ld hl,lvlmap	; point to level map
	ld (hl),0	; zero it
	push hl		; point DE to the following address
	pop de		; 
	inc de		;
	ld bc,$00ff	; 255 copies are needed
	ldir		; make them

	; the open out the chambers and the connecting paths
	ld hl,celmap	; point to the cell map
	ld b,$09	; there are nine cells with possible chambers
.open_a	bit 7,(hl)	; is this a chamber?
	jr z,open_f	; no, on to the opening paths
	push bc		; store cell counter
	push hl		; store cell map pointer
	ld a,$09	; calculate chamber number
	sub b		;
	call cl_loc	; calculate cell location on map, top left
	add a,$11	; move one square diagonally into the cell
	ld d,0		; put this offset into DE
	ld e,a		;
	ld hl,lvlmap	; point HL to top left inner square of chamber
	add hl,de	;
	ld e,$0c	; load (D)E with line skip offset
	ld b,$04	; there are four lines per chamber
.open_d	push bc		; store the chamber line counter
	ld b,$04	; there are four blocks per line in a chamber
.open_e	ld (hl),$10	; store the first open floor block
	inc hl		; point to the next block
	djnz open_e	; continue for the rest of the line
	add hl,de	; skip to the next line
	pop bc		; retrieve chamber line counter
	djnz open_d	; continue for the rest of the chamber
	pop hl		; retrieve cell map pointer
	pop bc		; retrieve cell counter
.open_f	push hl		; retain pointer to cell map
	pop ix		;
	ld c,$08	; start thinking north
	ld de,dirtbl	; point DE to direction table
.open_2	ld a,$09	; recalculate chamber number
	sub b		;
	call cl_loc	; calculate cell location on map, top left
	add a,$22	; move two squares diagonally into the cell
	push de		; store direction table pointer before we corrupt it
	ld d,0		; put the map offset into DE
	ld e,a		;
	ld hl,lvlmap	; point HL to central block of corridor
	add hl,de	;
	pop de		; restore pointer to direction table
	ld a,(ix+00)	; what directions should be open?
	and c		; the current direction?
	jr z,open_0	; no, skip the opening
	ld a,(de)	; get direction offset
	push de		; store direction table again
	ld d,0		; convert direction to a 16-bit offset
	cp $80		; is the 8-bit offset positive?
	jr c,open_3	; yes, so leave 16-bit offset positive
	ld d,$ff	; otherwise, make 16-bit offset negative
.open_3	ld e,a		; transfer lower half of offset
	push bc		; save the cell counter
	ld b,$03	; we should clear three blocks
.open_1	ld (hl),$10	; create an opening at the current block
	add hl,de	; move from current block by offset
	djnz open_1	; continue until three blocks in direction are clear
	pop bc		; retrieve cell counter
	pop de		; restore pointer to direction table
.open_0	inc de		; point to next direction in table
	srl c		; move on direction bit
	jr nc,open_2	; continue through all directions
	push ix		; transfer cell map pointer back to HL
	pop hl		;
	inc hl		; look at the next cell
	djnz open_a	; on to process cells till done

	; turn some exposed walls into decorated walls
	ld ix,lvlmap+1	; point to second block on level map
	ld b,$fe	; there are 254 blocks to check
	ld c,$10	; we'll be looking for adjacent open ground
.decolp	ld a,(ix+$00)	; what's here?
	or a		; is it an undecorated wall?
	jr nz,decosk	; no, skip decoration
	ld a,b		; check current block location
	cp $f0		; is it on the top row?
	jr nc,deco_s	; yes, so don't look north
	ld a,(ix-$10)	; what is to the north?
	cp c		; is it open ground?
	jr z,decort	; yes, so go to decorate this block
	ld a,b		; check block location again
	cp $11		; is it above the bottom row?
	jr c,deco_w	; no, so don't look south
.deco_s	ld a,(ix+$10)	; what is to the south?
	cp c		; is it open ground?
	jr z,decort	; yes, so go to decorate this block
.deco_w	ld a,(ix-$01)	; what is to the west?
	cp c		; is it open ground?
	jr z,decort	; yes, so go to decorate this block
	ld a,(ix+$01)	; what is to the east?
	cp c		; is it open ground?
	jr nz,decosk	; no, so skip decoration
.decort	call rand16	; get a random number
	ld a,(randsd)	; what is it?
	cp $80		; is it above 50%?
	jr c,decosk	; no, so leave block undecorated
	and $03		; otherwise isolate lowest bits of random number
	ld (ix+$00),a	; and decorate this block
.decosk	inc ix		; point to next block
	djnz decolp	; continue decorating blocks till done

	; place the hero
.plhero	call randbl
	ld a,e		; recall location
	ld (hero_l),a	; store the location
	ld (hl),$20	; place the hero on the map

	; place the main level objective - stairs or necromancer
.pl_obj	call randbl	; choose a random block
	ld a,(hero_l)	; recall the player location
	ld d,a		; store in D
	call calcds	; calculate distance
	cp $0a		; is it 10 or less?
	jr c,pl_obj	; yes, so choose somewhere else
	ld d,$1f	; usually stairs will be placed
	ld a,(glevel)	; but what is the current level?
	cp $18		; is it level 24?
	jr nz,plob_0	; if not, leave as stairs
	ld d,$30	; but if so, place the necromancer on the map
	ld a,e		; transfer his location ...
	ld (necrol),a	; ... into the appropriate variable
.plob_0	ld (hl),d	; place stairs on the map

	; now place eight enemies
	ld ix,nmetbl	; point to enemy table
	ld b,8		; there are eight enemies
.pl_nme	call randbl	; choose a random empty block on the map
	ld a,(hero_l)	; recall the hero location
	ld d,a		; store in D ready for distance calculation
	call calcds	; calculate distance between player and random block
	cp $07		; is it 7 or less?
	jr c,pl_nme	; yes, so choose somewhere else
	ld (ix+$00),e	; store position for this enemy
	push hl		; store the block address for later retrieval
	ld hl,nmemax	; point to largest enemy
	ld a,(hl)	; what is it?
	dec hl		; point to minimum enemy
	sub (hl)	; what's the difference?
	jr z,setnme	; there is only one enemy type, skip random choice
	ld e,a		; store difference ...
	inc e		; convert difference to dividend
	call rand16	; choose a random number
	ld a,(randsd)	; load it in
	ld d,a		; store it as a divisor
	call div8	; now E contains random choice 0..n
	ld a,e		; transfer back to A
.setnme	add a,(hl)	; add minimum enemy - A is now enemy type
	dec a		; enemy types are stored 0..7 on the map
	ld e,a		; convert enemy number to 16-bit value
	ld d,0		;
	ld hl,nmesta	; point to enemy stat table
	add hl,de	; advance ...
	add hl,de	; ... to entry for this enemy type
	ld a,(hl)	; take enemy strength
	inc hl		; point to enemy agility
	add a,(hl)	; add that to strength
	ld (ix+$01),a	; store that in enemy table
	call rand16	; generate a random number for initial behaviour
	ld a,(randsd)	; load it into accumulator
	bit 0,a		; is LSB a zero?
	jr nz,strbeh	; no, the enemy is wandering
	xor a		; yes, the enemy is sleeping
.strbeh	ld (ix+$02),a	; store the value
	inc hl		; point to carry
	ld a,(randsd+1)	; load upper byte of random number
	push de		; store enemy number offset
	ld d,a		; put random number as divisor
	ld e,$03	; a number 0..2 is needed now
	call div8	; produce it
	ld a,(nmeagr)	; look at average enemy aggression for this level
	add a,e		; add the random number
	dec a		; decrease by 1 giving a value a-1..a+1
	ld (ix+$03),a	; store aggression for this enemy
	pop de		; retrieve enemy number offset
	ld a,e		; restore enemy number
	add a,a		; multiply by 16
	add a,a		;
	add a,a		;
	add a,a		;
	or $80		; set the "enemy" bit for the map block
	pop hl		; retrieve the block address
	ld (hl),a	; put the enemy on the map
	ld e,$04	; point to next entry in the enemy table
	add ix,de	;
	djnz pl_nme	; continue until all enemies placed

	; check whether certain items are in the inventory
	ld hl,herinv	; point to the inventory
	ld b,$0c	; there are twelve slots
	ld c,0		; initialise check to 0
.chkinv	ld a,(hl)	; what is in the current inventory slot?
	cp $0c		; is it a wand?
	jr nz,chkaml	; no, on to check for amulet
	set 7,c		; set wand bit
.chkaml	cp $0b		; is it an amulet?
	jr nz,chkirn	; no, on to check for scroll
	set 6,c		; set amulet bit
.chkirn	cp $09		; is it an iron shield?
	jr nz,chkwds	; no, on to check for a wood shield
	set 5,c		; set iron shield bit
.chkwds	cp $08		; is it a wooden shield?
	jr nz,chkaxe	; no, on to check for an axe
	set 4,c		; set wood shield bit
.chkaxe	cp $07		; is it an axe?
	jr nz,chkswd	; no, on to check for a sword
	set 3,c		; set the axe bit
.chkswd	cp $06		; is it a sword?
	jr nz,chkdag	; no, on to check for a dagger
	set 2,c		; set sword bit
.chkdag	cp $05		; is it a dagger?
	jr nz,chkpot	; no, on to check for a potion
	set 1,c		; set dagger bit
.chkpot	cp $04		; is it a potion?
	jr nz,chknxt	; no, on to the next bit
	set 0,c		; set the potion bit
.chknxt	inc hl		; look at next inventory slot
	djnz chkinv	; continue checking until done
	ld a,c		; store quick inventory
	ld (qk_inv),a	;

	; build list of items for this level
	ld hl,itmlst	; point to the item list
	ld b,6		; there are six items per level
	; consider adding a wand
.addwnd	ld a,(qk_inv)	; look at the quick inventory
	and $80		; is there a wand already?
	jr nz,addaml	; yes, on to look at an amulet
	ld (hl),$0c	; add a wand
	inc hl		; look at next item slot
	dec b		; there is one fewer item slot
	jr z,donad0	; done adding if no slots left
	; consider adding an amulet
.addaml	ld a,(nmemax)	; what's the largest enemy?
	cp $05		; are cadavers present?
	jr c,addscr	; no, on to look at scrolls
	ld a,(qk_inv)	; look at the quick inventory
	and $40		; is there an amulet already?
	jr nz,addscr	; yes, on to look at scrolls
	ld (hl),$0b	; add an amulet
	inc hl		; look at next item slot
	dec b		; there is one fewer item slot
.donad0	jr z,donad1	; done adding if no slots left
	; consider adding a scroll
.addscr	ld a,(nmemax)	; what's the largest enemy?
	cp $06		; are skeletons present?
	jr c,addirn	; no, on to look at shields
	ld (hl),$0a	; add a scroll
	inc hl		; look at next item slot
	dec b		; there is one fewer item slot
.donad1	jr z,donad2	; done adding if no slots left
	; consider adding an iron shield
.addirn	ld a,(nmemax)	; what's the largest enemy?
	cp $05		; are cadavers present?
	jr c,addwds	; no, on to look at a wooden shield
	ld a,(qk_inv)	; look at the quick inventory
	and $20		; is there an iron shield already?
	jr nz,addaxe	; yes, on to look at weaponry
	ld (hl),$09	; add an iron shield
	inc hl		; look at next item slot
	dec b		; there is one fewer item slot
.donad2	jr z,donad3	; done adding if no slots left
	jr addaxe	; otherwise on to weapons - don't want two shields
	; consider adding a wooden shield
.addwds	ld a,(nmemax)	; what's the largest enemy?
	cp $03		; are arachnids present?
	jr c,addaxe	; no, on to look at an axe
	ld a,(qk_inv)	; look at the quick inventory
	and $30		; is there a shield of some sort already?
	jr nz,addaxe	; yes, on to look at weaponry
	ld (hl),$08	; add a wooden shield
	inc hl		; look at next item slot
	dec b		; there is one fewer item slot
.donad3	jr z,mapitm	; done adding if no slots left
	; consider adding an axe
.addaxe	ld a,(nmemax)	; what's the largest enemy?
	cp $06		; are skeletons present?
	jr c,addswd	; no, on to look at a sword
	ld a,(qk_inv)	; look at the quick inventory
	and $08		; is there an axe already?
	jr nz,addpot	; yes, on to look at potions
	ld (hl),$07	; add an axe
	inc hl		; look at next item slot
	dec b		; there is one fewer item slot
	jr z,mapitm	; done adding if no slots left
	jr addpot	; done adding weapons, on to potion
	; consider adding a sword
.addswd	ld a,(nmemax)	; what's the largest enemy?
	cp $04		; are serpents present?
	jr c,adddag	; no, on to look at a dagger
	ld a,(qk_inv)	; look at the quick inventory
	and $0c		; is there an axe or sword already?
	jr nz,addpot	; yes, on to look at potions
	ld (hl),$06	; add a sword
	inc hl		; look at next item slot
	dec b		; there is one fewer item slot
	jr z,mapitm	; done adding if no slots left
	jr addpot	; otherwise done adding weapons, on to potion
	; consider adding a dagger
.adddag	ld a,(qk_inv)	; look at the quick inventory
	and $0e		; is there a blade of some sort already?
	jr nz,addpot	; yes, on to look at a potion
	ld (hl),$05	; add a dagger
	inc hl		; look at next item slot
	dec b		; there is one fewer item slot
	jr z,mapitm	; done adding if no slots left
	; add a potion
.addpot	ld (hl),$04	; add a potiom
	inc hl		; look at next item slot
	dec b		; there is one fewer item slot
	jr z,mapitm	; done adding if no slots left
	ld a,(nmemax)	; what's the largest enemy?
	cp $08		; are daemons present?
	jr nz,addapl	; no, on to apples
	ld (hl),$04	; add another potiom
	inc hl		; look at next item slot
	dec b		; there is one fewer item slot
	jr z,mapitm	; done adding if no slots left
	; add apples
.addapl	call rand16	; get a random number
	ld a,(randsd)	; what is it?
	and $03		; reduce to a number 0..3
.apl_lp	jr z,addgld	; on to adding gold if no apples to add
	ld (hl),$03	; add an apple
	inc hl		; look at next item slot
	dec b		; there is one fewer item slot
	jr z,mapitm	; done adding if no slots left
	dec a		; there is one less applet to add
	jr apl_lp	; continue adding apples till none left
	; add gold
.addgld	ld c,$01	; by default, we award a purse of gold
	call rand16	; get a random number
	ld a,(randsd)	; load the random number ...
	ld d,a		; ... as divisor
	ld e,23		; load 23 as dividend
	call div8	; convert E to number 2..24
	inc e		; 
	inc e		; 
	ld a,(glevel)	; what level are we?
	cp e		; compare level to random number
	jr c,addgl0	; if random number greater than level, leave as purse
	inc c		; otherwise upgrade to casket
.addgl0	ld (hl),c	; add the gold to the item list
	inc hl		; point to next item slot
	djnz addgld	; continue adding gold till item list is full

	; place chosen items on the map
.mapitm	ld hl,itmlst	; point HL to the item list
	ld ix,nmetbl	; point IX to the enemy table
	ld b,4		; four items will be placed under enemies
	ld d,0		; zero top byte of location offset
.mapit0	ld a,(hl)	; what is the next item to place?
	ld e,(ix+00)	; what location is this enemy?
	push hl		; store HL temporarily
	ld hl,lvlmap	; point HL to level map
	add hl,de	; add the location offset
	or (hl)		; OR item with location
	ld (hl),a	; store altered value
	and $70		; isolate enemy type
	jr z,mapi_n	; it's a bat - leave behaviour alone
	cp $60		; is it a spectre?
	jr z,map_gd	; yes, so it can't carry and must guard this item
	cp $40		; is it otherwise humanoid?
	jr nc,mapi_n	; yes, so it can carry things - leave behaviour alone
.map_gd	ld (ix+$02),0	; set the enemy to guard the item placed with it
.mapi_n	pop hl		; retrieve item list
	inc hl		; point to next item
	ld e,$04	; enemy entry is four bytes
	add ix,de	; point to next enemy
	djnz mapit0	; continue placing items with enemies till done
	ld b,2		; another two items are placed in the open
.mapit1	ld c,(hl)	; check what the object is
	push hl		; store item pointer for later retrieval
	call randbl	; find a random empty block
	set 4,c		; set the item bit of C
	ld (hl),c	; store item on map
	pop hl		; retrieve item pointer
	inc hl		; next item
	djnz mapit1	; continue placing item in the open till done

	; draw the initial view of the level
	call shwlvl	; show level number
	call mapclc	; calculate what part of the map should be shown
	call mapdrw	; draw it
	ld hl,msgitm	; point to blank message
	call msgprt	; print it
	jp moves	; on to movement loop

	;
	; Subroutines
	;

	; calculate map location for a particular cell
	; inputs:
	;   A = cell number, 0..8
	; outputs:
	;   A = map location, $00..$ff
.cl_loc	push bc		; store registers about to be corrupted
	push de		;
	ld d,a		; calculate coordinates
	ld e,$03	;
	call div8	; D now contains Y coordinate and E contains X
	xor a		; start at top left of map
	ld b,$50	; multiply Y coordinate by 80
.cl_row	add a,d		;
	djnz cl_row	;
	ld b,$05	; add X coordinate times 5
.cl_col	add a,e		;
	djnz cl_col	;
	pop de		; retrieve corrupted registers
	pop bc		;
	ret		; all done

	; chose a random currently empty block on the map
	; outputs:
	;   (D)E = block location
	;   HL = pointer to block in level map memory
.randbl	call rand16	; generate a random number
	ld a,(randsd)	; what is it?
	ld d,0		; make it into an offset
	ld e,a		; 
	ld hl,lvlmap	; point to the level map
	add hl,de	; advance pointer to the chosen square
	ld a,(hl)	; what is there?
	cp $10		; is it open ground?
	jr nz,randbl	; no, so choose another square
	ret		; all done

	; prepare level message
.shwlvl	push bc		; preserve registers to be corrupted
	push de		;
	push hl		;
	ld a,(glevel)	; what is the level again?
	ld l,a		; convert to a 16-bit number
	ld h,0		;
	ld de,lvldig	; point to first level digit in message
	ld bc,10	; work out the tens
	call digit	;
	ld a,l		; work out the last digit
	add $30		;
	ld (de),a	; store in the message
	dec de		; point back to start of level message
	ex de,hl	; move this pointer into HL
	ld de,$4012	; point to digits in level heading on screen
	ld b,$02	; we want to show the two characters
	call msgprc	; print the characters on the level heading
	pop hl		; restore corrupted registers
	pop de		;
	pop bc		;
	ret		; all done
	; the level heading digits
.lvldig	defm "01"	; set initially at "01" for first level

	;
	; Data
	;

	; cell layout data
.celord	defb $00,$01,$02,$03,$04,$05,$06,$07,$08 ; cell order
.celmap	defs 9		; cell map data, bits 7-C000NSWE-0 C=Chamber
.wkcell	defs 4		; cell workspace

	; item data
.qk_inv	defs 1		; quick inventory
.itmlst	defs 6		; temporary item list for this level

	; direction table
.dirtbl	defb $f0,$10,$ff,$01 ; 8-bit offsets for N, S, W, E

	; enemy stat table
.nmesta	defb $02,$06	; bat strength/agility
	defb $06,$04	; vermin strength/agility
	defb $06,$06	; arachnid strength/agility
	defb $08,$06	; serpent strength/agility
	defb $08,$08	; cadaver strength/agility
	defb $08,$0a	; skeleton strength/agility
	defb $0a,$0a	; spectre strength/agility
	defb $0a,$0c	; daemon strength/agility
