	;
	; Ossuary - an adventure game for the Sinclair ZX Spectrum
	; Assembler code for making noises
	;
	; If these routines are to be called for more than 1/50 second, then
	; interrupts should be disabled first.  NOISE and TONE may be called
	; for brief periods between interrupts.
	;
	; Copyright (C) Damian Walker 2012
	; Created 15-Dec-2012 for Intergalactic Space Rescue
	; Modified 01-Mar-2013
	;

	;
	; Generic noise and tone routines
	;

	; pseudo-random noise
	; inputs:
	;   H = pitch, or delay between clicks
	;   L = length of sound, in clicks
.noise	push af		; store registers about to be corrupted
	push bc		;
	push de		;
	ld c,l		; initialise counter for sound length
	ld de,(noisea)	; pick up noise data from where we left off
.noislp	ld a,(de)	; load byte for noise
	and $18		; isolate bits that deal with sound
	out ($fe),a	; output the sound
	ld b,h		; initialise the delay between clicks
.noisdl	djnz noisdl	; count down
	inc de		; point to next data
	dec c		; decrement counter for sound length
	jr nz,noislp	; continue making sound till done
	ld a,d		; check high bit of noise address
	and $1f		; ensure it stays within the lower ROM
	ld d,a		;
	ld (noisea),de	; store current noise address for next time
	pop de		; retrieve uncorrupted register values
	pop bc		;
	pop af		;
	ret		; all done
	; data
.noisea	defw $0000	; address of random data to be used as noise

	; constant tone
	; inputs:
	;   H = pitch, or delay between clicks
	;   L = length of sound, in clicks
.tone	push af		; store registers about to be corrupted
	push bc		;
	ld c,l		; initialise counter for sound length
	xor a
.tonelp	out ($fe),a	; output the sound
	xor $18		; toggle speaker bits
	ld b,h		; initialise the delay between clicks
.tonedl	djnz tonedl	; count down
	dec c		; decrement counter for sound length
	jr nz,tonelp	; continue making sound till done
	pop bc		;
	pop af		;
	ret		; all done

	;
	; Noises specific to this game
	;

	; a hit in combat
.hitsnd	push hl		; preserve registers to be corrupted
	ld hl,$800c	; medium pitched noise
	call noise	; make the noise
	pop hl		; restore corrupted registers
	ret		; all done

	; a kill in combat
.kilsnd	push hl		; preserve registers to be corrupted
	ld hl,$800c	; medium pitched tone
	call tone	; play the tone
	ld hl,$c00c	; lower pitched tone
	call tone	; play the tone
	pop hl		; restore corrupted registers
	ret		; all done

	; some inventory action
.invsnd	push hl		; preserve registers to be corrupted
	ld hl,$ff0c	; low-pitched noise
	call noise	; make the noise
	pop hl		; restore corrupted registers
	ret		; all done

	; descending the stairs
.dessnd	push bc		; preserve registers to be corrupted
	push hl		;
	ld hl,$800c	; medium pitched noise
	ld c,4		; four steps
.dess_0	call noise	; make the noise
	ld b,16		; delay for 1/3 second
.dess_1	halt		; delay halt
	djnz dess_1	; continue delaying till done
	ld a,h		; make the pitch lower
	add $20		;
	ld h,a		;
	dec c		; count down the steps
	jr nz,dess_0	; next step
	pop hl		; restore corrupted registers
	pop bc		;
	ret		; all done

	; the clink of gold
.gldsnd	push hl		; preserve registers to be corrupted
	ld hl,$2020	; high-pitched tone
	call tone	; play the tone
	ld hl,$4020	; another high-pitched tone
	call tone	; play the tone
	pop hl		; restore corrupted registers
	ret		; all done
