	;
	; Intergalactic Space Rescue - a puzzle game for the 16K ZX Spectrum
	; Assembler code for game-wide variables and constants
	;
	; This routines generates a 16-bit random number. It has been adapted
	; from code in the public domain.
	;
	; Created 26-Nov-2012 for Barbarians
	; Imported 13-Dec-2012 to Intergalactic Space Rescue
	; Modified 30-Jan-2013 for Ossuary
	;
	; Copyright (C) Damian Walker 2012
	;

	; 16-bit Random number generator slightly modified from PD
	;   constant RANDSD = address of seed and generated random number
.rand16	push de		; store DE on stack
	push hl		; store HL on stack
	ld de,(randsd)	; seed should have been set from timer or some such
	ld a,d		; load A from seed high
	ld h,e		; load H from seed low
	ld l,$fd	; load L with 253
	or a		; reset carry flag
	sbc hl,de	; subtract seed from HL
	sbc a,0		; subtract carry from A
	sbc hl,de	; subtract seed from HL again
	ld d,0		; clear D
	sbc a,d		; subtract carry from A again
	ld e,a		; load D with A
	sbc hl,de	; subtract (D)E from HL
	jr nc,rand	; if HL positive, set random number now
	inc hl		; otherwise increase HL first
.rand	ld (randsd),hl	; save over seed
	pop hl		; retrieve HL
	pop de		; retrieve DE
	ret		; return
