	;
	; Ossuary - an adventure game for the Sinclair ZX Spectrum
	; Assembler code for the arithmetic routines
	;
	; Copyright (C) Damian Walker 2012
	; Created 15-Dec-2012 for Intergalactic Space Rescue
	; Imported 30-Jan-2013 to Ossuary
	;

	; Integer 8-bit division
	; inputs:
	;   D = divisor
	;   E = dividend
	; outputs:
	;   D = quotient
	;   E = remainder
.div8	ld a,d		; move divisor to accumulator
	ld d,0		; initialise quotient
.div8lp	sub e		; loop - subtract dividend from divisor
	jr c,div8dn	; quit if we're below zero
	inc d		; otherwise increment quotient ...
	jr div8lp	; ... and go to subtract again
.div8dn	add e		; restore remainder
	ld e,a		; store remainder in E
	ret		; all done

	; Integer 16-bit division
	; inputs:
	;   HL = divisor
	;   DE = dividend
	; outputs:
	;   HL = remainder
	;   DE = quotient
.div16	push bc		; store BC as we'll be using it as the quotient
	ld bc,0		; initialise the quotient
	or a		; reset the carry flag
.div16r	sbc hl,de	; loop - subtract dividend from divisor
	jr c,div16d	; quit if we're below zero
	inc bc		; otherwise increment quotient ...
	jr div16r	; ... and go to subtract again
.div16d	add hl,de	; restore remainder
	ld d,b		; move quotient to DE
	ld e,c		;
	pop bc		; restore BC
	ret		; all done

	; calculate ASCII digit
	; inputs:
	;   BC = digit to calculate (1000, 100, 10, 1)
	;   DE = address to save digit's ASCII value
	;   HL = number we're interested in - should be less than 10*BC
	; outputs:
	;   A = ASCII value of digit
	;   DE = location to save next digit, if any
	;   (DE) = ASCII value of digit
.digit	xor a		; initialise counter
.tstdig	sbc hl,bc	; subtract column from value
	jr c,savdig	; save digit if we've gone negative
	inc a		; otherwise increase digit counter
	jr tstdig	; subtract again
.savdig	add hl,bc	; pull our subject value back out of the negative
	add a,$30	; turn counter into an ASCII digit
	ld (de),a	; save this digit
	inc de		; prepare to save next digit, if called again
	ret		; all done - return

	; calculate distance between two locations on a 16x16 grid
	; inputs:
	;   D = first location
	;   E = second location
	; outputs:
	;   A = distance between them
.calcds	push bc		; store registers before we corrupt them
	push hl		;
	ld h,$f0	; calculate the Y axis difference first
	call calcax	;
	srl a		;
	srl a		;
	srl a		;
	srl a		;
	ld b,a		; store Y distance in B
	ld h,$0f	; then calculate the X axis difference
	call calcax	;
	add a,b		; add the differences, giving the total distance
	pop hl		; restore corrupted registers
	pop bc		;
	ret		; all done

	; calculate distance along one axis
	; inputs:
	;   D = first location
	;   E = second location
	;   H = mask for isolating the axis
	; outputs:
	;   A = distance between them
.calcax	ld a,d		; look at the first location
	and h		; isolate the correct axis
	ld c,a		; put it aside
	ld a,e		; look at the second location
	and h		; isolate the correct axis
	sub c		; calculate the difference
	jr nc,ax_ret	; skip complement if difference is positive
	cpl		; otherwise make it positive
	inc a		;
.ax_ret	ret		; all done

	; armithmetic IF
	; inputs:
	;   A = number to compare
	;   B = number to compare with
	; outputs:
	;   C = sign of comparison (-1 for A<B, 0 for A=B, 1 for A>B)
.aritif	ld c,-1		; start with assumption A<B
	cp b		; is it?
	jr c,alessb	; yes, leave C as -1
	jr z,aequlb	; no, A=B so jump to inc C once
	inc c		; no, A>B so increment C twice
.aequlb	inc c		;
.alessb	ret		; done

	; extend an 8-bit signed value to 16 bits
	; inputs:
	;   A = 8-bit signed value
	; outputs:
	;   DE = 16-bit signed value
.ext816	ld e,a		; transfer 8-bit value to LSB
	ld d,0		; assume MSB is 0 (positive)
	cp $80		; and if entry value IS positive ...
	jr c,ext_dn	; ... that's enough, on to finish
	dec d		; otherwise make MSB -1 (negative)
.ext_dn	ret		; all done