	;
	; Ossuary - an adventure game for the Sinclair ZX Spectrum
	; Code for end game presentation
	;
	; Copyright (C) Damian Walker 2013
	; Created 16 Feb 2013
	;

	;
	; Main end game routines
	;

	; see who has won first
.endgam	ld a,(hero_h)	; what is the hero's health?
	or a		; is the hero dead?
	jr z,endlos	; yes, so this is a loss
	; the player has won
	ld hl,vicmsg	; point to victory message
	jr shoend	; on to display it
	; loss of the game - display message
.endlos	ld hl,deadms	; point to "you are dead"
	; show end of game message
.shoend	ld b,50		; instigate a pause so the last message can be read
.end_ps	halt		; wait one interrupt clock tick
	djnz end_ps	; continue waiting till 50 interrupts passed
	call endmsg	; show the end message
	; wait for fire and begin anew
	ld hl,firmsg	; point to "press fire" message
	call msgprt	; print it in the normal place
	call ctlrel	; ensure no controls are activated
.endfir	call ctlact	; now wait for fire to be pressed
	bit 4,a		;
	jr z,endfir	;
	jp newgam	; start a new game

	;
	; Subroutines
	;

	; display end-game message
	; inputs:
	;   HL = pointer to message
.endmsg	push bc		; preserve registers about to be corrupted
	push de		;
	ld de,$482c	; point to upper half of message area on screen
	ld b,8		; there are eight characters
	call msgprc	; print these characters
	ld de,$484c	; point to lower half of message area on screen
	ld b,8		; there are eight characters
	call msgprc	; print these characters
	ld hl,$592c	; point to attributes of printed message
	ld (hl),$46	; make first character bright yellow
	push hl		; point to next location on
	pop de		;
	inc de		;
	ld bc,7		; fill in remaining 5 bytes of top line
	ldir		;
	ld de,$5953	; point to end of second line
	ld bc,8		; fill in 6 bytes of bottom line
	lddr		;
	pop de		; restore values of corrupted registers
	pop bc		;
	ret		; all done

	;
	; Data
	;

	; end-game messages
.deadms	defm "YOU HAVE  DIED! "
.vicmsg	defm "YOU HAVE  WON!  "
.firmsg	defm "FIRE RESTARTS..."
