	;
	; Ossuary - an adventure game for the Sinclair ZX Spectrum
	; Code for the inventory system
	;
	; Copyright (C) Damian Walker 2013
	; Created 16 Feb 2013
	;

	; entry point for the inventory subsystem
.invent	ld a,(lstitm)	; what was the last item referenced?
	ld c,a		; make this the current item number

	; highlight current item and wait for control
.browse	call invadr	; get inventory item address
	ld a,(hl)	; what is there?
	call invnam	; get inventory item name
	call msgprt	; print it
	ld b,$18	; choose magenta paper
	call hi_inv	; highlight the item
	call ctlrel	; ensure no controls are pressed
	call ctlact	; wait for control to be pressed
	ld b,$00	; choose black paper
	call hi_inv	; unhighlight the item

	; act upon a player's control selection
	ld a,(ctlopt)	; recall the control option chosen
	bit 4,a		; is FIRE activated?
	jr nz,invmnu	; yes, bring up the menu
	cp $08		; is UP activated?
	jr z,inv_up	; yes, move up
	cp $04		; is DOWN activated?
	jr z,inv_dn	; yes, move down
	cp $02		; is LEFT activated?
	jr z,inv_lt	; yes, move left
	cp $01		; is RIGHT activated?
	jr z,inv_rt	; yes, move right
	jr browse	; otherwise it's an invalid control, continue browsing

	; movement up, down, left, right
.inv_up	ld a,$01	; cannot move up from slot 0 or 1
	cp c		; is current slot below this?
	jr nc,browse	; no, so ignore move
	dec c		; move up
	dec c		;
	jr browse	; continue browsing
.inv_dn	ld a,$09	; cannot move down from slot below 9
	cp c		; is current slot below this?
	jr c,browse	; yes, so ignore move
	inc c		; move down
	inc c		;
	jr browse	; continue browsing
.inv_lt	res 0,c		; move to the left
	jr browse	; continue browsing
.inv_rt	set 0,c		; move to the right
	jr browse	; continue browsing

	;
	; Subroutines
	;

	; get inventory item address
	; inputs:
	;   C = inventory slot number (preserved)
	; outputs:
	;   HL = address of inventory item
.invadr	push bc		; preserve contents of B(C)
	ld b,0		; convert C into 16-bit offset
	ld hl,herinv	; point HL to the first inventory item
	add hl,bc	; add the offset
	pop bc		; retrieve value of B(C)
	ret		; done

	; get the name of an item in the inventory
	; inputs:
	;   A = item code
	; outputs:
	;   HL = pointer to item name
.invnam	push de		; preserve registers about to be corrupted
	add a,a		; multiply by 16 giving a message offset
	add a,a		;
	add a,a		;
	add a,a		;
	ld d,0
	ld e,a		; convert to 16-bit offset (D contains 0)
	ld hl,msgitm	; point to item messages
	add hl,de	; advance pointer to message for this item
	pop de		; restore uncorrupted register values
	ret		; all done
