	;
	; Ossuary - an adventure game for the Sinclair ZX Spectrum
	; Code for movement of the hero and his enemies
	;
	; Copyright (C) Damian Walker 2013
	; Created 05 Feb 2013
	;

	;
	; Main Routines
	;

	; main movement loop
.moves	call ctlrel	; ensure no controls are pressed
	jr getact	; skip timed delay
.moved	call ctldel	; wait till controls released or half second passed
.getact	call ctlact	; wait for control to be pressed
.inimsg	ld hl,msgitm	; by default, the message will be blank
	ld (wk_msg),hl	;

	; act upon a player's control selection
	bit 4,a		; is fire pressed?
	jp nz,menu	; yes, bring up the menu
	call movdir	; ascertain movement direction
	jr nz,moves	; otherwise diagonal, reject
	call hermov	; attempt to move the hero
	jr c,moves	; moving into wall, reject
	ld a,(necroh)	; is necromancer still alive?
	or a		;
	jr z,movupd	; no, so update screen

	; move enemies
.emoves	ld ix,nmetbl	; point to the start of the enemy table
	ld b,8		; there are eight enemies
.emov_0	call nmemov	; move a single enemy
	ld de,$0004	; length of enemy table entry
	add ix,de	; point to next enemy
	djnz emov_0	; continue moving till all enemies moved

	; control necromancer
	ld a,(glevel)	; what level are we on?
	cp 24		; is this the necromancer's level?
	jr nz,movupd	; no, so update screen
	call necroc	; control the necromancer

	; update the display after enemies have moved
.movupd	ld hl,(wk_msg)	; load pointer to final message
	ld c,$16	; choose dark yellow on red ...
	call msgatr	; ... to restore the message bar
	call msgprt	; print the final message
	call mapclc	; re-centre the map on the hero's new location
	call mapdrw	; draw the map

	; check for game over
	ld a,(hero_h)	; what is the hero's health?
	or a		; is it zero?
	jp z,endgam	; yes, so end game
	ld a,(necroh)	; what is the necromancer's health?
	or a		; is it zero?
	jp z,endgam	; yes, so end game
	jr moved	; otherwise repeat loop

	;
	; Subroutines
	;

	; ascertain direction of movement
	; inputs:
	;   A = controls
	; outputs:
	;   F(Z) = NZ if no matching control
	;   BC = 16-bit directional offset
.movdir	cp $08		; is up activated?
	jr z,dir_up	; yes, accept
	cp $04		; is down activated?
	jr z,dir_dn	; yes, accept
	cp $02		; is left activated?
	jr z,dir_lt	; yes, accept
	cp $01		; is right activated?
	jr z,dir_rt	; yes, accept
	ret		; return NZ if none of the controls matches
	; determine offset for selected direction
.dir_up	ld bc,$fff0	; look up
	ret		; done
.dir_dn	ld bc,$0010	; look down
	ret		; done
.dir_lt	ld bc,$ffff	; look left
	ret		; done
.dir_rt	ld bc,$0001	; look right
	ret		; done

	; move the hero
	; inputs:
	;    BC = direction to move
	; outputs:
	;    (WK_MSG) = pointer to message
.hermov	push de		; preserve registers to be corrupted
	push hl		;
	push ix		;
	; check what's in the square
	ld hl,lvlmap	; point to level map
	ld a,(hero_l)	; check the hero location
	ld e,a		; convert to 16-bit offset
	ld d,0		;
	add hl,de	; look at hero
	add hl,bc	; then look in chosen direction
	ld a,(hl)	; what's in the square?
	cp $04		; is it a wall?
	jp c,hmv_dn	; yes, so ignore the move
	cp $30		; is the necromancer there?
	jp z,attnec	; yes, so attack him
	cp $20		; is there someone in the way?
	jp nc,attack	; yes, so attack them
	; put the hero in the block
.noattk	xor $30		; toggle hero and item bits
	ld (hl),a	; store hero in the block
	; remove the hero from his previous location
	sbc hl,bc	; look back at the hero square
	ld a,(hl)	; see what's there 
	xor $30		; toggle hero and item bits
	ld (hl),a	; store new value
	; update the hero location
	ld a,(hero_l)	; retrieve the hero location
	add c		; add 8-bit offset
	ld (hero_l),a	; store again
	; update the message
	add hl,bc	; look at the hero again
	ld a,(hl)	; what is in his block?
	and $0f		; isolate the item if any
	cp $0f		; is it stairs?
	jr nz,nostrs	; no, skip adjustment
	sub $02		; yes, adjust the value
.nostrs	add a,a		; multiply by 16 giving a message offset
	add a,a		;
	add a,a		;
	add a,a		;
	ld d,0
	ld e,a		; convert to 16-bit offset (D contains 0)
	ld hl,msgitm	; point to item messages
	add hl,de	; advance pointer to message for this item
	ld (wk_msg),hl	; store the pointer to the message
	jp hmv_dn	; finish moving
	; player attack upon an enemy - first ascertain which enemy
.attack	ld ix,nmetbl	; point to start of enemy table
	ld a,e		; recall hero location
	add c		; add direction
	ld de,4		; each enemy entry is four bytes
.attk_0	cp (ix+$00)	; is this monster at that location?
	jr z,attk_1	; yes, enemy found
	add ix,de	; otherwise look at next enemy
	jr attk_0	; continue searching till found
.attk_1	inc (ix+$03)	; make enemy more aggressive
	jr nz,attk_2	; skip next step if not zero
	dec (ix+$03)	; otherwise put back to $FF
.attk_2	push hl		; store enemy location on the stack
	ex de,hl
	; check for banish spell
	ld a,(de)	; what's the enemy?
	and $60		; isolate the relevant bits
	cp $60		; is this a spectre or a daemon?
	jr nz,notban	; not spectre or daemon, on to attack physical enemy
	ld a,$0a	; first check for a banish scroll
	ld hl,herinv	; point to first item of inventory
	cp (hl)		; is it a scroll?
	jp z,at_ban	; yes, go to attempt banishment
	inc hl		; otherwise look at second item of inventory
	cp (hl)		; is that a scroll?
	jp z,at_ban	; yes, go to attempt banishment
	; get hero attack value
.notban	call heratt	; get hero attack value
	or a		; is it above zero?
	jp z,atmiss	; yes, on to store attack value in combat table
	ld hl,cbttbl	; point to combat table
	ld (hl),a	; store attack value
	; set up enemy defence
	inc hl		; point to combat table, defence chance
	pop de		; retrieve pointer to enemy on map
	push de		; preserve again pointer to enemy on map
	ld a,(de)	; what's at the enemy location?
	and $70		; isolate the enemy type
	srl a		; convert to offset in enemy stat table
	srl a		;
	srl a		;
	ld d,0		; convert to a 16-bit offset
	ld e,a		;
	push hl		; preserve pointer to combat table
	ld hl,nmesta	; point to enemy stat table
	add hl,de	; point to appropriate enemy stat entry
	inc hl		; point to defence
	ld a,(hl)	; load the defence
	pop hl		; retrieve combat table pointer
	ld (hl),a	; store defence value in combat table
	; resolve combat
.at_cbt	call combat	; resolve this combat round
	or a		; check if damage is zero
	jr z,atmiss	; yes, so this is a miss
	ld d,a		; store damage in D
	; apply damage to enemy
	ld a,(ix+$01)	; what is the health?
	sub d		; subtract from it the damage we caused
	jr c,atkill	; jump to kill if appropriate
	jr z,atkill	;
	ld (ix+$01),a	; otherwise update enemy health
	; prepare and print the "YOU HIT XXXXXXXX" message
	pop hl		; retrieve pointer to enemy on map
	ld a,(hl)	; what is in the enemy square?
	ld de,uhitms+8	; point to enemy name in forthcoming message
	call cpynam	; copy its name
	ld hl,uhitms	; point to the filled-in message
	call hitsnd	; play the "hit" sound
	jp attend	; on to finish attacking
	; register a kill
.atkill	ld (ix+$01),0	; store 0 in enemy health ...
	ld (ix+$00),0	; ... and enemy location
	pop hl		; retrieve pointer to enemy's block from stack
	ld a,(hl)	; what is in the block?
	ld c,a		; store this for a moment
	and $0f		; preserve only the item they're standing by
	or $10		; set the item bit
	ld (hl),a	; write that back to the map
	; experience points
	ld a,(exp_pt)	; load current experience points
	inc a		; increment experience
	cp $18		; have we killed enough monsters?
	jr nz,attexp	; no, so on to store experience
.chsinc	call rand16	; choose random stat to increase
	ld a,(randsd)	; take 8-bit value
	ld d,a		; make this the divisor
	ld e,3		; a number 0..2 is needed
	call div8	; now E contains 0..2
	ld d,0		; turn into a 16-bit offset
	ld hl,hero_s	; point to hero strength
	add hl,de	; advance pointer to chosen stat
	ld a,$0c	; 12 is the maximum for any stat
	cp (hl)		; is the stat already maxed out?
	jr z,chsinc	; yes, so choose another random stat.
	inc (hl)	; otherwise increment the stat
	ld hl,hero_h	; point to health
	inc (hl)	; increment it
	call drstat	; redisplay stats
	xor a		; experience restarts at 0
.attexp	ld (exp_pt),a	; store experience points
	; prepare and print the " KILLED XXXXXXXX" message
	ld a,c		; retrieve former value of block
	ld de,ukilms+8	; point to enemy name in forthcoming message
	call cpynam	; find and copy the enemy's name
	ld hl,ukilms	; point to the filled-in message
	call kilsnd	; play the "kill" sound
	jr attend	; on to finish attacking
	; register a miss
.atmiss	pop hl		; retrieve pointer to enemy from stack
	ld a,(hl)	; what is in this block?
	ld de,umisms+8	; point to enemy name in forthcoming message
	call cpynam	; find and copy enemy's name
	ld hl,umisms	; point to filled-in message
	jr attend	; on to finish attacking
	; cast a banish spell
.at_ban	call dice	; roll the dice
	cp $08		; is the result 8 or greater?
	jr nc,do_ban	; yes, so perform the banish spell
	cp $04		; is the result 4 or greater?
	jr nc,no_ban	; yes, so banish fails
	ld (hl),0	; otherwise, the spell is used up
	call dr_inv	; redraw the inventory
.no_ban	ld hl,ban_fl	; point to "banish failed" message
	jr dn_ban	; done banish spell
.do_ban	ld (ix+$01),0	; store 0 in enemy health ...
	ld (ix+$00),0	; ... and enemy location
	ld a,(de)	; what was there?
	and $0f		; remove the enemy
	or $10		;
	ld (de),a	; update the map
	ld hl,bansuc	; point to "banish succeeded" message
	call kilsnd	; play the "kill" sound
.dn_ban	pop de		; take enemy location off the stack and discard
	jr attend	; on to finish attack
	; attack the necromancer
.attnec	push hl		; store address of necromancer on map
	ld hl,cbttbl	; point to combat table, attack value
	call heratt	; determine hero's attack value
	ld (hl),a	; save attack value in combat table
	inc hl		; point to combat table, defence value
	ld (hl),12	; save 12 as the necromancer's defence value
	call combat	; resolve combat
	or a		; was any damage caused?
	jr z,ncmiss	; no, on to miss
	ld d,a		; set aside damage
	ld a,(necroh)	; what is the necromancer's health?
	sub d		; subtract damage
	jr z,ncdead	; check for necromancer death
	jr c,ncdead	;
	ld (necroh),a	; update the necromancer's health
	pop hl		; retrieve and discard necromancer map address
	ld hl,hitnec	; point to "hit necromancer" message
	jr attend	; on to finish attack
	; missed the necromancer
.ncmiss	pop hl		; retrieve and discard necromancer map address
	ld hl,missnc	; point to "missed necromancer" message
	jr attend	; on to finish attack
	; necromancer is dead
.ncdead	xor a		; ensure health is not negative
	ld (necroh),a	; update the necromancer's health
	pop hl		; retrieve and discard necromancer map address
	ld (hl),$10	; replace necromancer on map with empty path
	ld hl,kilnec	; point to "killed necromancer" message
	; finish off attacking enemy or necromancer
.attend	ld (wk_msg),hl	; save message pointer
	; all done
.hmv_dn	pop ix		; retrieve preserved register values
	pop hl		;
	pop de		;
	ret		; all done

	; move a single enemy
	; inputs:
	;   IX = pointer to enemy table
.nmemov	push bc		; store registers to be corrupted
	push de		;
	push hl		;
	; check to see if the enemy is alive
	xor a		; compare 0 with ...
	cp (ix+$01)	; ... enemy's current health
	jp z,nmedon	; if dead, go to next enemy
	; see how close the hero is to this enemy
	ld d,(ix+$00)	; take the enemy location
	ld a,(hero_l)	; and the hero location
	ld e,a		;
	call calcds	; calculate the distance
	cp (ix+$03)	; compare with the aggression level
	jr c,nmecha	; if distance less than aggression, chase
	jr z,nmecha	; if distance equal to aggression, chase
	; hero too distant - enemy goes about its ordinary business
	xor a		; set A to code for "sleep/guard"
	ld e,(ix+$02)	; load enemy's current orders
	cp e		; are these "sleep/guard"
	jp z,nmedon	; yes, so go to next enemy
	jr nmepth	; otherwise go on to calculate path
	; enemy is chasing the hero
.nmecha	set 7,(ix+$03)	; mark bit to signify that enemy is chasing hero
	ld a,(ix+$02)	; is the enemy already moving?
	jr nz,nmepth	; yes, so it will remember its orders
	ld a,(ix+$00)	; where is this enemy now?
	ld (ix+$02),a	; enemy will return here if it stops chasing
	; calculate enemy path from D to E
.nmepth	call watdir	; get direction of move
	or a		; is there any direction given?
	jp z,nmeblk	; choose a new path if enemy blocked
	ld c,a		; put aside the direction, we'll need it later
	; calculate pointers to current (HL) and destination (DE) blocks
	ld a,(ix+$00)	; get current location
	call mapadr	; calculate address of current location into HL
	ld a,(ix+$00)	; get current location again
	add a,e		; add directional offset
	ex de,hl	; put current address aside for the moment
	call mapadr	; calculate address of destination into HL
	ex de,hl	; now pointers DE=destination, HL=current
	; are we attacking the hero there?
	ld a,(de)	; what is in the destination square?
	and $f0		; isolate the relevant bits
	cp $20		; is this the hero code?
	jr nc,nmeatt	; yes, so attack the hero
	; are we taking object with us or leaving it?
	ld a,(hl)	; what is this creature?
	call chkcry	; check if the creature would carry on move
	jr nz,eleave	; no, so leave any object behind
	ld a,(de)	; what's in the destination square?
	and $0f		; isolate the object
	jr nz,eleave	; there's something there already, so leave object
	; move enemy from HL to DE carrying object with it
.ecarry	ld a,(hl)	; look at what's in the destination block
	ld (de),a	; copy everything into the destination
	ld (hl),$10	; leave nothing behind
	jr nmecor	; go to update the enemy coordinates
	; move enemy from HL to DE leaving object behind
.eleave	ld a,(hl)	; what is moving?
	and $f0		; isolate the enemy/enemy type bits
	ex de,hl	; temporarily swap registers so HL=destination
	xor (hl)	; merge open/item type bits with monster
	xor $10		; now A = moving enemy + destination item
	ld (hl),a	; store this in destination
	ex de,hl	; swap things back so HL is origin again
	ld a,(hl)	; what was there?
	and $0f		; erase the enemy from here
	or $10		; set the open bit
	ld (hl),a	; store this back to the origin
	; update the enemy coordinates
.nmecor	ld a,(ix+$00)	; remind us what the coordinates were
	add a,c		; apply the direction of movement to them
	ld (ix+$00),a	; store the updated coordinates
	jp nmedon	; on to clean up and return
	; enemy is blocked - find another route
.nmeblk	bit 7,(ix+$03)	; is the enemy chasing the hero?
	jp nz,nmedon	; yes, so retain its old orders
	ld a,(ix+$00)	; get current location
	call mapadr	; calculate address of current location into HL
	ld a,(hl)	; load contents of block
	and $0f		; is there an object here?
	jr z,nmeord	; no, so on to choose some other orders
	cp $0f		; are the stairs here?
	jr z,nmeord	; yes, so on to choose some other orders
	ld a,(hl)	; reload contents of enemy's block again
	call chkcry	; would the enemy be able to carry this?
	jr z,nmeord	; yes, so choose some other orders
	ld (ix+$02),0	; otherwise guard the object that's here
	jp nmedon	; on to next enemy
.nmeord	call randbl	; choose a random empty block to head for
	ld (ix+$02),e	; store as the enemy's orders
	jp nmedon	; all done
	; attack hero with enemy
.nmeatt	call mqueue	; print any queued message
	; fill in combat table
	ld a,(hl)	; what is attacking?
	and $70		; isolate the creature bits
	push hl		; store the pointer to the enemy on the map
	ld hl,nmesta	; point to enemy stats table
.nmea_0	jr z,nmea_1	; break loop if we've found the right enemy type
	inc hl		; otherwise look at next enemy type
	inc hl		;
	sub $10		; decrement enemy counter
	jr nmea_0	; continue till correct enemy type found
.nmea_1	ld a,(nmeagr)	; start with general enemy aggression
	dec a		; less 1, to start at 0 on first level
	add a,(hl)	; add the enemy attack strength
	ld (cbttbl),a	; store as attack value
	call herdef	; calculate hero's defence value
	ld (cbttbl+1),a	; store as defence chance
	; do combat and check results
	call combat	; resolve one round of combat
	or a		; check if damage is zero
	jr z,enmiss	; yes, so this is a miss
	ld c,a		; store damage
	ld a,(hero_h)	; what is the hero's health?
	sub c		; subtract from it the damage we caused
	jr c,enkill	; jump to kill if appropriate
	jr z,enkill	;
	ld (hero_h),a	; otherwise update enemy health
	; prepare and print the "XXXXXXXX HIT YOU" message
	pop hl		; retrieve pointer to enemy on map
	ld a,(hl)	; what is in the enemy square?
	ld de,ehitms	; point to enemy name in forthcoming message
	call cpynam	; copy its name
	ld hl,ehitms	; point to the filled-in message
	call hitsnd	; play the "hit" sound
	jr nmaend	; on to finish attacking
	; register a kill
.enkill	xor a		; store 0 in hero health
	ld (hero_h),a	; 
	pop hl		; retrieve pointer to enemy's block from stack
	ld a,(de)	; what is in the player's block?
	ld c,a		; store this for a moment
	and $0f		; preserve only the item they're standing by
	or $10		; set the item bit
	ld (de),a	; write that back to the map
	; prepare and print the " XXXXXXXX KILLS " message
	ld a,(hl)	; what's in the enemy's block?
	ld de,ehitms	; point to enemy name in forthcoming message
	call cpynam	; find and copy the enemy's name
	ld hl,ehitms	; point to the filled-in message
	jr nmaend	; on to finish attacking
	; register a miss
.enmiss	pop hl		; retrieve pointer to enemy from stack
	ld a,(hl)	; what is in this block?
	ld de,emisms	; point to enemy name in forthcoming message
	call cpynam	; find and copy enemy's name
	ld hl,emisms	; point to filled-in message
.nmaend	ld (wk_msg),hl	; save message pointer
	call drstat	; draw the hero stats
	; clean up and return
.nmedon	res 7,(ix+$03)	; reset the "chasing hero" bit
	pop hl		; retrieve corrupted registers
	pop de		;
	pop bc		;
	ret		; all done

	; control the necromancer
.necroc	push de		; preserve registers to be corrupted
	push hl		;
	ld a,(necrol)	; where is the necromancer?
	ld e,a		; store his location
	ld a,(hero_l)	; where is the hero?
	ld d,a		; store his location
	call calcds	; calculate the distance between them
	cp 1		; are they in adjacent squares?
	jr nz,nec_dn	; no, so done with the necromancer
	call mqueue	; output any queued message
	ld hl,cbttbl	; point to combat table, attack value
	ld (hl),20	; load with necromancer's modified attack value
	call herdef	; what's the hero's defence?
	inc hl		; point to combat table, defence value
	ld (hl),a	; store the hero's defence value
	call combat	; process one combat round
	or a		; did the necromancer hit?
	jr z,namiss	; no, so on to necromancer attack miss
	ld d,a		; put damage aside
	ld a,(hero_h)	; what's the hero's health?
	sub d		; subtract the damage
	jr z,nakill	; if dead, go to player kill
	jr c,nakill	;
	ld (hero_h),a	; store player's updated health
	ld hl,nhitms	; point to "necromancer hits" message
	call hitsnd	; play the "hit" sound
	jr nec_ms	; on to store message
.nakill	xor a		; ensure health is not negative
	ld (hero_h),a	; save health
	ld a,(hero_l)	; what's the player's location?
	call mapadr	; get the memory address
	ld a,(hl)	; what was there?
	;and $0f		; remove player leaving objects only behind
	;or $10		; now ensure this is an open path
	xor $30		; remove player bit and set open path bit
	ld (hl),a	; store this alteration on the map
	ld hl,nhitms	; point to "necromancer hits" message
	jr nec_ms	; on to store message
.namiss	ld hl,nmisms	; point to "necromancer miss" message
.nec_ms	ld (wk_msg),hl	; queue the message for printing
	call drstat	; draw the hero stats
.nec_dn	pop hl		; restore corrupted registers
	pop de		;
	ret		; done

	; determine hero's attack value
	; outputs:
	;   A = attack value for the hero
	;   DE = pointer to enemy on the map
.heratt	push hl		; preserve registers about to be corrupted
	ld a,$0c	; first check for a wand
	ld hl,herinv	; point to first item of inventory
	cp (hl)		; is it a wand?
	jr z,at_mag	; yes, set up magic attack
	inc hl		; otherwise look at second item of inventory
	cp (hl)		; is that a wand?
	jr z,at_mag	; yes, set up magic attack
	; check that hero *can* physically attack
	ld a,(de)	; what's at the enemy location?
	cp $30		; is it the necromancer?
	jr z,atphys	; yes, so we can attack him
	and $70		; isolate the enemy type
	cp $60		; is this a spectre or a daemon?
	jr c,atphys	; no, so we can attack this
	xor a		; otherwise the attack value is zero
	jr hraend	; go to finish
	; set up physical attack
.atphys	ld a,(hero_s)	; take hero's attack value
	ld hl,heroms	; point to hero's attack modifier
	jr at_mod	; go to apply modifier
	; set up magical attack
.at_mag	ld a,(hero_i)	; take hero's intelligence value
	ld hl,heromi	; point to hero's intelligence modifier
.at_mod	add (hl)	; add the hero's strength
.hraend	pop hl		; restore corrupted registers
	ret		; all done

	; calculate hero's defence
	; outputs:
	;   A = combat defence value
.herdef	push bc		; preserve registers to be corrupted
	push hl		;
	ld a,$0b	; check player for a wielded amulet
	ld hl,herinv	; point to first item of inventory
	cp (hl)		; is it an amulet?
	jr z,defmag	; yes, on to set up magic defence
	inc hl		; otherwise look at second item of inventory
	cp (hl)		; is that an amulet?
	jr z,defmag	; yes, on to set up magic defence
	ld a,(hero_a)	; load hero's defence value for conventional defence
	ld c,a		; store temporarily
	ld a,(heroma)	; take the hero's defence modifier
	jr defadd	; on to store defence value
.defmag	ld a,(hero_i)	; load hero's intelligence value for magic defence
	ld c,a		; store temporarily
	ld a,(heromi)	; take hero's intelligence modifier
.defadd	add a,c		; add the intelligence loaded earlier
	pop hl		; restore corrupted registers
	pop bc		;
	ret		; done

	; process one combat round
	; outputs:
	;   A = amount of damage caused
.combat	push bc		; store registers to be corrupted
	push hl		;
	ld hl,cbttbl	; point to attack chance in combat table
	call dice	; roll 2D6
	add a,(hl)	; add attack value
	inc a		; add an attack bonus
	ld b,a		; store this temporarily
	inc hl		; point to defence value
	call dice	; roll 2D6
	add a,(hl)	; add defence value
	ld c,a		; store this temporarily
	ld a,b		; retrieve attack value
	sub c		; subtract defence
	jr nc,cbthit	; if attacker not less than defence, possible hit
	xor a		; otherwise ensure A not less than zero
.cbthit	pop hl		; restore values of corrupted registers
	pop bc		;
	ret		; all done

	; roll a pair of dice
	; outputs:
	;   A = dice roll
.dice	push bc		; store values of registers to be corrupted
	push de		;
	push hl		;
	call rand16	; roll the dice
	ld hl,randsd	; point to first byte of random seed
	ld b,2		; there are two dice
	ld a,b		; minimum roll is 1 per dice
.othdie	ld c,a		; transfer the total to c
	ld d,(hl)	; load the die
	ld e,6		; we want it to be 6-sided
	call div8	; convert 00..ff to 0..5
	ld a,e		; transfer to A
	add c		; add running total
	inc hl		; point to next die
	djnz othdie	; continue till all dice rolled
	pop hl		; restore values of corrupted registers
	pop de		;
	pop bc		;
	ret		; all done

	; copy the name of an enemy in a square
	; inputs:
	;   A = contents of square
	;   DE = address to write enemy name to
.cpynam	push bc		; preserve registers to be corrupted
	push hl		;
	srl a		; convert to a message offset
	and $38		;
	ld c,a		; convert to a 16-bit offset
	ld b,0		;
	ld hl,nmenam	; point to the enemy name table
	add hl,bc	; advance pointer to name of this enemy
	ld bc,8		; there are 8 characters
	ldir		; transfer them
	pop hl		; restore corrupted registers
	pop bc		;
	ret		; all done

	; ascertain what direction to move in, checking also for blockages
	; inputs:
	;   D = current location
	;   E = destination location
	; outputs:
	;   A = 8-bit offset
	;   DE = 16-bit offset
.watdir	push bc		; store registers we will corrupt
	push hl		;
	; first ascertain the general direction - split into axes
	ld a,d		; take current location
	and $f0		; isolate vertical coordinate
	ld b,a		; store for comparison
	ld a,e		; take destination location
	and $f0		; isolate vertical coordinate
	call aritif	; compare receiving result -1, 0 or +1
	ld a,c		; transfer into A
	add a,a		; shift to give vertical offset
	add a,a		;
	add a,a		;
	add a,a		;
	ld (wdwksp),a	; store as first direction
	ld a,d		; take current location
	and $0f		; isolate horizontal coordinate
	ld b,a		; store for comparison
	ld a,e		; take destination location
	and $0f		; isolate horizontal coordinate
	call aritif	; compare receiving result -1, 0 or +1
	ld a,c		; transfer into a
	ld (wdwksp+1),a	; store as second direction
	; then scramble the two axes to reduce predictability
	call rand16	; get a random number
	ld a,(randsd)	; what is it?
	and $01		; just check least significant bit of all
	jr z,trydir	; if zero, skip the byte swap
	ld hl,(wdwksp)	; swap the two directions to try
	ld a,h		;
	ld h,l		;
	ld l,a		;
	ld (wdwksp),hl	;
	; now check the directions to find one that is not blocked
.trydir	ld b,2		; there are two directions to try
	ld hl,wdwksp	; starting with the first (!)
.chkdir	ld a,(hl)	; load the current direction
	or a		; is it zero?
	push de		; store locations for a moment
	push hl		; store workspace pointer for a moment
	jr z,nxtdir	; it's zero, we don't want to move on this axis
	ld hl,lvlmap	; point to the level map
	ld e,d		; calculate current location as 16-bit offset
	ld d,0		;
	add hl,de	; point to current location
	call ext816	; convert 8-bit direction to 16-bit offset DE
	add hl,de	; now HL points at adjacent block in desired direction
	ld a,(hl)	; check what is in the square
	cp $10		; some kind of wall block?
	jr c,nxtdir	; yes, so on to next direction
	cp $30		; is there some other character here?
	jr nc,nxtdir	; yes, so the way is blocked
.clrdir	pop hl		; retrieve the workspace pointer
	pop de		; pop locations of the stack
	ld a,(hl)	; check the current direction again
	call ext816	; convert 8-bit direction to 16-bit offset DE
	jr watd_d	; that's it, we're done
	; on to the next direction
.nxtdir	pop hl		; retrieve workspace pointer
	pop de		; retrieve locations
	inc hl		; look at next direction in the list
	djnz chkdir	; continue till both directions checked
	; both directions were blocked
	xor a		; put 0 into A and DE, as enemy can't move
	ld d,a		;
	ld e,a		;
	; finish off
.watd_d	pop hl		; restore corrupted registers
	pop bc		;
	ret		; all done
	; workspace
.wdwksp	defs 2		; two directions to look in

	; calculate a screen address from an 8-bit coordinate
	; inputs:
	;    A = coordinate
	; outputs:
	;    HL = address
.mapadr	push de		; store registers we are about to corrupt
	ld e,a		; convert 8-bit coordinate into 16-bit offset
	ld d,0		;
	ld hl,lvlmap	; point to level map
	add hl,de	; advance to address of correct block
	pop de		; restore corrupted registers
	ret		; all done

	; check if a creature should carry something when moving
	; inputs:
	;    A = contents of block from which creature moves
	; outputs:
	;    F(Z) = true if creature should carry
.chkcry	ld (wkcrry),a	; store unadulterated A
	and $70		; isolate bits identifying creature
	jr z,ccarry	; enemy is a bat - go to carrying code
	cp $40		; is enemy a cadaver?
	jr z,ccarry	; yes, go to carrying code
	cp $50		; is enemy a skeleton?
	jr z,ccarry	; yes, go to carrying code
	cp $70		; is enemy a daemon?
	jr z,ccarry	; yes, go to carrying code, otherwise do not carry
	ret		; the creature never carries anything, return NZ
.ccarry	ld a,(wkcrry)	; recall where the creature came from again
	and $0f		; isolate bits identifying what creature holds
	jr z,ncarry	; enemy carries nothing anyway
	cp $0f		; is enemy by the stairs?
	jr z,ncarry	; yes, they cannot carry these!
	cp a		; otherwise set the zero flag
	ret		; the creature is carrying something, return Z
.ncarry	cp $ff		; should always be nz
	ret		; the creature is carrying nothing, return NZ
	; data
.wkcrry	defs 1		; workspace

	; print a message waiting in the message queue
.mqueue	push bc		; preserve registers to be corrupted
	push de		;
	push hl		;
	or a		; clear the carry flag
	ld de,msgitm	; look at blank message
	ld hl,(wk_msg)	; what message is waiting to be printed?
	sbc hl,de	; is it the blank one?
	jr z,mqskip	; yes, so no need to display it
	add hl,de	; otherwise restore the message pointer
	call mapclc	; centre the map on the hero
	call mapdrw	; draw the map
	ld c,$17	; choose white on red ...
	call msgatr	; ... to colour the message bar
	ld b,50		; message for 1 second
	call notprt	; display the waiting message with a pause
.mqskip	pop hl		; restore corrupted registers
	pop de		;
	pop bc		;
	ret		; all done

	;
	; Data
	;

	; table for combat
	; offsets:
	;   0 = attacker's attack value
	;   1 = defender's defence value
.cbttbl	defs 2

	; pointer to message to print
.wk_msg	defs 2

	; messages for items
.msgitm	defm "                "
	defm "A PURSE OF GOLD "
	defm "A CASKET OF GOLD"
	defm "  A NICE APPLE  "
	defm "A HEALING POTION"
	defm " A SMALL DAGGER "
	defm "  A BROADSWORD  "
	defm "  A BATTLE AXE  "
	defm "A WOODEN SHIELD "
	defm " AN IRON SHIELD "
	defm " A BANISH SPELL "
	defm " A MAGIC AMULET "
	defm "  A MAGIC WAND  "
	defm "THE STAIRS DOWN "

	; combat messages
.uhitms	defm "YOU HIT XXXXXXXX"
.ukilms	defm " KILLED XXXXXXXX"
.umisms	defm " MISSED XXXXXXXX"
.ehitms	defm "XXXXXXXX HIT YOU"
.emisms	defm "XXXXXXXX MISSES "
.bansuc	defm " BANISHED ENEMY "
.ban_fl	defm "FAILED TO BANISH"
.hitnec	defm "YOU HIT SORCEROR"
.missnc	defm " MISSED SORCEROR"
.kilnec	defm "SORCEROR IS GONE"
.nhitms	defm "SORCEROR HIT YOU"
.nmisms	defm "SORCEROR MISSES "

	; enemy names
.nmenam	defm "BAT     "
	defm "VERMIN  "
	defm "ARACHNID"
	defm "SERPENT "
	defm "CADAVER "
	defm "SKELETON"
	defm "SPECTRE "
	defm "DAEMON  "