	;
	; Ossuary - an adventure game for the Sinclair ZX Spectrum
	; Tape Routines
	;
	; Routines for Loading and Saving Games, and for starting a new game.
	;
	; Copyright (C) Damian Walker 2012, 2013
	; Created: 12-Dec-2012 (for Barbarians)
	; Updated: 02-Mar-2013 (for Ossuary)
	;

	;
	; Save a Game
	;

	; prompt player to fire when ready
.savgam	ld hl,msgfsv	; "hit fire to save" message
	call tapfir	; wait for fire or other control
	jp z,cantap	; cancel saving
	ld hl,waitms	; "saving" message
	call msgprt	; print it

	; do the actual saving
	ld a,$ff	; tell ROM to save data, not header
	ld ix,glevel	; start of game variables
	ld de,datmax-glevel ; length of game variables
	ld hl,$0051	; false return address - EI then RET
	call $04c5	; call SA-BYTES+3
	xor a		; we want the border to be black whether ...
	out ($fe),a	; ... save was successful or not
	
	; all done
	ld hl,savmsg	; point to "game saved" message
	call msgprt	; print it
	jp moves	; return to main game loop

	;
	; Load a game
	;

	; prompt player to fire when ready
.lodgam	ld hl,msgfld	; "hit fire to load" message
	call tapfir	; wait for fire or other control
	jr z,cantap	; cancel loading
	ld hl,waitms	; "loading" message
	call msgprt	; print it

	; set up the loading
	ld a,$ff	; tell ROM to load data, not header
	ld ix,lodbuf	; start of game variables
	ld de,datmax-glevel ; length of game variables
	scf		; set carry flag for LOAD (not VERIFY)

	; call the loading routine, skipping its RST08 error stuff
	inc d		; the lines up to LD HL are copied from the ...
	ex af,af'	; ... ROM ld-bytes routine, and are designed to ...
	dec d		; ... avoid the ROM's own false return address ...
	di		; ... code which returns to BASIC when an error ...
	ld a,$0f	; ... occurs in loading.
	out ($fe),a	;
	ld hl,$0051	;
	call $0561	; call part way into ld-bytes
	xor a		; we want the border to be black again ...
	out ($fe),a	; ... whether an error occurs or not
	
	; check for incomplete load
	or e		; check bytes remaining count (lower half)
	jr nz,loderr	; error if not zero
	or d		; check bytes remaining count (upper half)
	jr nz,loderr	; error if not zero

	; transfer contents of load buffer onto game data store
	ld hl,lodbuf	; point origin to loading buffer
	ld de,glevel	; point destination to game data
	ld bc,datmax-glevel ; set number of bytes
	ldir		; transfer them

	; now update the screen with the new game
	call drstat	; update the stats panel
	call drgold	; display the gold rating
	call dr_inv	; update the inventory panel
	call mapclc	; re-centre map on hero location
	call mapdrw	; redraw the map
	call shwlvl	; show "level" header
	ld hl,lodmsg	; point to "loaded" message
	call msgprt	; print the level message

	; all done
.loddon	jp moves	; return to main game loop

	; loading error detected
.loderr	ld hl,msglde	; point to loading error message
	call tapfir	; wait for fire
	jr loddon	; return to main game loop

	;
	; Confirm a new game is wanted
	;

	; prompt player to fire when needed
.newgmc	ld hl,firmsg	; "fire for new map" message
	call tapfir	; wait for fire or another control
	jr z,cantap	; cancel if something other than fire pressed
	jp newgam	; otherwise new game

	; wait for fire to be pressed, return nz if it is
	; inputs:
	;   HL = address of message to print
.tapfir	call msgprt	; print message
	call ctlrel	; wait for controls to be released
	call ctlact	; is anything activated?
	bit 4,a		; is it fire?
	ret		; all done

	; display "cancelled" message and continue game
.cantap	ld hl,canmsg	; point to "cancelled" message
	call msgprt	; print it
	jp moves	; back to movement

	;
	; Variables and Data
	;

	; load buffer - used to temporarily store loaded data
.lodbuf	defs datmax-glevel

	; messages
.msgfsv	defm "  FIRE TO SAVE  "
.msgfld	defm "  FIRE TO LOAD  "
.msglde	defm " FAILED TO LOAD "
.canmsg	defm "ACTION CANCELLED"
.savmsg	defm "   GAME SAVED   "
.lodmsg	defm " GAME IS LOADED "