	;
	; Ossuary - an adventure game for the Sinclair ZX Spectrum
	; Variables and Pointers
	;
	; Copyright (C) Damian Walker 2013
	; Created 29-Jan-2013
	;

	;
	; Contents
	;

	; display contents
defc	msgpos = $5068		; address of message display line 1st char top
defc	msglen = $10		; 16 characters in  display window

	;
	; Addresses of variables in memory
	;

	; player control
defc	ctlopt = $5cd0		; control option saved here
defc	menopt = ctlopt + 1	; menu option chosen

	; random number generation
defc	randsd = menopt + 1	; the full random number seed
defc	randsl = randsd		; low byte of RANDSD
defc	randsh = randsd + 1	; high byte of RANDSD

	; game variables
defc	glevel = randsd + 2	; current game level
defc	nmemin = glevel + 1	; minimum enemy for this level
defc	nmemax = nmemin + 1	; maximum enemy for this level
defc	nmeagr = nmemax + 1	; average enemy aggression for this level
defc	hero_s = nmeagr + 1	; hero strength
defc	hero_a = hero_s + 1	; hero agility
defc	hero_i = hero_a + 1	; hero intelligence
defc	hero_h = hero_i + 1	; hero health
defc	heroms = hero_h + 1	; hero strength modifier (weaponry)
defc	heroma = heroms + 1	; hero agility modifier (shields)
defc	heromi = heroma + 1	; hero intelligence modifier (amulet?)
defc	heromh = heromi + 1	; hero health modifer (poison?)
defc	herinv = heromh + 1	; hero inventory (12 bytes)
defc	hergld = herinv + 12	; hero gold score (2 bytes)
defc	lvlmap = hergld + 2	; level map (256 bytes)
defc	hero_l = lvlmap + 256	; hero's current location
defc	nmetbl = hero_l + 1	; enemy table (32 bytes)
defc	lstitm = nmetbl + 32	; last item referenced
defc	exp_pt = lstitm + 1	; experience points
defc	necroh = exp_pt + 1	; necromancer health
defc	necrol = necroh + 1	; necromancer location
	; end of data
defc	datmax = necrol + 1	; needs updating if more added

	; level map byte codes (binary)
	;   000000xx - wall section of type xx      - show xx
	;   00010000 - floor section                - show floor
	;   0001xxxx - object xxxx                  - show object xxxx
	;   0010xxxx - hero over object xxxx        - show hero
	;   0011xxxx - necromancer over object xxxx - show necromancer
	;   1xxxyyyy - enemy xxx over object yyyy   - show enemy xxx
	; object codes
	;   0000 - none
	;   0001 - purse
	;   :  : - (2-11 other appropriate objects)
	;   1100 - wand
	;   1111 - stairs
	; enemy table entries
	;   +$00 - location
	;   +$01 - health
	;   +$02 - behaviour
	;   +$03 - aggression